# Getting Started — Your First 90 Days

*This is a general educational framework. Individual circumstances vary.*

## Week 1-2: Foundation

**Don't open a brokerage account yet.**

1. Pick ONE market to learn (stocks recommended for beginners — most resources available)
2. Learn basic terminology: bid/ask, spread, volume, candlestick charts
3. Understand different order types: market, limit, stop, stop-limit
4. Watch market open/close for a few days without trading

## Week 3-4: Demo Trading

1. Open a demo/paper trading account (most brokers offer these free)
2. Start with $10,000-$50,000 fake money
3. Trade small position sizes as if the money were real
4. Record every trade in a journal: why you entered, where your stop was, outcome

## Month 2: Pattern Recognition

1. Focus on 2-3 chart patterns maximum
2. Practice identifying patterns in real-time (not just hindsight)
3. Track win rate and average win vs average loss
4. If win rate × average win < loss rate × average loss, you're not ready

## Month 3: Small Live Account (Optional)

Only if demo results are consistently profitable:

1. Open account with money you can afford to lose 100%
2. Start with smaller position sizes than demo
3. Expect emotions to interfere — this is normal
4. If you blow the account, return to demo

## How Much Money Do You Need?

| Market | Practical minimum | Notes |
|--------|------------------|-------|
| US Stocks (no day trading) | $500-1,000 | Commission-free brokers help |
| US Stocks (day trading) | $25,000+ | PDT rule requires this for 4+ day trades/week |
| Forex | $500-2,000 | High leverage available but dangerous |
| Crypto | $100+ | 24/7 markets, high volatility |

**Warning:** Starting with more money doesn't improve your odds. Master the skill first with small amounts.

## Red Flags You're Not Ready

- Checking positions constantly
- Unable to accept a losing trade
- Moving stop losses further away hoping for recovery
- Increasing position size after losses
- Trading out of boredom

## Resources

- **Books:** Start with market basics before strategy books
- **Practice platforms:** Most brokers offer paper trading
- **Communities:** Careful of "gurus" selling courses; most profitable traders don't sell education
