# Trading Strategies Reference

## Dollar Cost Averaging (DCA)

### Basic DCA Strategy

**Definition**: Investing a fixed dollar amount at regular intervals regardless of price.

**How It Works**:
- Invest $100 every week for 52 weeks = $5,200 total
- Buy more units when price is low
- Buy fewer units when price is high
- Average cost per unit decreases over time

**Advantages**:
- Eliminates timing risk
- Reduces emotional decision-making
- Simple to execute
- Works well in volatile markets
- Accumulates more during dips

**Disadvantages**:
- May underperform lump sum in bull markets
- Requires discipline during fear
- Transaction fees add up (use low-fee exchanges)
- Not optimal if you have strong market timing

**Best For**:
- Conservative investors
- Long-term accumulation
- Volatile assets like Bitcoin
- Investors who fear market timing

### DCA Variants

#### 1. Fixed Amount DCA
```
Every Monday: Buy $100 of BTC regardless of price
Duration: 12 months
Total: $5,200
```

**Pros**: Simple, consistent
**Cons**: Doesn't adapt to market conditions

#### 2. Value-Based DCA (Buy the Dip)
```
When BTC < $95,000: Buy $150 (normal + $50 extra)
When BTC > $105,000: Buy $50 (reduce exposure)
When BTC $95k-$105k: Buy $100 (normal)
```

**Pros**: Adapts to market, buys more on dips
**Cons**: More complex, requires monitoring

#### 3. RSI-Based DCA
```
RSI < 30 (oversold): Buy $200 (double down)
RSI 30-70 (neutral): Buy $100 (normal)
RSI > 70 (overbought): Buy $50 (reduce) or skip
```

**Pros**: Uses technical signals, buys more when oversold
**Cons**: Can miss rallies, requires TA knowledge

#### 4. Ladder DCA
```
Week 1-4: $50/week (accumulation start)
Week 5-8: $75/week (increase exposure)
Week 9-12: $100/week (full position)
Week 13+: $100/week (maintain)
```

**Pros**: Gradual exposure, risk management
**Cons**: Slower accumulation initially

#### 5. Reverse DCA (Taking Profits)
```
Every month: Sell $100 worth of BTC
Or: When price up 10%, sell 5% of holdings
```

**Pros**: Lock in profits systematically
**Cons**: May exit too early in bull market

---

## Risk Management Strategies

### The 1-2% Rule

**Definition**: Risk no more than 1-2% of your account per trade.

**How to Calculate**:
```
Account Balance: $10,000
Risk per Trade: 2% = $200 maximum loss
Entry: $100,000
Stop Loss: $95,000 (5% down)
Position Size: $200 / ($100,000 - $95,000) = $4,000 position

If stop hit, you lose $200 (2% of account)
```

**Benefits**:
- Survive losing streaks (50 consecutive 2% losses = still have capital)
- Reduces emotional stress
- Allows for recovery

**Implementation**:
- Use position_sizer.py to calculate
- Always set stop loss before entry
- Stick to the rule even during FOMO

### Stop Loss Strategies

#### 1. Fixed Percentage Stop
```
Entry: $100,000
Stop Loss: 5% = $95,000
```

**Pros**: Simple, consistent
**Cons**: Doesn't adapt to volatility

#### 2. ATR-Based Stop
```
Entry: $100,000
ATR (14): $2,500
Stop Loss: Entry - (2 × ATR) = $100,000 - $5,000 = $95,000
```

**Pros**: Adapts to volatility
**Cons**: Requires ATR calculation

#### 3. Support-Based Stop
```
Entry: $100,000
Previous support: $96,000
Stop Loss: $95,500 (below support)
```

**Pros**: Based on price structure
**Cons**: May be too wide or too tight

#### 4. Trailing Stop
```
Entry: $100,000
Initial Stop: $95,000 (5%)
Price moves to $110,000
Trailing Stop: $104,500 (5% from current)
```

**Pros**: Locks in profits as price rises
**Cons**: Can get stopped out in volatile moves

### Take Profit Strategies

#### 1. Fixed Risk-Reward
```
Entry: $100,000
Stop Loss: $95,000 (Risk: $5,000)
Take Profit: $110,000 (Reward: $10,000)
Risk:Reward = 1:2
```

**Rule**: Only take trades with R:R ≥ 2:1 (conservative) or ≥ 3:1 (very conservative)

#### 2. Ladder Out (Scaling Out)
```
Entry: $100,000 (Position: 1 BTC)
TP1: $105,000 - Sell 33% (0.33 BTC)
TP2: $110,000 - Sell 33% (0.33 BTC)
TP3: $115,000 - Sell 34% (0.34 BTC)
```

**Pros**: Captures gains, reduces risk
**Cons**: Smaller profit if price goes straight up

#### 3. Trend-Following Exit
```
Exit when:
- Price closes below 20 EMA
- RSI drops below 40 after being overbought
- MACD bearish crossover
```

**Pros**: Rides trends longer
**Cons**: Gives back some profits

---

## Trend Following Strategies

### Moving Average Crossover

#### Golden Cross Strategy (Conservative)
```
Buy: When 50 SMA crosses above 200 SMA
Hold: While 50 SMA > 200 SMA
Sell: When 50 SMA crosses below 200 SMA
```

**Characteristics**:
- Long-term (months to years)
- Few signals (1-2 per year)
- Late entries but reliable

#### EMA Ribbon Strategy
```
Use: EMA 9, 21, 55
Buy: When 9 > 21 > 55 (all aligned)
Sell: When 9 < 21 < 55 (reverse)
```

**Characteristics**:
- Medium-term (weeks to months)
- More signals than Golden Cross
- Earlier entries

### Breakout Strategy

#### Resistance Breakout
```
Identify: Strong resistance at $100,000
Wait: For 3+ tests of resistance
Entry: Break above $100,100 with volume
Stop: Below recent low (e.g., $97,000)
Target: Previous range height added to breakout
```

**Example**:
```
Range: $95,000 - $100,000 (height: $5,000)
Breakout: $100,100
Target: $100,000 + $5,000 = $105,000
```

**Rules**:
- Volume must confirm (>1.5x average)
- Wait for retest of breakout level (optional but safer)
- Use tight stop initially

---

## DCA + Risk Management Combined

### Conservative DCA Portfolio Strategy

**Account**: $10,000
**Goal**: Accumulate BTC over 6 months
**Risk Tolerance**: Conservative

**Plan**:
```
Weekly DCA: $100 (Total: $2,600 over 6 months)
Reserve: $7,400 for opportunities

DCA Rules:
- Buy $100 of BTC every Monday at 9 AM
- If RSI < 30: Buy $150 instead
- If price drops >15% in week: Buy $200 extra
- Never skip a week (discipline)

Risk Management:
- Don't use leverage
- Keep 50% of account in stablecoins
- Only increase DCA amount if profit > 20%
```

### Moderate DCA + Swing Trading

**Account**: $20,000
**Goal**: Accumulate + active trading

**Plan**:
```
Core DCA: $500/month ($6,000/year)
Trading Capital: $14,000

DCA:
- Automatic buys, never sell these
- Cold storage after 3 months

Trading:
- Use technical_analysis.py for entries
- Risk 1% per trade ($140 per trade)
- Only trade with indicators aligned
- Take profits at 2:1 R:R minimum

Monthly Review:
- Calculate average cost basis
- Review trading performance
- Adjust if losing money
```

---

## Entry Strategies

### Three Confirmation Strategy (Conservative)

**Required Before Entry**:
1. **Trend**: Price above 50 EMA
2. **Momentum**: RSI 40-60 (not overbought)
3. **Volume**: Current volume > 20-period average
4. **Support**: Price near support level
5. **Pattern**: Bullish candlestick pattern

**Action**: Buy when 4/5 conditions met

### Pullback Entry Strategy

**Setup**:
1. Identify strong uptrend (price > 50 EMA)
2. Wait for pullback to 20 EMA or 50 EMA
3. Check RSI (should be 40-50, not oversold)
4. Wait for bullish candle close above EMA
5. Enter on next candle

**Example**:
```
BTC uptrend from $90k to $105k
Pullback to $101k (touches 20 EMA)
RSI at 45 (neutral)
Bullish engulfing candle closes at $102k
Entry: $102,500
Stop: $99,000 (below EMA)
Target: $108,000 (previous high + extension)
```

---

## Position Sizing Examples

### Scenario 1: Conservative DCA
```
Account: $5,000
Strategy: Pure DCA
Risk: None (not using stop loss, long-term hold)

Weekly: $50 for 20 weeks = $1,000 invested
Remaining: $4,000 cash reserve

Position Size: Grows slowly, no risk of liquidation
```

### Scenario 2: Moderate Trading
```
Account: $10,000
Strategy: Swing trading
Risk: 2% per trade = $200 max loss

Entry: $100,000
Stop: $97,000 (3% move)
Position Size: $200 / $3,000 = 0.0667 BTC = $6,667

If stopped out: Lose $200 (2% of account)
If target hit (+6%): Win $400 (4% of account)
```

### Scenario 3: Aggressive (Not Recommended)
```
Account: $10,000
Strategy: Leverage trading
Risk: 5% per trade = $500 max loss
Leverage: 3x

Position: $10,000 × 3 = $30,000 exposure
Stop: 1.67% = $500 loss
⚠ High risk of liquidation in volatile moves
```

**Recommendation**: Avoid leverage until very experienced

---

## Common Strategy Mistakes

### 1. No Risk Management
```
❌ Buy without stop loss
❌ Risk entire account on one trade
❌ Use high leverage

✅ Always set stop loss
✅ Risk 1-2% per trade
✅ Avoid leverage (or use <2x)
```

### 2. Emotional DCA
```
❌ Skip buys during fear
❌ Double down during FOMO
❌ Sell DCA accumulation early

✅ Stick to schedule
✅ Increase buys when oversold (planned)
✅ Hold DCA positions long-term
```

### 3. Overtrading
```
❌ Take every setup
❌ Trade with conflicting signals
❌ Revenge trading after loss

✅ Wait for quality setups
✅ Need 3+ confirmations
✅ Take break after 2 consecutive losses
```

### 4. No Plan
```
❌ Enter without knowing exit
❌ No stop loss level
❌ No profit target

✅ Plan entry, stop, target before trade
✅ Write down your plan
✅ Follow the plan
```

---

## Strategy Selection Guide

### Choose Pure DCA If:
- You're new to trading
- You have a long-term view (1+ years)
- You don't want to monitor markets daily
- You believe in Bitcoin long-term
- You want to minimize stress

### Choose DCA + Position Trading If:
- You have trading experience
- You can handle volatility
- You want to optimize entries
- You're willing to learn TA
- You have time for research

### Avoid Active Trading If:
- You're emotional under pressure
- You can't handle losses
- You don't have time to monitor
- You're new to crypto
- You need the money short-term

---

## Recommended Starting Strategy

**Month 1-3: Pure DCA**
- Learn the ropes
- Start with $50-100/week
- Don't deviate from schedule
- Study charts and indicators
- Paper trade strategies

**Month 4-6: Enhanced DCA**
- Add value-based adjustments (buy more on dips)
- Use RSI to guide amounts
- Keep 50% in reserve
- Small position trades (<10% of account)

**Month 7+: DCA + Conservative Trading**
- Maintain core DCA ($X/week)
- Trade with 20-30% of account
- Risk 1% per trade
- Only take high-probability setups
- Review monthly performance

---

## Performance Tracking

### Metrics to Track

1. **DCA Average Cost**: What's your average entry price?
2. **Win Rate**: % of winning trades
3. **Risk:Reward Ratio**: Average gain vs average loss
4. **Max Drawdown**: Largest account decline
5. **Monthly Return**: % gain/loss per month

### Review Questions

- Are you following your rules?
- What's your emotional state during trades?
- Are losses within acceptable range?
- Is the strategy sustainable long-term?
- Would you be happy if this continued for a year?

### When to Adjust

**Reduce risk if**:
- 3+ consecutive losses
- Emotional stress increasing
- Deviating from plan often
- Losing >5% of account in a month

**Increase position size if**:
- Consistently profitable for 3+ months
- Following rules strictly
- Emotional control strong
- Account grown >20%

---

## Final Advice for Conservative Traders

1. **Start small**: Better to be cautious than broke
2. **DCA is king**: Time in market > timing the market
3. **Risk management first**: Preserve capital, profits come second
4. **No leverage**: Sleep well at night
5. **Have a plan**: Know your exit before entry
6. **Journal trades**: Learn from mistakes
7. **Be patient**: Wealth compounds slowly
8. **Stay humble**: Market humbles everyone eventually
9. **Keep learning**: Markets evolve, so should you
10. **Enjoy the process**: If it's not fun, you won't last

**Remember**: The goal is to still be trading next year, not to get rich next week.
