# Technical Indicators Reference

## Moving Averages

### Simple Moving Average (SMA)

**Formula**: Sum of closing prices over N periods / N

**Common Periods**: 20, 50, 100, 200

**Interpretation**:
- Price above SMA = Uptrend
- Price below SMA = Downtrend
- SMA acts as support in uptrends, resistance in downtrends

**Trading Signals**:
- **Golden Cross**: Short-term MA (50) crosses above long-term MA (200) = Bullish
- **Death Cross**: Short-term MA (50) crosses below long-term MA (200) = Bearish

**Best For**: Identifying trend direction, support/resistance levels

### Exponential Moving Average (EMA)

**Formula**: EMA = Price(t) × k + EMA(y) × (1-k)
- k = 2 / (N + 1)
- More weight to recent prices

**Common Periods**: 12, 26, 50, 200

**Interpretation**:
- More responsive to recent price changes than SMA
- Reacts faster to trend changes

**Trading Signals**:
- **EMA Crossover**: Fast EMA (12) crosses above slow EMA (26) = Buy signal
- **EMA Support/Resistance**: Price bouncing off EMA levels

**Best For**: Short-term trading, faster trend identification

---

## Momentum Indicators

### Relative Strength Index (RSI)

**Formula**: RSI = 100 - [100 / (1 + RS)]
- RS = Average Gain / Average Loss over N periods

**Common Settings**: 14 periods

**Range**: 0 to 100

**Interpretation**:
- **Overbought**: RSI > 70 (potential reversal down)
- **Oversold**: RSI < 30 (potential reversal up)
- **Neutral**: RSI 30-70

**Trading Signals**:
- **Divergence**: Price makes new high/low but RSI doesn't = Reversal signal
- **Failure Swing**: RSI fails to exceed previous high/low = Trend weakening
- **Centerline Crossover**: RSI > 50 = Bullish, RSI < 50 = Bearish

**Best For**: Identifying overbought/oversold conditions, divergences

**Conservative Usage**:
- Don't trade RSI signals alone
- Use with trend confirmation
- In strong trends, RSI can stay overbought/oversold for extended periods

### MACD (Moving Average Convergence Divergence)

**Formula**:
- MACD Line = EMA(12) - EMA(26)
- Signal Line = EMA(9) of MACD Line
- Histogram = MACD Line - Signal Line

**Interpretation**:
- **Bullish**: MACD Line > Signal Line
- **Bearish**: MACD Line < Signal Line
- **Momentum**: Histogram shows strength

**Trading Signals**:
- **MACD Crossover**: MACD crosses above signal = Buy, below = Sell
- **Centerline Crossover**: MACD crosses above 0 = Bullish, below = Bearish
- **Divergence**: Price vs MACD disagreement = Potential reversal

**Best For**: Trend following, momentum analysis

**Conservative Usage**:
- Wait for crossover confirmation (not just touch)
- Consider histogram direction (increasing momentum)
- Best in trending markets, less effective in ranging markets

---

## Volatility Indicators

### Bollinger Bands

**Formula**:
- Middle Band = SMA(20)
- Upper Band = SMA(20) + (2 × Standard Deviation)
- Lower Band = SMA(20) - (2 × Standard Deviation)

**Common Settings**: 20 periods, 2 standard deviations

**Interpretation**:
- **Band Width**: Wide = High volatility, Narrow = Low volatility
- **Price Position**: Near upper = Overbought, Near lower = Oversold
- **Squeeze**: Narrow bands = Volatility expansion coming

**Trading Signals**:
- **Bounce**: Price bounces off bands (mean reversion)
- **Breakout**: Price moves outside bands = Strong momentum
- **Walking the Bands**: Price stays near upper/lower band = Strong trend
- **Squeeze & Break**: Bands narrow, then price breaks out with volume

**Best For**: Volatility analysis, overbought/oversold in ranging markets

**Conservative Usage**:
- Don't sell at upper band in strong uptrends (can "walk the band")
- Wait for confirmation before acting on band touches
- Use with RSI for better signals

### Average True Range (ATR)

**Formula**: Average of True Range over N periods
- True Range = max(High-Low, |High-Close_prev|, |Low-Close_prev|)

**Common Settings**: 14 periods

**Interpretation**:
- **High ATR**: Increased volatility
- **Low ATR**: Decreased volatility
- Not directional (doesn't predict up/down)

**Trading Signals**:
- **Position Sizing**: Use ATR for stop loss placement
- **Breakout Confirmation**: Breakouts with rising ATR = Stronger
- **Volatility Expansion**: Rising ATR = Potential trend start

**Best For**: Risk management, stop loss placement

---

## Volume Indicators

### Volume Analysis

**Types**:
- **Volume Spike**: > 2x average volume = Significant interest
- **Volume Divergence**: Price rising but volume falling = Weak trend
- **Climax Volume**: Extreme volume = Potential reversal

**Interpretation**:
- **High Volume + Price Up**: Strong buying (bullish)
- **High Volume + Price Down**: Strong selling (bearish)
- **Low Volume**: Lack of conviction

**Trading Signals**:
- **Breakout Confirmation**: Breakout with high volume = Legitimate
- **Trend Confirmation**: Uptrend with increasing volume = Healthy
- **Reversal Warning**: Volume spike at extreme = Potential top/bottom

### On-Balance Volume (OBV)

**Formula**:
- If Close > Close_prev: OBV = OBV_prev + Volume
- If Close < Close_prev: OBV = OBV_prev - Volume
- If Close = Close_prev: OBV = OBV_prev

**Interpretation**:
- Rising OBV = Accumulation (buying pressure)
- Falling OBV = Distribution (selling pressure)

**Trading Signals**:
- **Divergence**: Price up but OBV down = Bearish
- **Confirmation**: Price and OBV moving together = Strong trend

---

## Support & Resistance

### Pivot Points

**Formula** (Standard):
- Pivot = (High + Low + Close) / 3
- R1 = 2 × Pivot - Low
- S1 = 2 × Pivot - High
- R2 = Pivot + (High - Low)
- S2 = Pivot - (High - Low)

**Interpretation**:
- Price above Pivot = Bullish sentiment
- Price below Pivot = Bearish sentiment

**Trading Signals**:
- Use R1, R2, R3 as resistance targets
- Use S1, S2, S3 as support targets
- Breakout above/below pivot = Trend signal

### Fibonacci Retracement

**Levels**: 23.6%, 38.2%, 50%, 61.8%, 78.6%

**Usage**:
- Draw from swing low to swing high (uptrend)
- Draw from swing high to swing low (downtrend)

**Interpretation**:
- **Common Retracement**: 38.2% - 61.8%
- **Strong Support**: 61.8% level
- **Trend Continuation**: Bounce from retracement level

**Trading Signals**:
- **Buy Opportunity**: Uptrend retraces to 50-61.8% with support
- **Sell Opportunity**: Downtrend retraces to 50-61.8% with resistance

---

## Combining Indicators

### Trend + Momentum
- **EMA(20) + RSI**: Trend direction + Entry timing
- **SMA(50/200) + MACD**: Major trend + Momentum confirmation

### Volatility + Support/Resistance
- **Bollinger Bands + Fibonacci**: Volatility + Key levels
- **ATR + Support/Resistance**: Stop loss placement

### Volume Confirmation
- **Any indicator + Volume**: Confirm signals with volume

---

## Common Settings for Different Timeframes

### Day Trading (Minutes to Hours)
- **EMA**: 9, 20, 50
- **RSI**: 7 or 14
- **MACD**: 12, 26, 9
- **Bollinger Bands**: 20 periods, 2 SD
- **Volume**: Compare to 20-period average

### Swing Trading (Days to Weeks)
- **EMA**: 20, 50, 200
- **RSI**: 14
- **MACD**: 12, 26, 9
- **Bollinger Bands**: 20 periods, 2 SD
- **Volume**: Compare to 50-period average

### Position Trading (Weeks to Months)
- **SMA**: 50, 100, 200
- **RSI**: 14 or 21
- **MACD**: 12, 26, 9
- **Bollinger Bands**: 20 periods, 2 SD
- **Volume**: Compare to 100-period average

---

## Indicator Reliability

**Most Reliable**:
- Moving Averages (trend identification)
- Volume (confirmation)
- Support/Resistance levels

**Moderate Reliability**:
- RSI (overbought/oversold)
- MACD (trend changes)
- Bollinger Bands (volatility)

**Less Reliable Alone**:
- Stochastic Oscillator
- Williams %R
- Single-indicator systems

---

## Common Mistakes

1. **Using too many indicators**: Leads to analysis paralysis
2. **Ignoring price action**: Indicators lag price
3. **Trading against the trend**: Indicator signals in wrong direction
4. **No confirmation**: Acting on single indicator signal
5. **Wrong timeframe**: Using day-trading indicators for swing trading
6. **Ignoring volume**: Volume confirms price moves
7. **Over-optimizing**: Finding perfect settings for past data

---

## Conservative Trading Approach

**Minimum Confirmations** (pick 3):
1. Trend alignment (price above/below key MA)
2. Momentum confirmation (RSI/MACD agrees)
3. Volume confirmation (above average on signal)
4. Support/Resistance (near key level)
5. Multiple timeframe agreement

**Don't Trade**:
- Against major trend
- Without stop loss
- Based on single indicator
- During low volume periods
- When multiple indicators conflict

**Wait For**:
- Clear trend establishment
- Multiple confirmations
- Volume increase
- Risk:reward ratio > 2:1
