# 质量评分体系

## 评分概览

8维度加权评分系统，每维度0-100分，综合评分为加权平均。

| 维度 | 权重 | 说明 |
|------|------|------|
| 入场质量 | 18% | 评估入场时机和技术指标配合度 |
| 出场质量 | 17% | 评估止盈止损执行和出场时机 |
| 趋势把握 | 14% | 评估顺势/逆势交易及趋势强度 |
| 风险管理 | 12% | 评估R:R比率、MAE/MFE控制 |
| 市场环境 | 11% | 评估入场时市场状态适配度 |
| 交易行为 | 11% | 评估纪律性、冲动交易检测 |
| 新闻契合 | 7% | 评估交易与新闻背景一致性 |
| 执行质量 | 5% | 评估滑点、成交效率 |
| 期权评分 | 5% | 仅期权：Greeks、DTE、Moneyness |

## 评分等级

| 分数范围 | 等级 | 说明 |
|----------|------|------|
| 90-100 | A | 优秀 - 各维度表现出色 |
| 80-89 | B | 良好 - 整体表现不错 |
| 70-79 | C | 一般 - 有改进空间 |
| 60-69 | D | 较差 - 需要调整策略 |
| 0-59 | F | 很差 - 存在严重问题 |

---

## 入场质量评分 (18%)

评估入场时机是否合理。

### 评估因素

| 因素 | 权重 | 说明 |
|------|------|------|
| 技术指标配合 | 40% | RSI、MACD、布林带等是否支持入场方向 |
| 支撑阻力位置 | 30% | 是否在关键价位入场 |
| 成交量确认 | 20% | 是否有放量确认 |
| 市场环境 | 10% | 大盘状态是否有利 |

### 技术指标评分细则

**RSI (相对强弱指数)**
- 做多：RSI < 30 得 95 分，30-40 得 80 分，40-50 得 65 分
- 做空：RSI > 70 得 95 分，60-70 得 80 分，50-60 得 65 分
- 超买买入/超卖卖出：扣 30-50 分

**MACD**
- 金叉做多/死叉做空：+20 分
- 背离确认：+15 分
- 柱状图方向一致：+10 分

**布林带**
- 突破下轨做多/上轨做空：+15 分
- 在轨道外入场：-10 分

---

## 出场质量评分 (17%)

评估出场时机和止盈止损执行。

### 评估因素

| 因素 | 权重 | 说明 |
|------|------|------|
| 止盈执行 | 30% | 是否在目标位出场 |
| 止损纪律 | 30% | 是否及时止损 |
| 出场时机 | 20% | 是否抓住最佳出场点 |
| 持仓管理 | 20% | 持仓时间是否合理 |

### 评分细则

**盈亏百分比**
- 盈利 > 5%：+20 分
- 盈利 2-5%：+10 分
- 盈利 0-2%：+5 分
- 亏损 0-2%：-5 分
- 亏损 2-5%：-10 分
- 亏损 > 5%：-20 分

**止损控制**
- 亏损 < 2%：止损执行良好
- 亏损 2-5%：止损基本到位
- 亏损 > 10%：止损失败，严重扣分

---

## 趋势把握评分 (14%)

评估是否顺势交易。

### 评估因素

| 因素 | 权重 | 说明 |
|------|------|------|
| 方向一致性 | 40% | 交易方向与趋势是否一致 |
| 趋势强度 | 30% | ADX 趋势强度 |
| 动量配合 | 30% | MACD、RSI 动量方向 |

### ADX评分

| ADX值 | 趋势强度 | 评分调整 |
|-------|----------|----------|
| > 40 | 极强趋势 | +15 |
| 25-40 | 强趋势 | +10 |
| 20-25 | 中等趋势 | +5 |
| < 20 | 弱趋势/震荡 | -5 |

---

## 风险管理评分 (12%)

评估风险控制能力。

### 评估因素

| 因素 | 权重 | 说明 |
|------|------|------|
| R:R 比率 | 40% | 风险回报比 |
| MAE 控制 | 30% | 最大不利偏移控制 |
| MFE 利用 | 30% | 最大有利偏移利用率 |

### R:R评分

| R:R | 评分 |
|-----|------|
| > 3 | 95 |
| 2-3 | 85 |
| 1.5-2 | 75 |
| 1-1.5 | 65 |
| < 1 | 50 |

### 费用控制

- 费用占盈亏 < 5%：+15 分
- 费用占盈亏 5-10%：+5 分
- 费用占盈亏 > 20%：-15 分

---

## 市场环境评分 (11%)

评估入场时市场状态适配度。

- 顺大盘方向：+10 分
- VIX 较低时入场：+5 分
- 避开财报/重大事件：+5 分

---

## 交易行为评分 (11%)

评估交易纪律和行为模式。

- 无追涨杀跌：+10 分
- 持仓时间合理：+10 分
- 无频繁交易：+5 分
- 无情绪化交易：+5 分

---

## 期权专属评分 (5%)

仅适用于期权交易。

### 入场评估

| 维度 | 权重 | 最优条件 |
|------|------|----------|
| Moneyness | 25% | ATM ± 5% |
| 趋势一致性 | 25% | Call配多头/Put配空头 |
| 波动率环境 | 25% | IV中等 |
| 时间价值 | 25% | DTE 30-60天 |

### Moneyness评分

| Moneyness | 说明 | 评分 |
|-----------|------|------|
| ATM ± 2% | 平值附近 | 90 |
| ITM 2-5% | 实值 | 80 |
| OTM 2-5% | 虚值 | 70 |
| OTM > 10% | 深度虚值 | 50 |

### DTE评分

| DTE | 说明 | 评分 |
|-----|------|------|
| 30-60天 | 理想范围 | 90 |
| 14-30天 | 可接受 | 75 |
| 7-14天 | 风险较高 | 60 |
| < 7天 | Theta加速 | 40 |

---

## 综合评分计算

### 股票交易

```
综合评分 = 入场(18%) + 出场(17%) + 趋势(14%) + 风险(12%) 
         + 市场环境(11%) + 行为(11%) + 新闻(7%) + 执行(5%) + 期权(5%)
```

### 期权交易

期权交易额外计算期权专属评分，并调整权重：

```
综合评分 = 基础评分(95%) + 期权评分(5%)
```

---

## 评分使用建议

1. **筛选高质量交易**: 只执行评分 ≥ 70 的交易机会
2. **复盘低分交易**: 重点分析评分 < 60 的交易，找出问题
3. **追踪改进**: 观察平均评分趋势，持续优化交易系统
4. **关注短板**: 找出评分最低的维度，针对性改进
