# AI洞察维度

Trading Coach 通过10个维度分析交易模式，生成可执行的改进建议。

## 1. 入场分析

分析入场时机和技术指标配合。

### 检测规则

| 模式 | 触发条件 | 类型 |
|------|----------|------|
| 超买追涨 | RSI > 70 时做多 | ⚠️ 警告 |
| 超卖追空 | RSI < 30 时做空 | ⚠️ 警告 |
| 低评分入场 | 入场评分 < 50 | ⚠️ 警告 |
| 优秀入场 | 入场评分 ≥ 80 | ✅ 正面 |

### 典型建议

- 等待更明确的技术信号再入场
- 避免在 RSI > 70 时追涨
- 关注支撑位附近的买入机会

---

## 2. 出场分析

评估止盈止损执行。

### 检测规则

| 模式 | 触发条件 | 类型 |
|------|----------|------|
| 大额亏损 | 单笔亏损 > 10% | ❌ 负面 |
| 止损失效 | 亏损超过预设止损位 | ❌ 负面 |
| 过早止盈 | 盈利 < 2% 就平仓 | ⚠️ 警告 |
| 及时止损 | 亏损控制在 2% 以内 | ✅ 正面 |

### 典型建议

- 设置止损位并严格执行
- 单笔亏损控制在 2-5% 以内
- 考虑使用移动止损锁定利润

---

## 3. 风险管理

分析整体风险控制。

### 检测规则

| 模式 | 触发条件 | 类型 |
|------|----------|------|
| 费用过高 | 费用占盈亏 > 20% | ⚠️ 警告 |
| 仓位过重 | 单笔交易占比 > 10% | ⚠️ 警告 |
| R:R不佳 | 风险回报比 < 1 | ❌ 负面 |
| 良好控制 | 最大回撤 < 10% | ✅ 正面 |

### 典型建议

- 优化交易频率降低费用
- 控制单笔仓位不超过总资金 5%
- 确保 R:R 至少 1.5:1

---

## 4. 持仓时间

分析持仓周期合理性。

### 检测规则

| 模式 | 触发条件 | 类型 |
|------|----------|------|
| 过短持仓 | 持仓 < 1 小时 | ⚠️ 警告 |
| 频繁交易 | 短线交易占比 > 20% | ⚠️ 警告 |
| 过长持仓 | 持仓 > 30 天 | ℹ️ 提示 |

### 典型建议

- 延长持仓时间，给交易空间发展
- 区分日内和波段交易策略
- 设置时间止损避免资金占用

---

## 5. 费用分析

分析交易成本影响。

### 检测规则

| 模式 | 触发条件 | 类型 |
|------|----------|------|
| 费用侵蚀 | 总费用占总盈利 > 20% | ❌ 负面 |
| 小额高频 | 单笔金额小但频繁 | ⚠️ 警告 |
| 费用控制良好 | 费用占比 < 5% | ✅ 正面 |

### 典型建议

- 减少交易频率
- 增加单笔交易规模
- 选择费用更低的券商

---

## 6. 历史对比

与类似持仓对比表现。

### 分析内容

- 同标的历史交易对比
- 同类型（做多/做空）对比
- 同持仓周期对比

### 典型输出

```
AAPL 历史交易:
- 本次: -$150 (亏损)
- 历史平均: +$200
- 历史胜率: 65%
差异原因: 本次入场RSI偏高
```

---

## 7. 模式识别

识别重复出现的交易模式。

### 检测模式

| 模式 | 说明 |
|------|------|
| 某标的持续亏损 | 某股票连续亏损3次以上 |
| 时段表现差异 | 开盘/收盘/盘中表现不同 |
| 周期性亏损 | 月初/月末/周五表现差 |
| 连续盈利 | 某策略连续盈利 |

### 典型建议

- 暂停交易持续亏损的标的
- 避开表现差的时间段
- 复制成功的交易模式

---

## 8. 根因分析

亏损/盈利归因分析。

### 归因维度

| 根因 | 说明 | 示例 |
|------|------|------|
| timing | 时机问题 | 入场过早/过晚 |
| direction | 方向错误 | 逆势交易 |
| position_size | 仓位问题 | 仓位过重/过轻 |
| external_event | 外部事件 | 财报/政策影响 |
| execution | 执行问题 | 滑点/未按计划 |

### 输出格式

```json
{
  "position_id": 123,
  "pnl": -500,
  "root_cause": "timing",
  "analysis": "入场RSI=75，处于超买区域",
  "suggestion": "等待RSI回落至50以下再入场"
}
```

---

## 9. 事件关联

关联财报、异动等事件。

### 检测事件

- 财报日期前后交易
- 价格异动（单日 > 5%）
- 成交量异动（> 2倍均量）
- 重大新闻发布

### 典型输出

```
⚠️ 财报前持仓风险
NVDA 持仓期间包含财报日 (2024-02-21)
财报后波动: +15%
建议: 财报前减仓或平仓以降低风险
```

---

## 10. 改进建议

汇总可操作的具体改进措施。

### 建议分类

| 类别 | 优先级 | 示例 |
|------|--------|------|
| 风险控制 | 高 | 设置止损位 |
| 入场优化 | 高 | 等待信号确认 |
| 出场优化 | 中 | 使用移动止损 |
| 成本控制 | 中 | 减少交易频率 |
| 心理管理 | 低 | 避免情绪交易 |

### 建议格式

每条建议包含：
- **标题**: 简明扼要
- **问题描述**: 发现了什么问题
- **证据**: 支撑数据
- **具体建议**: 如何改进
- **相关案例**: 典型交易示例

---

## 洞察优先级

洞察按优先级排序输出：

| 优先级 | 范围 | 类型 |
|--------|------|------|
| 90-100 | 紧急 | 重大亏损、风险失控 |
| 70-89 | 高 | 频繁错误、模式问题 |
| 50-69 | 中 | 可优化项 |
| 30-49 | 低 | 建议关注 |
| 0-29 | 信息 | 正面反馈 |

---

## 使用建议

1. **优先处理高优先级**: 先解决评分 70+ 的问题
2. **建立检查清单**: 根据洞察建立交易前检查清单
3. **定期复盘**: 每周/每月查看洞察变化趋势
4. **追踪改进**: 记录采纳建议后的效果变化
5. **分享讨论**: 与交易伙伴讨论洞察内容
