---
name: Trader
description: Analyze markets, manage risk, and execute trades with disciplined strategies and emotional control.
metadata: {"clawdbot":{"emoji":"📊","os":["linux","darwin","win32"]}}
---

# Trading Assistance Rules

## Important Boundaries
- This is educational information, not financial advice — recommend licensed advisors for personal decisions
- Past performance doesn't guarantee future results
- Markets can remain irrational longer than you can remain solvent
- Never trade money you can't afford to lose

## Risk Management
- Position sizing determines survival — no single trade should risk more than 1-2% of capital
- Stop losses before entry, not after — know your exit before you enter
- Risk/reward ratio minimum 1:2 — risk $1 to make $2 or don't take the trade
- Correlation kills diversification — assets that move together aren't diversified
- Leverage amplifies losses as much as gains

## Technical Analysis
- Price action tells you what is happening, not why
- Support and resistance are zones, not exact lines
- Volume confirms moves — price without volume is suspect
- Trend following works until it doesn't — mean reversion also works until it doesn't
- Multiple timeframes reveal different stories — zoom out before zooming in

## Fundamental Analysis
- Price already reflects known information — you need an edge on interpretation
- Earnings matter but expectations matter more — beat or miss is relative to consensus
- Macro affects everything — interest rates, inflation, currency
- Quality of earnings: recurring vs one-time, cash vs accrual

## Psychology
- Plan the trade, trade the plan — emotion in the moment is the enemy
- Losses are tuition — analyze what went wrong without self-destruction
- Winning streaks breed overconfidence, losing streaks breed fear — both distort judgment
- Taking a break is a valid strategy — forced trading loses money
- Journal trades to find patterns in your behavior

## Execution
- Slippage and fees erode returns — factor them into strategy
- Limit orders for entries when possible — market orders for emergencies
- Liquidity matters — wide spreads cost money invisibly
- Time of day affects volatility — market open and close behave differently

## Strategy Development
- Backtest before risking capital — but backtest ≠ future results
- Paper trade to learn execution — but paper doesn't feel like real money
- One strategy mastered beats five strategies dabbled
- Edge degrades as more people discover it — adapt constantly
- Simplicity often outperforms complexity

## Market Conditions
- Trending markets reward momentum strategies
- Ranging markets reward mean reversion
- High volatility increases risk and opportunity
- Low liquidity exaggerates moves
- Know which environment you're in before trading

## Common Mistakes
- Averaging down into losing positions — hoping isn't a strategy
- Moving stop losses to avoid small losses — then taking huge losses
- Overtrading — more trades ≠ more profit
- Revenge trading after losses — emotion compounds errors
- Ignoring transaction costs in strategy math
