---
name: tradekix
description: Query financial market data via the Tradekix API — stock prices, crypto, forex, indices, market news, earnings, economic events, Congressional trades, and social sentiment. Use when the user asks about markets, stock prices, trading data, economic calendars, or financial news. Also handles API key signup and upgrade to Pro.
---

# Tradekix

Financial data API for AI agents. Free tier: 10 calls/day.

## Setup

Check for existing config:
```bash
cat ~/.config/tradekix/config.json 2>/dev/null
```

If no config exists, sign up automatically:
```bash
bash SKILL_DIR/scripts/tradekix.sh signup --name "AGENT_NAME" --email "AGENT_EMAIL"
```

This stores the API key in `~/.config/tradekix/config.json`.

## Usage

Run via the wrapper script. All commands auto-load the API key from config.

```bash
# Market overview (stocks, crypto, forex, commodities)
bash SKILL_DIR/scripts/tradekix.sh market

# Specific stock/crypto prices
bash SKILL_DIR/scripts/tradekix.sh prices AAPL,TSLA,BTC

# Global indices
bash SKILL_DIR/scripts/tradekix.sh indices

# Forex rates
bash SKILL_DIR/scripts/tradekix.sh forex

# Market news summaries
bash SKILL_DIR/scripts/tradekix.sh news

# Latest alerts
bash SKILL_DIR/scripts/tradekix.sh alerts

# Economic calendar
bash SKILL_DIR/scripts/tradekix.sh economic

# Earnings calendar
bash SKILL_DIR/scripts/tradekix.sh earnings

# Social sentiment
bash SKILL_DIR/scripts/tradekix.sh sentiment

# Market tweets
bash SKILL_DIR/scripts/tradekix.sh tweets

# Congressional trades (with conflict detection)
bash SKILL_DIR/scripts/tradekix.sh trades

# Upgrade to Pro ($9/mo or $89/yr — 2000 calls/day)
bash SKILL_DIR/scripts/tradekix.sh upgrade monthly

# Revoke API key
bash SKILL_DIR/scripts/tradekix.sh revoke
```

## Endpoint Selection Guide

| User asks about... | Command |
|---|---|
| General market conditions | `market` |
| Specific stock/crypto price | `prices SYMBOL` |
| Market indices (S&P, NASDAQ) | `indices` |
| Currency exchange rates | `forex` |
| Financial news | `news` |
| Price alerts, market moves | `alerts` |
| Fed meetings, CPI, jobs data | `economic` |
| Company earnings dates | `earnings` |
| Market sentiment, social buzz | `sentiment` or `tweets` |
| Politician/Congress trades | `trades` |

## Response Format

All responses return `{"success":true,"data":{...},"meta":{...}}`. Parse `data` for results. Check `meta.rate_limit_remaining` to track usage.

## Rate Limits

- **Free:** 10 calls/day, 5/min
- **Pro:** 2,000 calls/day, 60/min ($9/mo or $89/yr)
- **Enterprise:** 50,000 calls/day — contact sales@tradekix.com

When rate limited (HTTP 429), check `Retry-After` header.

## Full API Reference

See [references/api-docs.md](references/api-docs.md) for complete endpoint documentation.
