# Scoring Rubric — Full 1–10 Scale per Dimension

## 1. Information Edge (18%)
| Score | Description |
|-------|-------------|
| 1 | We know nothing the market doesn't. Pure coin flip. |
| 2 | Vague hunch, no supporting data. |
| 3 | One weak signal (rumor, single tweet, gut feeling). |
| 4 | One credible data point that the market may not have priced in. |
| 5 | Two data points suggesting market mispricing. |
| 6 | Clear data from reliable source showing market is wrong by 10%+. |
| 7 | Multiple strong signals; thesis the market hasn't caught up to. |
| 8 | Insider-level domain knowledge (public but niche) giving clear edge. |
| 9 | Near-certain information gap — market is clearly stale or wrong. |
| 10 | Definitive, verified information the market hasn't priced. Rare. |

## 2. Source Quality (12%)
| Score | Description |
|-------|-------------|
| 1 | Anonymous social media, no verification possible. |
| 2 | Single unverified blog or opinion piece. |
| 3 | Mainstream media with known bias, no primary source. |
| 4 | Reputable outlet, but reporting secondhand. |
| 5 | Official press release or government source, but ambiguous. |
| 6 | Multiple reputable outlets reporting independently. |
| 7 | Primary source documents (filings, records, official data). |
| 8 | Expert analysis from domain specialists with track record. |
| 9 | Multiple primary sources + expert consensus. |
| 10 | Direct official source with zero ambiguity. |

## 3. Market Efficiency (10%)
| Score | Description |
|-------|-------------|
| 1 | Highly liquid, heavily traded. Price is probably right. |
| 2 | Well-known market, efficient pricing. |
| 3 | Popular but some lag in price updates. |
| 4 | Moderate volume; possible small mispricings. |
| 5 | Niche with moderate attention; 5-10% mispricing possible. |
| 6 | Low-attention; prices may lag news by hours. |
| 7 | Thin market, few participants with deep domain knowledge. |
| 8 | Very thin liquidity + domain-specific question. |
| 9 | Micro market <$10K volume; handful of traders. |
| 10 | Brand new, almost no volume, massive potential mispricing. |

## 4. Time Horizon (8%)
| Score | Description |
|-------|-------------|
| 1 | 6+ months. Capital locked forever. |
| 2 | 3-6 months. |
| 3 | 2-3 months. |
| 4 | 1-2 months. |
| 5 | 2-4 weeks. |
| 6 | 1-2 weeks. |
| 7 | 3-7 days. |
| 8 | 1-3 days. |
| 9 | Within 24 hours. |
| 10 | Within hours. Maximum capital velocity. |

## 5. Downside Protection (15%)
| Score | Description |
|-------|-------------|
| 1 | Total loss likely. Binary bet with bad odds. |
| 2 | 80%+ chance of losing entire stake. |
| 3 | High risk of total loss, no hedge. |
| 4 | Significant downside but capped at stake. |
| 5 | 50/50 risk/reward. |
| 6 | Favorable — potential loss < potential gain. |
| 7 | Limited downside (buying YES at 80¢ on near-certain). |
| 8 | Very limited downside, multiple exit paths. |
| 9 | Near-zero downside. |
| 10 | Effectively risk-free (arbitrage). |

## 6. Cross-Validation (12%)
| Score | Description |
|-------|-------------|
| 1 | Single source, no corroboration. |
| 2 | One source + one weak signal. |
| 3 | Two sources from same ecosystem. |
| 4 | Two independent sources, partial agreement. |
| 5 | Three sources, mostly aligned. |
| 6 | Three independent across different mediums. |
| 7 | 4+ sources across different domains. |
| 8 | Strong consensus: data, expert, official. |
| 9 | Near-unanimous from 5+ independent sources. |
| 10 | Every source agrees; counter-evidence nonexistent. |

## 7. Historical Accuracy (5%)
| Score | Description |
|-------|-------------|
| 1 | No precedent. Novel situation. |
| 2 | Similar bets wrong more often than right. |
| 3 | Mixed record. |
| 4 | Slightly positive (55-60%). |
| 5 | Moderate (60-65%). |
| 6 | Good (65-70%). |
| 7 | Strong (70-80%). |
| 8 | Very strong (80-85%). |
| 9 | Excellent (85-95%). |
| 10 | Essentially deterministic (95%+). |

## 8. Liquidity/Execution Risk (7%)
| Score | Description |
|-------|-------------|
| 1 | No liquidity. Can't enter. |
| 2 | Extreme slippage >10%. |
| 3 | Significant slippage 5-10%. |
| 4 | Moderate slippage 3-5%. |
| 5 | Acceptable <3%. |
| 6 | Good. <2% on our sizes. |
| 7 | Strong order book. <1%. |
| 8 | Deep liquidity. Negligible slippage. |
| 9 | Very deep. Instant at fair price. |
| 10 | Massive pool. Zero execution risk. |

## 9. Consensus Divergence (8%)
| Score | Description |
|-------|-------------|
| 1 | Our view matches market exactly. Zero edge. |
| 2 | 1-5% divergence. |
| 3 | 5-10%. Small edge if right. |
| 4 | 10-15%. Starting to be interesting. |
| 5 | 15-20%. Clear contrarian position. |
| 6 | 20-30%. Significant potential. |
| 7 | 30-40%. Strong contrarian bet. |
| 8 | 40-50%. Market is missing something. |
| 9 | 50-70%. Extreme contrarian. |
| 10 | 70%+. Market is fundamentally wrong. Rare. |

## 10. Event Catalyst (5%)
| Score | Description |
|-------|-------------|
| 1 | No known resolution event. |
| 2 | Vague future event. |
| 3 | General timeframe, no date. |
| 4 | Approximate date (within a month). |
| 5 | Specific month. |
| 6 | Specific week. |
| 7 | Exact date, clear-cut resolution. |
| 8 | Scheduled event, unambiguous criteria. |
| 9 | Imminent (<48h), clear resolution. |
| 10 | Happening NOW. Binary, unambiguous. |
