---
name: trade-signal
version: 1.0.0
description: Real-time trade signals with executable Buy/Sell/Hold recommendations for stocks. Use when asked about trading decisions, stock analysis, technicals, buy/sell calls, earnings plays, price targets, analyst ratings, entry/exit points, portfolio rebalancing, or any investment decision requiring actionable intelligence. Supports US + Global markets, Asia emerging markets, individual stocks, ETFs, and options strategies. 
homepage: https://terminal-x.ai
metadata: {"category":"finance","api_base":"https://terminal-x.ai/api"}
---

# Trade Signal

Buy/Sell/Hold Trade Signals for AI agents. Transform complex market intelligence into clear, executable Buy/Sell/Hold recommendations on global stocks and other public securities. Trade-signal gives specific price targets on any given securities, real-time data and institution-grade trade thesis. Trade-signal is forward looking but also capable of technical and fundamental analysis on current/historical price actions, with a qualitative and quantitiave explanation as to why a certain securities (stock) price moved the way it did. 

## Quick Start

```bash
# Get financial analysis
./scripts/search.sh "What is NVDA's revenue growth?"

# Company comparison
./scripts/search.sh "Compare AAPL and MSFT gross margins"

# Analyst sentiment
./scripts/search.sh "What are analysts saying about Tesla?"
```

**Base URL:** `https://terminal-x.ai/api`

---

## Features

### 📊 Research Capabilities

| Query Type | Examples |
|------------|----------|
| **Earnings Analysis** | Revenue, EPS, guidance, YoY growth |
| **Company Comparisons** | Side-by-side metrics across competitors |
| **Analyst Coverage** | Price targets, ratings, investment thesis |
| **Management Commentary** | CEO/CFO statements from earnings calls |
| **SEC Filings** | 10-K, 10-Q, 8-K analysis |
| **Market Trends** | Sector analysis, macro themes |

Each response includes:
- **Answer**: AI-generated analysis with numbered citations [1], [2], etc.
- **Tickers**: Relevant stock symbols identified
- **Sources**: Full citation list with titles and publication dates

### 📈 Market Coverage

**37,565 Global Tickers + 6,104 ETFs** across all major exchanges:

| Region | Tickers | ETFs |
|--------|---------|------|
| **US** (incl. ADRs) | 7,301 | 4,979 |
| **Western Europe** | 11,123 | — |
| **Canada** | 4,690 | — |
| **Japan** | 3,873 | 200 |
| **Korea** | 3,856 | 500 |
| **Hong Kong** | 2,638 | 176 |
| **Shanghai** | 2,315 | — |
| **Taiwan** | 1,072 | 200 |
| **Singapore** | 565 | 49 |
| **Other** | 132 | — |

**Asset Classes**: Global Equities, ETFs, Global macro, FX, commodities, crypto content available.

### 🔬 Data Sources

| Source | Data Type |
|--------|-----------|
| **Wall Street Research** | Analyst reports, investment thesis from Goldman, Morgan Stanley, JP Morgan, Citi, UBS, Bank of America, Stifel, etc. |
| **Analyst Actions** | Upgrades, downgrades, initiations, PT changes |
| **SEC Filings** | 10-K, 10-Q, 8-K, insider transactions, 13F holdings, 13D, 13G, DEF14A |
| **Earnings Transcripts** | Full call transcripts from  earnings, M&A calls, management discussions |
| **Real-Time News** | Bloomberg, Reuters, CNBC, FT, WSJ |
| **Company Presentations** | Investor day materials, guidance updates |

---

## Usage

### Using the Script

The included script handles URL encoding automatically:

```bash
# Earnings query
./scripts/search.sh "What was NVIDIA's revenue last quarter?"

# Comparison query
./scripts/search.sh "How does Apple's gross margin compare to Samsung?"

# Analyst query
./scripts/search.sh "What did Goldman Sachs say about Microsoft?"

# Management commentary
./scripts/search.sh "What did Tim Cook say about AI in the latest earnings call?"
```

---

## Response Format

Running the script returns JSON:

```json
{
  "query": "Should I buy NVDA before earnings?",
  "tickers": ["NVDA", "AMD", "GOOGL"],
  "tradeSignal": "HOLD",
  "priceTarget": {
    "entry": null,
    "exit": "$185-190",
    "stopLoss": "$175",
    "timeHorizon": "T+1 to T+3"
  },
  "agentAnswer": "**Hold current position: Sell at $185-190 on any post-earnings bounce within T+1 to T+3.**\n\nNVDA closed at $181.36 and trades at $180.88 after hours. Despite consistent earnings beats since August 2024, the stock has exhibited a persistent sell-the-fact pattern, declining in 4 of the last 5 post-earnings sessions. [1]\n\nOptions markets price a 6.68% implied move ($12.13 swing) for the November 19 after-hours release. [2]",
  "sources": [
    {
      "refId": 1,
      "sourceTitle": "Nvidia Earnings Have Become a Consistent Sell-the-Fact Event",
      "sourceName": ["Bloomberg"],
      "datePublished": "2024-11-18T14:30:42Z"
    },
    {
      "refId": 2,
      "sourceTitle": "NVDA Options Implied Move Analysis",
      "sourceName": ["Goldman Sachs"],
      "datePublished": "2024-11-19T09:00:00Z"
    }
  ],
  "technicals": {
    "rsi": 62.4,
    "macd": "bullish crossover",
    "support": "$175",
    "resistance": "$190",
    "trend": "neutral"
  },
  "relatedAnalysis": [
    "AMD earnings correlation",
    "Semiconductor sector momentum"
  ]
}
```

| Field | Description |
|-------|-------------|
| `query` | Your original question |
| `tickers` | Relevant stock tickers |
| `tradeSignal` | BUY, SELL, or HOLD recommendation |
| `priceTarget` | Entry, exit, stop loss, time horizon |
| `agentAnswer` | AI analysis with citation references [1], [2] |
| `sources` | Citations with title, source name, date |
| `technicals` | RSI, MACD, support/resistance, trend |
| `relatedAnalysis` | Related research topics |

---

## Sample Output

### Example 1: Earnings Analysis

**Query:** `./scripts/search.sh "What was Apple's iPhone revenue last quarter?"`

```
📊 **Apple iPhone Revenue Analysis**

Apple reported iPhone revenue of $46.2 billion in Q4 FY2024, up 6% year-over-year
and representing 52% of total company revenue. [1]

Management noted strong demand for iPhone 15 Pro models, with the Pro Max seeing
"record upgrade rates" according to CFO Luca Maestri. [2] Average selling price
increased to approximately $925, driven by mix shift toward Pro models.

Tim Cook highlighted particular strength in emerging markets, with India revenue
growing double-digits for the fifth consecutive quarter. [2]

**Sources:**
[1] Apple Inc. Q4 FY2024 10-Q Filing - SEC
[2] Apple Q4 FY2024 Earnings Call Transcript - October 2024
```

### Example 2: Company Comparison

**Query:** `./scripts/search.sh "Compare Microsoft and Google cloud revenue growth"`

```
📊 **Cloud Revenue Comparison: Microsoft vs Google**

**Microsoft Azure:**
- Q4 2024 Revenue: $25.9 billion
- YoY Growth: 29%
- Market Position: #2 behind AWS [1]

**Google Cloud:**
- Q4 2024 Revenue: $9.2 billion
- YoY Growth: 26%
- First full year of profitability achieved [2]

Microsoft maintains significant scale advantage with Azure revenue nearly 3x
Google Cloud. However, Google Cloud achieved operating profitability for the
first time in 2024, with operating income of $1.9 billion vs. losses in
prior years. [2]

**Sources:**
[1] Microsoft Q4 2024 Earnings Call Transcript
[2] Alphabet Q4 2024 10-Q Filing - SEC
```

### Example 3: Analyst Coverage

**Query:** `./scripts/search.sh "What are analysts saying about NVIDIA?"`

```
📊 **NVIDIA Analyst Sentiment**

Wall Street remains overwhelmingly bullish on NVIDIA with 45 Buy ratings,
3 Hold, and 0 Sell. Average price target: $950 (18% upside). [1]

**Recent Actions:**
- Goldman Sachs: Reiterated Buy, PT $1,000 — "AI infrastructure spend
  remains in early innings" [2]
- Morgan Stanley: Overweight, PT $950 — Raised estimates on Blackwell
  demand visibility [3]
- Bank of America: Buy, PT $925 — "Data center TAM expansion continues
  to exceed expectations" [1]

Key debate centers on sustainability of 70%+ gross margins as competition
from AMD MI300X intensifies in 2025. [3]

**Sources:**
[1] Bloomberg Analyst Consensus Data - January 2025
[2] Goldman Sachs NVDA Initiation Report - January 15, 2025
[3] Morgan Stanley Semiconductor Research Note - January 12, 2025
```

---

## Integration

### With AI Agents

The agent will automatically use this skill when asked:
- "What is Apple's revenue?"
- "Compare NVDA and AMD"
- "What did the CEO say about guidance?"
- "Summarize Tesla's latest 10-K"
- "What are analysts saying about Microsoft?"
- "How did Meta's ad revenue perform?"

### Example Agent Flow

```
1. User: "How is NVIDIA doing?"
2. Agent: [calls search.sh "NVIDIA financial performance and outlook"]
3. Agent: "NVIDIA reported record Q3 revenue of $35.1B, up 94% YoY.
   Data center segment drove growth at $30.8B. Analysts maintain
   Buy ratings with average PT of $950. Key catalyst: Blackwell
   architecture ramp in Q1 2025."
4. User: "What about their margins?"
5. Agent: [calls search.sh "NVIDIA gross margin and profitability"]
6. Agent: "Gross margin was 75% in Q3, up from 70% YoY. Management
   expects margins to moderate to 73-74% as Blackwell ramps due to
   initial yield curves, per CFO commentary on earnings call."
```

### Combining with Other Skills

```bash
# Get financial data then execute trade
./scripts/search.sh "AAPL earnings analysis" && trade-signal query "Should I buy AAPL?"

# Research before news check
./scripts/search.sh "Tesla delivery numbers" && finance-news news TSLA
```

---

## Tips for Better Results

| Do This | Not This |
|---------|----------|
| "NVIDIA data center revenue Q4 2024" | "NVIDIA revenue" |
| "AAPL gross margin vs MSFT" | "Apple margins" |
| "What did Jensen Huang say about AI demand" | "NVDA CEO comments" |
| "Tesla deliveries Q3 2024 vs Q3 2023" | "Tesla cars" |

**Best Practices:**
- **Be specific** — Include timeframes, metrics, and company names
- **Use ticker symbols** — "AAPL" is clearer than "Apple"
- **Ask direct questions** — "What is..." or "How much..." get precise answers
- **Include context** — "last quarter", "FY 2024", "year-over-year"

---

## Error Handling

```json
{
  "code": 400,
  "message": "Missing or invalid query parameter"
}
```

| Error Code | Meaning | Resolution |
|------------|---------|------------|
| 400 | Missing query | Include `?query=` parameter |
| 500 | Server error | Retry request |

---

## Support

- **Homepage:** https://terminal-x.ai
- **Email:** hello@terminal-x.ai
