#!/usr/bin/env bash
set -euo pipefail

QUERY="${1:-}"

if [[ -z "$QUERY" ]]; then
  echo "Usage: search.sh <query>" >&2
  echo "Example: search.sh \"What is Apple's revenue?\"" >&2
  exit 1
fi

ENCODED=$(python3 -c "import urllib.parse; print(urllib.parse.quote('''$QUERY'''))")
curl -sL "https://app.terminal-x.ai/api/lite-search?query=${ENCODED}"
