---
name: trace-to-svg
description: Trace bitmap images (PNG/JPG/WebP) into clean SVG paths using potrace/mkbitmap. Use to convert logos/silhouettes into vectors for downstream CAD workflows (e.g., create-dxf etch_svg_path) and for turning reference images into manufacturable outlines.
metadata:
  openclaw:
    requires:
      bins: ["potrace", "mkbitmap"]
    install:
      - id: apt
        kind: apt
        package: potrace
        bins: ["potrace", "mkbitmap"]
        label: Install potrace + mkbitmap (apt)
      - id: brew
        kind: brew
        formula: potrace
        bins: ["potrace", "mkbitmap"]
        label: Install potrace + mkbitmap (brew)
---

# trace-to-svg

Convert a bitmap into a vector SVG using `mkbitmap` + `potrace`.

## Quick start

```bash
# 1) Produce a silhouette-friendly SVG
bash scripts/trace_to_svg.sh input.png --out out.svg

# 2) Higher contrast + less noise
bash scripts/trace_to_svg.sh input.png --out out.svg --threshold 0.6 --turdsize 20

# 3) Feed into create-dxf (example)
# - set create-dxf drawing.etch_svg_paths[].d to the SVG path `d` you want, or
# - store the traced SVG and reference it in your pipeline.
```

## Notes

- This is best for **logos, silhouettes, high-contrast shapes**.
- For photos or complex shading, results depend heavily on thresholding.
- Output is usually one or more `<path>` elements.
