# Toronto Visitor Tips

## Essential First-Day Actions

1. **Get a Presto card**
   - Buy at Union Station, subway stations, or Shoppers Drug Mart
   - Load CAD 20-50 depending on length of stay
   - Tap for TTC, GO Transit, UP Express

2. **Download apps**
   - TTC/Transit App (real-time arrivals)
   - Google Maps (transit directions excellent)
   - Uber/Lyft (backup for late nights)
   - OpenTable/Resy (reservations)

3. **Understand sales tax**
   - 13% HST added at checkout (not in displayed prices)
   - Budget accordingly

4. **Tipping expectations**
   - Restaurants: 15-20%
   - Bars: CAD 1-2/drink or 15%
   - Taxis/Uber: 15%
   - Hotels: CAD 2-5/bag, CAD 5/night housekeeping

## Money & Payments

### Cards vs Cash
- Cards accepted almost everywhere (Visa/MC universal)
- Tap-to-pay extremely common
- Some small vendors cash-only (Kensington, Chinatown markets)
- ATMs: use bank ATMs to avoid fees

### Currency
- Canadian dollar (CAD)
- Coins: penny eliminated, cash rounds to nearest 5 cents
- Loonie (CAD 1) and Toonie (CAD 2) are coins

### Budgeting
| Item | Budget | Mid-Range | Splurge |
|------|--------|-----------|---------|
| Meal | CAD 15-20 | CAD 30-50 | CAD 80+ |
| Coffee | CAD 3-4 | CAD 5-7 | CAD 8+ |
| Beer | CAD 7-9 | CAD 10-12 | CAD 14+ |
| Attraction | CAD 20-30 | CAD 40-50 | CAD 60+ |

## Getting Around

### TTC (Subway/Bus/Streetcar)
- Flat fare: CAD 3.35 (Presto), valid 2 hours
- Subway: 4 lines, runs 6am-1:30am (2am Sat)
- Streetcars: Iconic, slow but scenic on King/Queen
- Buses: Cover areas subway doesn't

### Uber/Lyft
- Widely available, competitive pricing
- Essential for late nights when TTC closed
- Airport to downtown: CAD 35-50

### Walking
- Downtown very walkable
- PATH underground for winter (30+ km)
- Waterfront trail for scenic walks

### Biking
- Bike Share Toronto (CAD 7/day)
- Bike lanes expanding but traffic still intimidating
- Best on waterfront and dedicated trails

### Driving
- **Avoid** downtown driving
- Parking expensive (CAD 5-8/hour, CAD 30-50/day)
- Traffic congestion severe rush hours
- Only rent car for day trips (Niagara, cottage country)

## Weather Preparedness

### Winter (Dec-Mar)
- **Essentials**: Insulated waterproof boots, heavy coat, layers
- **Tip**: PATH underground connects major downtown spots
- **Reality check**: -20C windchill is brutal, limit outdoor time

### Spring (Apr-May)
- **Essentials**: Rain jacket, layers, umbrella
- **Tip**: Weather changes rapidly, carry layers
- **Reality check**: Snow possible until mid-April

### Summer (Jun-Aug)
- **Essentials**: Sunscreen, sunglasses, light clothes
- **Tip**: AC is everywhere, carry light layer for indoors
- **Reality check**: Humidity can be oppressive (humidex 35C+)

### Fall (Sep-Nov)
- **Essentials**: Layers, light jacket, comfortable walking shoes
- **Tip**: Best weather for exploring
- **Reality check**: Can be rainy, nights get cold by November

## Day Trips from Toronto

### Niagara Falls (1.5 hours)
- **How**: Rent car, bus tour, or GO Train + bus
- **Tips**: Canadian side better, Niagara-on-the-Lake for wine
- **Best season**: Summer for mist, winter for frozen views

### Muskoka/Cottage Country (2-3 hours)
- **How**: Rent car required
- **Tips**: Summer for lakes, fall for colors
- **Best for**: Nature, swimming, kayaking

### Stratford (1.5 hours)
- **How**: VIA Rail or car
- **Tips**: Shakespeare festival (Apr-Oct), charming town
- **Best for**: Theatre lovers, foodies

### Prince Edward County (2.5 hours)
- **How**: Car required
- **Tips**: Wine country, beaches, artisan food
- **Best for**: Wine lovers, weekend escape

### Hamilton/Burlington (1 hour)
- **How**: GO Train
- **Tips**: Waterfalls (100+ in area), art galleries
- **Best for**: Nature, waterfalls, budget-friendly

### Blue Mountain (2 hours)
- **How**: Rent car
- **Tips**: Skiing winter, hiking/biking summer
- **Best for**: Outdoor activities year-round

## Local Etiquette

### Social Norms
- Canadians apologize constantly (it's real)
- Line up orderly for everything
- Say "please" and "thank you" always
- Hold doors for people behind you

### Transit Etiquette
- Stand right, walk left on escalators
- Let people exit before boarding
- Give up priority seats
- Keep backpacks low or remove

### Restaurant Etiquette
- Reservations expected at popular spots
- Tipping not optional (15-20%)
- Splitting bills common and accepted
- "Last call" at 2am, bars close shortly after

### General
- Don't compare everything to the US (sensitive topic)
- Hockey is religion (learn basics)
- Remove shoes when entering homes
- Apologize if someone bumps into YOU (yes, really)

## Safety Notes

### Generally Safe Areas
- Downtown core, tourist areas
- Most residential neighborhoods
- PATH system

### Exercise Caution
- Late night on Yonge Street (north of Dundas)
- Some parts of Moss Park, Regent Park after dark
- TTC late night (rare but occasional incidents)

### Common Scams
- Fake monks asking for donations
- "Need bus fare" requests
- Overpriced tours at tourist spots

### Emergency
- 911 for emergencies
- Non-emergency police: 416-808-2222
- Telehealth Ontario: 1-866-797-0000 (free medical advice)
