# Toronto Transportation Guide

## TTC (Toronto Transit Commission)

### Overview
- Subway, buses, streetcars
- Flat fare, 2-hour transfer
- Covers most of the city

### Fares (2026)
| Type | Price |
|------|-------|
| Single ride (Presto) | CAD 3.35 |
| Single ride (cash) | CAD 3.35 |
| Monthly pass (Adult) | CAD 156 |
| Weekly pass | Not available |
| Day pass | CAD 13.50 |

### Presto Card
**Essential** — contactless payment for all GTA transit.

**Get One**:
- Subway stations (vending machines)
- Shoppers Drug Mart
- Online (mailed)

**How It Works**:
- Load money, tap to ride
- 2-hour transfer included
- Works on TTC, GO, UP Express, MiWay, etc.

**Autoload**: Set up automatic reloading online.

### Subway

**Lines**:
1. **Line 1 (Yellow)** — Yonge-University, main north-south
2. **Line 2 (Green)** — Bloor-Danforth, east-west
3. **Line 3 (Blue)** — Scarborough RT (being replaced)
4. **Line 4 (Purple)** — Sheppard, short northeast line

**Hours**: 
- Sunday-Saturday: ~6am to 1:30am
- Friday-Saturday: until ~2am

**Tips**:
- Yonge-Bloor is main interchange (crowded)
- Union Station for GO, VIA, PATH
- Download Rocket Man app for times

### Streetcars

**Iconic but slow** — part of Toronto character.

**Key Lines**:
- 501 Queen — longest route
- 504 King — through downtown core
- 510 Spadina — to Chinatown, Harbourfront

**Tips**:
- Board at front, exit any door
- Tap Presto at door
- Can be very slow in traffic
- Scenic, good for tourists

### Buses

**Coverage** — fills gaps where subway doesn't go.

**Night Buses** — "Blue Night Network" runs 1am-6am on major routes.

**Tips**:
- Presto tap at entrance
- Request stop with yellow strip
- Real-time tracking via apps

### Apps
- **Rocket Man** — TTC times, alerts
- **Transit App** — Multi-transit, real-time
- **Google Maps** — Transit directions (excellent)

---

## GO Transit

### Overview
Regional transit connecting Toronto to GTA and beyond.

### Coverage
- Trains: Union Station hub, lines to Barrie, Milton, Kitchener, Hamilton, etc.
- Buses: Where trains don't go

### Fares
Distance-based, more expensive than TTC.
- Downtown to Mississauga: ~CAD 6-8
- Downtown to Oakville: ~CAD 9-12
- Downtown to Hamilton: ~CAD 14

### Presto
- Same card as TTC
- Tap on and off (distance calculated)
- Discounts for monthly users

### Tips
- Express trains faster (fewer stops)
- Off-peak fares cheaper
- Quiet zones on some trains
- Wi-Fi available

---

## UP Express

### What
Airport train — Union Station to Pearson in 25 minutes.

### Fares
- Adult: CAD 12.35 (Presto)
- Youth (13-19): Free with Presto
- Child: Free

### Frequency
Every 15 minutes.

### Tips
- Check in for flight at Union Station (some airlines)
- Very reliable timing
- Worth it vs taxi in traffic

---

## Taxis & Rideshare

### Uber/Lyft
- Widely available
- Generally reliable
- Expect surge pricing at peak times
- Airport to downtown: CAD 35-50

### Traditional Taxis
- Beck Taxi — largest fleet
- Co-op Cabs
- Crown Taxi

- Metered, can hail on street
- Slightly more expensive than rideshare usually
- Required at airport taxi stands

### Tips
- Always have app as backup
- Late night: rideshare more reliable than TTC
- Airport: designated pickup areas
- Split fares easily with apps

---

## Cycling

### Bike Share Toronto
- CAD 7/day, CAD 115/year
- 30-min rides included
- Stations across downtown
- Electric bikes available (extra fee)

### Cycling Infrastructure
- Growing network of bike lanes
- Some separated, some painted
- Waterfront trail excellent
- Martin Goodman Trail along lake

### Tips
- Helmet not required by law (but smart)
- Lock bike securely (theft common)
- Winter cycling possible but challenging
- Apps: CycleFinder, Google Maps bike directions

---

## Driving

### Do You Need a Car?

**Probably not if:**
- Living downtown
- Working downtown
- Near subway line
- Single or couple

**Helpful if:**
- Living in suburbs
- Have kids
- Work outside transit coverage
- Frequent day trips

### License
- Can use foreign license 60 days
- Then need Ontario license
- Exchange process varies by country
- Some can exchange directly, others test

### Car Insurance
**Very expensive** in Ontario.
- New drivers: CAD 300-500/month
- Experienced drivers: CAD 150-250/month
- Factors: age, driving history, location, vehicle

### Parking
| Type | Cost |
|------|------|
| Street (downtown) | CAD 4-6/hour |
| Green P lots | CAD 2-4/hour |
| Private lots | CAD 5-8/hour, CAD 25-40/day |
| Residential permit | CAD 35-350/year |

### Rush Hour
- Avoid driving 7-9am, 4-7pm
- DVP and Gardiner Expressway = parking lots
- 401 is North America's busiest highway

### Winter Driving
- Snow tires required (Dec 1 - Apr 30)
- Not all-seasons — actual winter tires
- Clear snow off entire car (law)
- Learn winter driving techniques

---

## Getting to the Airport (Pearson)

### Options
| Method | Time | Cost |
|--------|------|------|
| UP Express | 25 min | CAD 12.35 |
| TTC + bus | 60-90 min | CAD 3.35 |
| Taxi | 30-60 min | CAD 50-70 |
| Uber/Lyft | 30-60 min | CAD 35-55 |

### Tips
- UP Express most reliable timing
- Traffic can double taxi/Uber time
- TTC: 192 Airport Rocket from Kipling station

---

## Billy Bishop Airport (Downtown)

### Access
- Free shuttle ferry (90 seconds)
- Pedestrian tunnel
- Very close to downtown

### Transit
- Walk from many downtown locations
- Streetcar to Bathurst and Queens Quay
- Uber/taxi short ride

**Note**: Porter Airlines uses this airport.

---

## Intercity Travel

### VIA Rail
- Train to Montreal (5 hours), Ottawa (4.5 hours), etc.
- Union Station
- Book early for best prices

### Megabus/FlixBus
- Budget bus service
- Toronto to Montreal, Ottawa, NYC
- Downtown terminals

### Driving
- 401 east: Montreal (~5 hours)
- QEW south: Niagara (~1.5 hours)
- 400 north: Cottage country (~2-3 hours)
