# Toronto Startup Ecosystem

## Overview

Toronto is Canada's startup capital and one of North America's fastest-growing tech ecosystems.

### By the Numbers
- 4,000+ startups in GTA
- CAD 10B+ invested annually (Canada)
- 30+ accelerators and incubators
- Major exits: Shopify, Wealthsimple, Ritual, TouchBistro

### Why Toronto for Startups
- **Talent**: Top universities, diverse workforce
- **Immigration**: Easier than US to bring talent
- **Costs**: Lower than SF/NYC
- **Healthcare**: Employees don't worry about insurance
- **US Access**: Same timezone as East Coast, easy travel

## Startup Hubs

### MaRS Discovery District
- 1.5M sq ft innovation hub
- 150+ startups
- Accelerator programs
- Corporate innovation
- Location: College/University

### DMZ (Toronto Metropolitan University)
- Top university incubator globally
- Pre-seed focus
- Student and external founders
- Location: Dundas/Yonge

### Creative Destruction Lab (CDL)
- Deep tech focus
- AI, blockchain, quantum
- Mentor-driven model
- Rotman School connection
- Multiple global locations

### OneEleven
- Scale-up focused
- Post-Series A companies
- Enterprise sales support
- Location: King West

### Techstars Toronto
- Batch-based accelerator
- US network access
- Equity model (6%)
- Annual cohorts

## Funding Landscape

### Stage Overview

| Stage | Amount | Sources |
|-------|--------|---------|
| Pre-seed | CAD 100K-500K | Angels, grants, accelerators |
| Seed | CAD 500K-3M | Angels, seed funds, early VCs |
| Series A | CAD 5M-15M | VCs |
| Series B+ | CAD 15M+ | Growth VCs, US funds |

### Canadian VCs

**Early Stage**
- Garage Capital
- Panache Ventures
- Golden Ventures
- Ripple Ventures
- Graphite Ventures

**Growth Stage**
- Georgian Partners
- Inovia Capital
- OMERS Ventures
- BDC Capital
- Kensington Capital

### US VCs in Toronto
Active US firms:
- Sequoia
- Andreessen Horowitz
- Bessemer
- Accel
- First Round

Many have made Toronto investments, especially post-COVID.

### Angel Investors
- Angel One Investor Network
- York Angel Investors
- National Angel Capital Organization
- Individual angels (many tech exits)

### Government Funding

**SR&ED Tax Credits**
- Up to 35% of R&D expenses
- Refundable for small companies
- Major benefit (CAD 100K+ common)

**IRAP (NRC)**
- Non-repayable contributions
- R&D focused
- Up to CAD 1M+
- Advisory services included

**Futurpreneur**
- Ages 18-39
- Up to CAD 60,000 loan
- Mentorship included

**Ontario Centres of Excellence (OCE)**
- Various programs
- Industry partnerships
- Talent development

## Building Your Team

### Hiring

**Where to Find Talent**
- LinkedIn
- AngelList
- Work in Tech
- University job boards (Waterloo, UofT)
- Tech meetups

**Comp Expectations**
Early-stage startups typically offer:
- Below-market salary (20-30%)
- Equity (0.1%-2% for early employees)
- Growth potential story

**Equity Ranges**
| Role | Range |
|------|-------|
| Founding engineer (#1-5) | 0.5-2% |
| Early engineer (#5-10) | 0.25-0.75% |
| Later engineer | 0.1-0.25% |
| Non-technical early | 0.1-0.5% |

### Co-Founders
Finding co-founders:
- Accelerator programs
- Founder dating events
- University networks
- Previous colleagues

### Advisors
Common in Toronto startup scene:
- 0.25-1% equity typical
- Monthly calls or specific help
- Network for intros
- Industry expertise

## Startup Resources

### Accelerators & Incubators

| Program | Focus | Investment |
|---------|-------|------------|
| DMZ | Early stage | No equity |
| CDL | Deep tech | No equity |
| Techstars | General | CAD 120K for 6% |
| MaRS | Growth | No equity |
| Communitech (KW) | General | Varies |

### Coworking

| Space | Best For | Cost |
|-------|----------|------|
| WeWork | Funded startups | CAD 500+/desk |
| Spaces | Similar to WeWork | CAD 400+/desk |
| Project Spaces | Budget option | CAD 300+/desk |
| MaRS | Accepted companies | Varies |

### Legal
Startup-friendly firms:
- Osler (startup program)
- Blake, Cassels & Graydon
- Dentons
- Goodmans
- Fasken

Many offer deferred billing for early-stage.

### Accounting
Find accountants who know:
- SR&ED claims
- Stock options (Canadian rules)
- US subsidiary setup
- Startup-specific issues

### Banking
- Scotiabank startup program
- RBC innovation banking
- BMO tech banking
- SVB (if US operations)

## Events & Community

### Regular Events
- Tech Toronto (monthly)
- Startup Drinks
- Founders Only dinners
- Industry-specific meetups

### Conferences
- Collision (when in Toronto)
- Elevate Festival
- True North (Waterloo)
- Various industry conferences

### Online Communities
- Tech Toronto Slack
- r/TorontoStartups
- LinkedIn groups
- Twitter tech community

## Common Paths

### Accelerator Path
1. Apply to DMZ, CDL, or Techstars
2. Build MVP during program
3. Demo day connections
4. Raise seed round
5. Graduate and scale

### Bootstrap Path
1. Build product while employed
2. Get paying customers
3. Go full-time when revenue supports
4. Grow organically or raise later

### Corporate Spinout
1. Develop idea inside company
2. Get company blessing (or leave)
3. Raise from angels/VCs
4. Build independently

## Challenges & Realities

### Toronto Challenges
- Talent competition with US companies
- Some VCs conservative
- Smaller ecosystem than SF/NYC
- Brain drain to US

### Advantages Over US
- Easier immigration
- Healthcare not a burden
- Lower burn rate
- Government programs
- Less cutthroat culture

### Realistic Expectations
- Most startups fail (same as everywhere)
- Fundraising takes 3-6 months
- Exits smaller than US (typically)
- Build relationships before asking for money

## Success Stories

### Major Exits
- Shopify (IPO, CAD 100B+ at peak)
- Kik (sold to MediaLab)
- Wattpad (sold to Naver)
- Ritual (private, well-funded)
- TouchBistro (private, major funding)
- Wealthsimple (private, CAD 5B+ valuation)

### What Worked
- Long-term thinking
- US market expansion
- Strong technical teams
- Patient capital
- Immigration advantages for talent
