# Toronto Safety & Laws

## Overall Safety

Toronto is one of the safest major cities in North America. Violent crime is rare, especially in areas visitors frequent.

### Crime Context
- Lower violent crime than most US cities
- Property crime (bike theft, car break-ins) more common
- Most crime concentrated in specific areas
- Tourist areas very safe

## Neighborhood Safety

### Very Safe
- Yorkville
- Rosedale
- Beaches
- Forest Hill
- Most of North York
- Leaside
- Leslieville (main streets)

### Generally Safe (Normal Urban Caution)
- Downtown core
- King West
- Queen West
- Kensington Market
- The Annex
- Distillery District

### Exercise Caution
- Moss Park area (especially at night)
- Parts of Regent Park (improving)
- Jane/Finch (specific blocks)
- Some Parkdale blocks
- Dundas/Jarvis area

### Context
"Exercise caution" means normal urban awareness, not danger. Toronto's rougher areas are safer than equivalent areas in most US cities.

## Laws You Should Know

### Alcohol
- **Legal age**: 19
- **Where to buy**: LCBO, Beer Store, some grocery stores
- **Public drinking**: Illegal (no open containers)
- **Bars close**: 2am (some 3am)
- **DUI**: Serious offense, immediate consequences

### Cannabis
- **Legal age**: 19
- **Where to buy**: Licensed dispensaries (OCS)
- **Public consumption**: Limited — some parks, home, designated areas
- **NOT allowed**: Near schools, in cars, on patios
- **Border**: DO NOT cross border with cannabis (even to US)

### Smoking/Vaping
- **Banned**: Indoor public spaces, patios, near building entrances (9m)
- **Includes**: Cigarettes, vapes, cannabis
- **Parks**: Some restrictions

### Driving Laws
| Offense | Consequence |
|---------|-------------|
| Speeding (50+ over) | Stunt driving, license suspension |
| DUI | Criminal charge, license suspension |
| Phone use | CAD 615+ fine, points |
| School zone speeding | Double fines, photo radar |
| No insurance | CAD 5,000+ fine, vehicle impound |

### Photo Radar
Active in school zones and community safety zones. Tickets mailed to registered owner.

### Winter Driving
- Snow tires required Dec 1 - Apr 30
- Must clear snow from entire vehicle
- Fines for driving with obstructed view

## Tenant Rights

Ontario has strong tenant protections:

### Rent Control
- Annual increase capped (~2.5% in 2024)
- Applies to most buildings built before Nov 2018
- Newer buildings: no cap

### Eviction
- Cannot be evicted without tribunal process
- Valid reasons: non-payment, property damage, personal use
- 60+ days notice required (varies by reason)
- Illegal to evict for having children, getting pet (usually)

### Repairs
- Landlord must maintain habitable condition
- Can file with Landlord Tenant Board if ignored
- Cannot withhold rent (use LTB instead)

### Your Rights
- Privacy (24-hour notice for entry)
- Guests allowed
- Cannot be discriminated against (race, gender, family status, etc.)

## Employment Rights

### Minimum Wage
CAD 16.55/hour (2024, increases annually)

### Overtime
- 1.5x pay after 44 hours/week
- Some exemptions (IT, management)

### Vacation
- Minimum 2 weeks after 1 year
- Increases to 3 weeks after 5 years

### Sick Days
- 3 unpaid job-protected sick days
- Some employers offer paid

### Termination
- Notice or pay in lieu required
- Severance after 5+ years at large employers
- Cannot be fired for protected reasons (pregnancy, disability, etc.)

## Consumer Protection

### Returns
- No automatic return right (unlike EU)
- Store policies vary
- Credit card chargebacks exist

### Price Accuracy
- Scanning Code of Practice: item free if scans wrong (up to CAD 10)
- Voluntary program, most major retailers participate

### Contracts
- Cooling-off periods for door-to-door sales
- Cell phone contracts regulated
- Gym contracts have cancellation rights

## Emergency Services

### Numbers
| Service | Number |
|---------|--------|
| Emergency | 911 |
| Police (non-emergency) | 416-808-2222 |
| Telehealth Ontario | 1-866-797-0000 |
| Poison Control | 1-800-268-9017 |
| Crisis Line | 416-408-4357 |

### Hospitals (Downtown)
- St. Michael's Hospital
- Toronto General Hospital
- Mount Sinai Hospital

### Walk-In Clinics
Available throughout city for non-emergency care.

## Scams to Know

### Common Scams
- **Fake monks**: Request donations, not real monks
- **Need bus fare**: Common panhandling technique
- **CRA phone scam**: Government doesn't call demanding payment
- **Rental scams**: Never pay before viewing
- **Romance scams**: Online dating money requests

### Avoid
- Paying deposits before seeing rentals
- Giving remote access to computer
- Wire transfers to strangers
- Too-good-to-be-true deals

## LGBTQ+ Safety

Toronto is very LGBTQ+ friendly:
- Pride Month is major celebration
- Church-Wellesley Village is gayborhood
- Legal protections strong
- General acceptance high

## Women's Safety

Generally safe, standard urban precautions:
- Well-lit routes at night
- TTC has designated waiting areas
- Uber/Lyft reliable late night
- Cat-calling less common than many cities

## Reporting Issues

### Non-Emergency
- Toronto Police non-emergency: 416-808-2222
- Online reporting for property crimes

### Tenant Issues
- Landlord Tenant Board: tribunalsontario.ca

### Workplace Issues
- Ministry of Labour: ontario.ca/labour

### Consumer Complaints
- Consumer Protection Ontario
