# Moving to Toronto Guide

## Before You Arrive

### Essential Documents
- **Passport** — Valid for duration of stay
- **Visa/Work Permit/Study Permit** — As required
- **Job offer letter** — If employment-based move
- **Proof of funds** — Bank statements
- **Educational credentials** — For professional licensing
- **Vaccination records** — Some jobs require
- **Driver's license** — Can use foreign for 60 days

### Research Ahead
- Neighborhood selection (see neighborhoods guides)
- Rental market (budget + expectations)
- Bank account options
- Phone plan comparisons
- Health insurance gap coverage

## First Week Checklist

### Day 1-2: Essentials
- [ ] Get SIM card (see `local.md`)
- [ ] Open bank account (see `local.md`)
- [ ] Get Presto card (transit)
- [ ] Grocery shop basics

### Day 3-5: Admin
- [ ] Apply for SIN (Social Insurance Number) — URGENT
- [ ] Register for OHIP (health card)
- [ ] Set up mail forwarding if needed
- [ ] Get phone/internet at home

### Week 2+: Settlement
- [ ] Get Ontario Photo ID or driver's license
- [ ] Register with doctor (can take weeks)
- [ ] Set up utilities (if not included)
- [ ] Explore neighborhood

## Social Insurance Number (SIN)

**What**: 9-digit number required for legal work, taxes, benefits.

**Apply**:
- Service Canada office (bring passport, work permit)
- Processing: Same day in person
- Location: Multiple Service Canada offices

**Required For**:
- Employment
- Opening bank accounts (some)
- Tax filing
- Government benefits

## OHIP (Health Insurance)

**What**: Ontario Health Insurance Plan — free healthcare.

**Wait Period**: 3 months from establishing residency.

**Apply**:
- ServiceOntario location
- Bring: ID, proof of residency, immigration documents
- Get temporary confirmation; card mailed later

**Covers**:
- Doctor visits
- Hospital stays
- Most medical procedures
- NOT: dental, vision, prescriptions, physiotherapy

**Gap Coverage**: Get private insurance for 3-month wait (CAD 100-200/month).

## Finding Housing

### Rental Market Reality
- Competitive, especially downtown
- Good units go fast (hours/days)
- Be prepared with documents

### What You Need
1. Photo ID (passport)
2. Employment letter or offer letter
3. Recent pay stubs (if employed)
4. Bank statements (savings proof)
5. References (employer, previous landlord)
6. Credit check authorization

### No Canadian Credit
Common for newcomers. Solutions:
- Offer larger deposit
- Strong employment letter
- Bank statement showing savings
- Co-signer (if you know someone)
- Private landlords (more flexible)

### Costs
| Item | Amount |
|------|--------|
| First month | Due at signing |
| Last month | Due at signing (required by law) |
| Key deposit | Refundable, max = replacement cost |
| Utilities | CAD 50-150/month if not included |
| Tenant insurance | CAD 20-40/month (required) |

### Where to Find Listings
- **Padmapper** — Aggregator
- **Rentals.ca** — Listings
- **Kijiji** — Craigslist equivalent
- **Facebook Marketplace/Groups** — Active
- **Realtor.ca** — Some rentals
- **Walk neighborhoods** — "For Rent" signs

### Red Flags
- Deposit before viewing
- Cash only
- No lease offered
- Pressure to decide immediately
- "Landlord" doesn't know building

### Tenant Rights
Ontario has strong tenant protections:
- Rent increases capped (2.5% in 2024 for most)
- 60-day notice required for rent increase
- Eviction requires tribunal process
- Repairs are landlord responsibility
- Cannot be evicted for having children/pets (generally)

## Setting Up Home

### Utilities

**Electricity (Toronto Hydro)**
- Usually tenant responsibility
- Budget: CAD 50-100/month
- Set up online or phone

**Gas (Enbridge)**
- Heating in many buildings
- Budget: CAD 30-80/month (varies by season)
- Set up online

**Water**
- Usually included in rent
- If not: billed by city

### Internet

| Provider | Speed | Price/Month |
|----------|-------|-------------|
| Bell | Various | CAD 70-120 |
| Rogers | Various | CAD 70-120 |
| Beanfield | Fiber | CAD 50-100 |
| Teksavvy | Various | CAD 50-80 |
| Start.ca | Various | CAD 50-80 |

**Tips**:
- Negotiate — listed prices are starting points
- Smaller providers often better value
- Building may have limited options

### Furnishing

**Budget Options**
- IKEA — Etobicoke and North York
- Structube — Modern, affordable
- Facebook Marketplace — Used
- Kijiji — Used furniture
- Wayfair — Online

**Rent Furniture**
- CORT — Short-term rentals
- Multiple providers

**Mattress**
- Endy, Casper — Online Canadian brands
- IKEA — Budget
- Sleep Country — Retail

## Building Community

### Meeting People
- Meetup.com groups
- Sports leagues (TSSC, JAM)
- Alumni associations
- Religious/cultural communities
- Coworking spaces
- Dog parks (if applicable)

### Expat/Newcomer Resources
- Toronto Public Library (free programs)
- Settlement agencies (free services)
- Cultural associations
- Facebook groups by nationality/interest

### Sports & Activities
- Toronto Sport & Social Club (TSSC)
- Joga soccer leagues
- Running clubs
- Climbing gyms
- Fitness classes

## Weather Adjustment

### Winter Survival
First Toronto winter is hardest. Prepare:

**Clothing**
- Insulated waterproof boots (required)
- Down or synthetic puffer coat
- Layers (thermal base layer)
- Warm hat, gloves, scarf
- Windproof outer layer

**Mindset**
- Indoor activities abound
- PATH underground downtown
- Embrace winter sports (skating, skiing)
- Vitamin D supplements help
- Light therapy lamp if needed

**Home**
- Humidifier (indoor air very dry)
- Draft stoppers for doors
- Warm bedding

### Summer Survival
- AC or fans essential
- Humidity can be oppressive
- Patios, beaches, islands
- Hydration important

## Cultural Adjustment

### Canadian Norms
- Apologizing frequently (even when not at fault)
- Queuing orderly
- Holding doors
- Tipping expected
- Small talk with strangers

### Toronto Specifics
- Fast-paced (for Canada)
- Multicultural — diversity is the norm
- Work-life balance valued
- Winter = indoor socializing
- Summer = outdoor socializing explosion

### Things That Surprise Newcomers
- Tax not included in prices
- Tipping culture intensity
- Winter severity
- Housing costs
- Multiculturalism extent
- Friendliness with boundaries
- Everything closes earlier than expected
