# Suburban Toronto Neighborhoods

## North York

### Overview
Former city, now part of Toronto. Yonge Street corridor, diverse communities, good subway access.

### Stats
- **Rent (1BR)**: CAD 1,700-2,300
- **Vibe**: Suburban-urban, diverse, family
- **Transit**: Yonge subway line, bus network
- **Walk Score**: 60-85 (varies by area)

### Pros
- Subway access (Yonge line)
- More space for money
- Diverse communities
- Good schools
- Mel Lastman Square events

### Cons
- Suburban feel
- Car helpful
- Less character
- Long commute to downtown

### Key Areas
- **Yonge-Sheppard**: Condo towers, subway interchange, walkable
- **North York Centre**: City centre feel, Mel Lastman Square
- **Willowdale**: Korean community, restaurants
- **Bayview Village**: Upscale, mall-centric

### Best For
- Families
- Value seekers with transit needs
- Korean food lovers (Yonge/Finch)
- Those okay with suburban pace

---

## Scarborough

### Overview
Toronto's most diverse area. Asian food paradise, sprawling, affordable, car-centric but improving.

### Stats
- **Rent (1BR)**: CAD 1,400-1,900
- **Vibe**: Diverse, sprawling, family, value
- **Transit**: Scarborough RT (replacing with subway), buses
- **Walk Score**: 40-70 (varies widely)

### Pros
- Most affordable in Toronto
- Incredible Asian food
- Diverse communities
- Space (houses, yards)
- Scarborough Bluffs

### Cons
- Car almost essential
- Long commute downtown
- Transit gaps
- Strip mall aesthetic

### Key Areas
- **Scarborough Town Centre**: Mall hub, transit
- **Agincourt**: Chinese community, food
- **Markham Road**: South Asian corridor
- **Scarborough Bluffs**: Stunning cliffs, beaches

### Best For
- Budget-conscious
- Families needing space
- Asian food obsessives
- Car owners

### Food Highlights
- Chinese (Agincourt, Midland)
- South Asian (Markham Road)
- Caribbean (multiple areas)
- Filipino (multiple areas)

---

## Etobicoke

### Overview
Western suburbs. Mix of lakefront (expensive), central (diverse), north (suburban). More car-centric.

### Stats
- **Rent (1BR)**: CAD 1,600-2,200
- **Vibe**: Suburban, diverse, family, lakefront (south)
- **Transit**: Bloor subway (southern edge), buses
- **Walk Score**: 45-75 (varies)

### Pros
- Lakefront access (south)
- More affordable
- Space
- Less congested than downtown

### Cons
- Car helpful/necessary
- Suburban spread
- Limited nightlife
- Long commute

### Key Areas
- **Mimico**: Lakefront, gentrifying, good value
- **Islington-City Centre West**: Subway, condos
- **Bloor West Village**: Charming main street
- **Long Branch**: Beachfront, quiet
- **Rexdale**: Diverse, very affordable

### Best For
- Families
- Lakefront seekers on budget
- Car owners
- Those working in west GTA

---

## Mimico

### Overview
Lakefront Etobicoke neighborhood, rapidly gentrifying. Good GO access, water views.

### Stats
- **Rent (1BR)**: CAD 1,900-2,400
- **Vibe**: Lakefront, evolving, commuter
- **Transit**: Mimico GO, bus to Islington subway
- **Walk Score**: 70

### Pros
- Lakefront
- GO Transit to Union (quick)
- More affordable waterfront
- Improving restaurants
- Humber Bay Park

### Cons
- Condo development chaos
- Limited subway
- Still developing character

### Best For
- Commuters (GO Train)
- Water lovers on budget
- Those priced out of downtown waterfront

---

## Leaside

### Overview
Affluent family neighborhood. Great schools, quiet streets, community feel. East of midtown.

### Stats
- **Rent (1BR)**: CAD 2,000-2,600 (mostly houses)
- **Vibe**: Family, affluent, quiet, community
- **Transit**: Bayview subway, buses
- **Walk Score**: 75

### Pros
- Excellent schools
- Community feel
- Safe, quiet
- Bayview Avenue shops
- Parks

### Cons
- Limited rentals
- Expensive
- Quiet (no nightlife)
- Older housing stock

### Best For
- Families with children
- Those wanting community
- School-focused parents

---

## High Park Area / Junction Triangle

### Overview
Near High Park, mix of established and emerging. Junction Triangle is rapidly gentrifying.

### Stats
- **Rent (1BR)**: CAD 1,900-2,500
- **Vibe**: Park-adjacent, family, evolving
- **Transit**: High Park, Keele stations, buses
- **Walk Score**: 80

### Pros
- High Park access
- Good transit
- Improving dining
- Family-friendly

### Cons
- Gentrifying (prices rising)
- Construction in parts
- Uneven development

### Best For
- Park lovers
- Families
- Dog owners
- Those wanting value near nature

---

## Bloor West Village

### Overview
Charming village main street, Eastern European heritage, High Park adjacent.

### Stats
- **Rent (1BR)**: CAD 1,800-2,400
- **Vibe**: Village, family, established
- **Transit**: Jane, Runnymede stations
- **Walk Score**: 85

### Pros
- Village main street
- High Park nearby
- Subway access
- Family-friendly
- Good shopping/dining

### Cons
- Older buildings
- Limited nightlife
- Quiet weeknights

### Best For
- Families
- Those wanting village + subway
- European food lovers

---

## Comparing Suburbs

| Area | Transit | Food Scene | Value | Best For |
|------|---------|------------|-------|----------|
| North York | Good (Yonge) | Korean, diverse | Good | Subway-dependent |
| Scarborough | Poor | Best Asian in GTA | Excellent | Budget, car owners |
| Etobicoke (Mimico) | Good (GO) | Improving | Good | Lakefront seekers |
| Etobicoke (north) | Poor | Limited | Excellent | Car owners, space |
| Leaside | Moderate | Limited | Poor | Families, schools |
| Bloor West | Good | Good | Moderate | Village feel |

## Tips for Suburban Living

1. **Transit reality**: Check actual commute times on Google Maps at rush hour
2. **Car consideration**: Insurance expensive for new residents (CAD 200-400/mo)
3. **Food exploration**: Best ethnic food is in suburbs, worth the trip
4. **Community matters**: Suburbs have stronger neighborhood identity
5. **Space vs. time**: Calculate true cost (space gained vs. commute time lost)
