# Toronto Neighborhoods — Quick Comparison

## At a Glance

| Area | Vibe | 1BR Rent | Transit | Best For |
|------|------|----------|---------|----------|
| **Downtown Core** | Corporate, busy | CAD 2,500-3,200 | Excellent | Business, walkability |
| **King West** | Trendy, restaurants | CAD 2,400-3,000 | Great | Young professionals |
| **Queen West** | Hip, artistic | CAD 2,200-2,800 | Good | Creatives, nightlife |
| **Liberty Village** | Condo, young | CAD 2,200-2,700 | Moderate | Tech workers, couples |
| **Yorkville** | Luxury, upscale | CAD 3,000-4,000+ | Great | Affluent, shopping |
| **The Annex** | Academic, cafes | CAD 1,800-2,400 | Great | Students, academics |
| **Kensington** | Bohemian, diverse | CAD 1,600-2,200 | Moderate | Creatives, budget |
| **Leslieville** | Family, brunch | CAD 2,000-2,600 | Good | Families, foodies |
| **Beaches** | Beach town, relaxed | CAD 2,000-2,500 | Moderate | Families, outdoors |
| **North York** | Suburban, diverse | CAD 1,700-2,300 | Good | Families, value |
| **Scarborough** | Diverse, affordable | CAD 1,400-1,900 | Moderate | Budget, Asian food |
| **Etobicoke** | Suburban, quiet | CAD 1,600-2,200 | Moderate | Families, affordability |

## By Priority

### Best Transit (Car-Free Living)
1. Downtown Core (subway + streetcar)
2. Yorkville (Bloor-Yonge station)
3. The Annex (Spadina + Bathurst stations)
4. King West (King streetcar)

### Best Value (Quality/Price)
1. Scarborough (40% cheaper than downtown)
2. North York (suburban but connected)
3. Etobicoke (near lake, affordable)
4. Leslieville (neighborhood feel, reasonable)

### Best for Families
1. Beaches (community feel, waterfront)
2. North York (good schools, parks)
3. Leaside (affluent, family-oriented)
4. Etobicoke (space, schools)

### Best Nightlife
1. King West (restaurant row, clubs)
2. Queen West (bars, live music)
3. Entertainment District (clubs, late night)
4. Ossington (cocktail bars, trendy)

### Best Food Scene
1. King West (restaurants everywhere)
2. Leslieville (brunch capital)
3. Kensington/Chinatown (diverse, cheap eats)
4. Yorkville (fine dining)

### Most Character
1. Kensington Market (bohemian, eclectic)
2. Queen West (street art, indie)
3. The Annex (historic, academic)
4. Distillery District (heritage, restored)

## Cost Breakdown (Monthly, Single Person)

| Area | Rent (1BR) | Food/Groceries | Transport | Total |
|------|-----------|----------------|-----------|-------|
| Downtown | CAD 2,800 | CAD 600 | CAD 0-150 | CAD 3,400-3,550 |
| King West | CAD 2,700 | CAD 650 | CAD 0-150 | CAD 3,350-3,500 |
| Liberty | CAD 2,400 | CAD 550 | CAD 150 | CAD 3,100 |
| Leslieville | CAD 2,300 | CAD 500 | CAD 150 | CAD 2,950 |
| Annex | CAD 2,100 | CAD 500 | CAD 100 | CAD 2,700 |
| North York | CAD 2,000 | CAD 450 | CAD 150 | CAD 2,600 |
| Scarborough | CAD 1,600 | CAD 400 | CAD 150 | CAD 2,150 |

## Neighborhood Clusters

### Downtown Central
- Financial District, Entertainment District, St. Lawrence
- Most urban, most expensive, most walkable
- See: `neighborhoods-downtown.md`

### West End
- King West, Queen West, Liberty Village, Parkdale, Ossington
- Trendy, restaurants, younger crowd
- See: `neighborhoods-west.md`

### Midtown
- Yorkville, Annex, Rosedale, Summerhill, Forest Hill
- Upscale, established, good transit
- See: `neighborhoods-midtown.md`

### East End
- Leslieville, Beaches, Riverside, Danforth
- Family-friendly, community feel, emerging
- See: `neighborhoods-east.md`

### Suburbs
- North York, Scarborough, Etobicoke
- Affordable, diverse, car-helpful
- See: `neighborhoods-suburban.md`
