# Downtown Toronto Neighborhoods

## Financial District

### Overview
Toronto's business core. Bay Street (Canada's Wall Street), corporate towers, underground PATH system.

### Stats
- **Rent (1BR)**: CAD 2,500-3,200
- **Vibe**: Corporate weekdays, quiet weekends
- **Transit**: Union Station (all lines), multiple subway stops
- **Walk Score**: 98

### Pros
- Ultimate walkability
- PATH access (30+ km underground)
- Best transit hub (Union Station)
- Walk to everything downtown

### Cons
- Expensive
- Soulless on weekends
- Few grocery options
- Limited nightlife (business crowd)

### Best For
- Finance/law professionals
- People who hate commuting
- Business travelers relocating

### Key Streets
- Bay Street (finance)
- King Street (streetcar, restaurants)
- Front Street (Union Station)

---

## Entertainment District

### Overview
Theatres, sports venues, restaurants, nightlife. Where downtown comes alive at night.

### Stats
- **Rent (1BR)**: CAD 2,400-3,000
- **Vibe**: Energetic, tourists, sports fans
- **Transit**: St. Andrew, Union stations
- **Walk Score**: 99

### Pros
- CN Tower, Ripley's, Rogers Centre steps away
- Best nightlife concentration
- Restaurant row on King West
- Walkable to everything

### Cons
- Noisy weekends
- Tourist crowds
- Expensive dining
- Party atmosphere not for everyone

### Best For
- Young professionals
- Sports fans (Leafs, Raptors, Blue Jays)
- Nightlife lovers

### Key Spots
- Rogers Centre (Blue Jays)
- Scotiabank Arena (Leafs, Raptors)
- TIFF Bell Lightbox
- Roy Thomson Hall

---

## St. Lawrence

### Overview
Historic neighborhood, Victorian buildings, best weekend market. Toronto's oldest planned community.

### Stats
- **Rent (1BR)**: CAD 2,300-2,800
- **Vibe**: Historic, foodie, established
- **Transit**: King streetcar, Union Station nearby
- **Walk Score**: 97

### Pros
- St. Lawrence Market (Saturday farmers market)
- Beautiful architecture
- Quieter than Financial District
- Close to Distillery

### Cons
- Limited late-night options
- Older buildings (charm but quirks)
- Small neighborhood

### Best For
- Foodies
- History lovers
- Those wanting downtown without chaos

### Key Spots
- St. Lawrence Market
- Hockey Hall of Fame
- Flatiron Building
- St. James Cathedral

---

## Distillery District

### Overview
Pedestrian-only heritage district. Victorian industrial architecture, galleries, restaurants.

### Stats
- **Rent (1BR)**: CAD 2,400-3,000
- **Vibe**: Artsy, romantic, tourist-friendly
- **Transit**: King streetcar, 504 streetcar
- **Walk Score**: 92

### Pros
- Car-free streets
- Stunning architecture
- Great restaurants/cafes
- Galleries and boutiques

### Cons
- Touristy
- Limited grocery/daily needs
- Slightly isolated
- Expensive dining

### Best For
- Couples
- Architecture lovers
- Those who prioritize aesthetics

### Key Spots
- Mill Street Brewery
- Young Centre for the Arts
- Christmas Market (seasonal)
- Brick Street Bakery

---

## Harbourfront / Waterfront

### Overview
Lake Ontario shoreline. Condos, parks, cultural venues, ferry terminal to Islands.

### Stats
- **Rent (1BR)**: CAD 2,400-3,200
- **Vibe**: Scenic, recreational, condo-heavy
- **Transit**: 509/510 streetcars, Union nearby
- **Walk Score**: 85

### Pros
- Lake views
- Waterfront trail
- Jack Layton Ferry Terminal
- Harbourfront Centre events

### Cons
- Wind off lake (cold winter, refreshing summer)
- Condo canyon feel
- Limited street life
- Grocery deserts in parts

### Best For
- Water lovers
- Runners/cyclists
- Those who value views
- Ferry commuters to Islands

### Key Spots
- Sugar Beach
- Queens Quay
- Harbourfront Centre
- Music Garden

---

## Corktown

### Overview
One of Toronto's oldest neighborhoods, now rapidly gentrifying. Historic row houses meet new condos.

### Stats
- **Rent (1BR)**: CAD 2,200-2,700
- **Vibe**: Emerging, historic, evolving
- **Transit**: King/Queen streetcars
- **Walk Score**: 91

### Pros
- Character and history
- Near Distillery
- More affordable than core
- Community feel emerging

### Cons
- Still developing amenities
- Transitional area
- Limited nightlife

### Best For
- Those wanting downtown access + character
- First-time downtown renters
- People who like emerging areas
