# Choosing a Toronto Neighborhood

## Decision Framework

### Step 1: Define Your Non-Negotiables

| Priority | Questions to Ask |
|----------|------------------|
| **Commute** | Where is your office? How long is acceptable? |
| **Budget** | What's your rent ceiling? Include utilities? |
| **Transit** | Must have subway? Or okay with streetcar/bus? |
| **Lifestyle** | Nightlife? Quiet? Parks? Beach? |
| **Space** | Need full apartment? Okay with roommates? |

### Step 2: Filter by Budget

| Monthly Rent Budget | Realistic Areas |
|---------------------|-----------------|
| Under CAD 1,600 | Scarborough, North Etobicoke, Rexdale |
| CAD 1,600-2,000 | North York, East York, Danforth, Parkdale |
| CAD 2,000-2,400 | Leslieville, Annex, Liberty Village, Mimico |
| CAD 2,400-3,000 | King West, Queen West, Downtown |
| CAD 3,000+ | Yorkville, Waterfront, Rosedale |

### Step 3: Match to Lifestyle

## By Life Stage

### New Graduate / Entry Level
**Budget**: CAD 1,600-2,200
**Priorities**: Transit, social scene, affordable

**Recommendations:**
1. **The Annex** — Near UofT, cafes, affordable
2. **North York (Yonge)** — Subway, value, young
3. **Liberty Village** — Tech scene, social, new builds

### Young Professional (Single)
**Budget**: CAD 2,200-2,800
**Priorities**: Restaurants, nightlife, walkability

**Recommendations:**
1. **King West** — Restaurant capital, trendy
2. **Queen West** — Creative, nightlife
3. **Ossington** — Cocktails, foodie, less touristy

### Couple (No Kids)
**Budget**: CAD 2,400-3,200
**Priorities**: Space, dining, quality of life

**Recommendations:**
1. **Leslieville** — Brunch, community, space
2. **Riverside** — Character, near downtown
3. **Trinity Bellwoods area** — Park life, trendy

### Young Family
**Budget**: CAD 2,200-3,000
**Priorities**: Schools, parks, safety, space

**Recommendations:**
1. **Beaches** — Beach, community, family vibe
2. **Leaside** — Schools, quiet, parks
3. **Bloor West Village** — High Park, village feel
4. **North York (Willowdale)** — Space, schools, value

### Established Family
**Budget**: CAD 3,000+
**Priorities**: Best schools, space, prestige

**Recommendations:**
1. **Forest Hill** — Top schools, prestigious
2. **Rosedale** — Old money, ravines
3. **Leaside** — Community, schools

### Remote Worker
**Budget**: Variable
**Priorities**: Coffee shops, walkability, quiet workspace

**Recommendations:**
1. **Leslieville** — Cafes everywhere, community
2. **The Annex** — Cafes, bookstores, academic vibe
3. **Trinity Bellwoods** — Park, coffee, scene

## By Work Location

### Financial District (Bay/King)
| Commute Time | Best Areas |
|--------------|------------|
| Walk (10 min) | Financial District, St. Lawrence |
| 15-20 min | King West, Harbourfront, Distillery |
| 30 min | Leslieville, Annex, Yorkville |
| 45+ min | North York, Beaches, Etobicoke |

### Tech Hub (King/Spadina, Liberty)
| Commute Time | Best Areas |
|--------------|------------|
| Walk (10 min) | King West, Liberty Village |
| 15-20 min | Queen West, Parkdale, Kensington |
| 30 min | Leslieville, Ossington, Annex |

### University Area (UofT)
| Commute Time | Best Areas |
|--------------|------------|
| Walk (10 min) | Annex, Kensington, Harbord |
| 15-20 min | Queen West, Yorkville |
| 30 min | Bloor West, Danforth |

### Suburban Office (North York, Scarborough)
Consider living near office rather than downtown commute:
- North York: Yonge corridor apartments
- Scarborough: Near STC or Agincourt
- Much cheaper, shorter commute, different lifestyle

## Red Flags When Apartment Hunting

### Building Issues
- No laundry (in unit or building)
- Coin laundry only (expensive long-term)
- No AC in older buildings (summer brutal)
- Basement apartments (legal? flooding? light?)
- Landlord lives in building (can be good or bad)

### Area Issues
- Empty storefronts (declining area)
- No grocery within walking distance
- Transit station announced but years away
- Construction cranes everywhere (noise for years)
- No people walking at night (safety?)

### Rental Process Red Flags
- Asking for deposit before viewing
- Cash only
- No lease
- "Landlord" doesn't know building
- Pressure to decide immediately
- Won't let you see utility bills

## The Toronto Rental Process

### What You Need
1. **ID**: Passport or Canadian ID
2. **Employment letter**: Confirming salary, position, start date
3. **Pay stubs**: Last 2-3
4. **Credit check**: They'll run it; no Canadian history is a barrier
5. **References**: Previous landlords, employer
6. **Bank statements**: Sometimes requested

### No Canadian Credit?
Common for newcomers. Solutions:
- Offer larger deposit (first + last required by law anyway)
- Get employer reference letter
- Bank statement showing savings
- Consider private landlords (more flexible than corporate)

### Timing
- **Listings appear**: 30-60 days before availability
- **Decision speed**: Good units go in days, sometimes hours
- **Best months**: Winter (less competition), worst: summer

### Costs to Budget
| Item | Amount |
|------|--------|
| First month rent | Due at signing |
| Last month rent | Due at signing (deposit) |
| Utilities | CAD 50-150/month (depends on inclusion) |
| Internet | CAD 60-100/month |
| Tenant insurance | CAD 20-40/month (required) |

## Neighborhood Red Flags

### Indicators to Research Further
- Lots of payday loan shops
- Many dollar stores, few restaurants
- No new construction in area
- Frequent police activity
- Empty parks despite good weather

### Tools to Research
- **Walk the area** at different times (morning, evening, weekend)
- **Google Street View** to check cleanliness, businesses
- **Toronto crime maps** (public data)
- **Yelp/Google reviews** of nearby restaurants
- **Reddit r/askTO** — search neighborhood name

## Final Checklist

Before signing:

- [ ] Visited at different times of day
- [ ] Checked actual transit times (Google Maps)
- [ ] Walked to nearest grocery store
- [ ] Identified nearest subway/streetcar
- [ ] Researched building reviews (Google, Facebook groups)
- [ ] Understood included utilities
- [ ] Confirmed legal basement (if basement)
- [ ] Have tenant insurance quote
- [ ] Understand lease terms and renewal
