# Toronto Local Services Guide

## Banking

### Big 5 Banks
| Bank | Notes |
|------|-------|
| TD | Most branches, long hours, green |
| RBC | Largest bank, good app |
| BMO | Oldest bank, solid |
| Scotiabank | Good international, red |
| CIBC | Competitive, improving |

### Opening an Account

**What You Need**:
- Passport
- Work permit / PR card / study permit
- Proof of address (utility bill, lease)
- Initial deposit (CAD 50-100)

**Timeline**: Same day, card mailed within week.

**Newcomer Programs**: Most banks have newcomer packages with waived fees for first year.

### Account Types
| Type | Monthly Fee | Includes |
|------|-------------|----------|
| Basic | CAD 0-5 | Limited transactions |
| Standard | CAD 10-15 | More transactions |
| Premium | CAD 25-30 | Unlimited, perks |

**Ways to avoid fees**:
- Minimum balance (usually CAD 3,000-5,000)
- Direct deposit of paycheck
- Newcomer promotion periods
- Student/youth accounts

### Credit Building

No Canadian credit history = common problem for newcomers.

**Solutions**:
1. **Secured credit card** — Deposit becomes limit
2. **Newcomer credit card** — Banks offer these
3. **Add utility/phone** — Some report to bureaus
4. **Time** — Takes 6-12 months to build

### Credit Score
- Score range: 300-900
- Good: 660+
- Excellent: 760+
- Check free: Credit Karma, Borrowell

## Phone Plans

### Major Carriers
| Carrier | Network | Price Range |
|---------|---------|-------------|
| Rogers | Own | CAD 60-120 |
| Bell | Own | CAD 60-120 |
| Telus | Own | CAD 60-120 |
| Fido | Rogers | CAD 40-70 |
| Koodo | Telus | CAD 40-70 |
| Virgin | Bell | CAD 40-70 |
| Freedom | Own (limited) | CAD 30-50 |

### Budget Options
- **Public Mobile** — Telus network, prepaid, CAD 25-40
- **Lucky Mobile** — Bell network, prepaid
- **Freedom Mobile** — Own network, limited outside cities
- **Chatr** — Rogers network, basic

### What You Need
- Government ID
- Canadian address
- Credit check (waived with prepaid)

### Tips
- Negotiate — prices are starting points
- Bring your own phone — saves money
- Black Friday deals — significant discounts
- Retention department — call to cancel for offers
- eSIM available at most carriers

### Data Reality
Canada has expensive phone plans compared to Europe/Asia. Budget CAD 40-80/month for reasonable data.

## Internet

### Major Providers
| Provider | Type | Price |
|----------|------|-------|
| Bell | Fiber/DSL | CAD 80-130 |
| Rogers | Cable | CAD 80-130 |
| Beanfield | Fiber | CAD 50-100 |
| Teksavvy | Reseller | CAD 50-80 |
| Start.ca | Reseller | CAD 50-80 |

### Tips
- Check building options — some only have one
- Beanfield (fiber) — excellent if available
- Resellers (Teksavvy, Start) — better value
- Negotiate — promotional rates available
- Bring own modem/router — save rental fees

### What You Need
- Credit check (sometimes)
- Installation appointment
- CAD 50-100 setup fee typical

## Postal Services

### Canada Post
- Mail delivery to address
- Post offices and outlets in Shoppers Drug Mart
- Package pickup at post office if not delivered

### Getting Mail
- Apartment: Mailbox in building
- House: Mailbox at door
- Community mailbox: Walk to centralized box (suburbs)

### Packages
- Buzzer delivery common
- Package lockers increasing
- Pickup at post office if missed
- Flex Delivery — deliver to post office for pickup

## Libraries

### Toronto Public Library
**Free with proof of address**:
- Books, ebooks, audiobooks
- Movies, music
- Digital resources (LinkedIn Learning, language learning)
- 3D printing, recording studios (some branches)
- Free programs and events
- Computer/internet access
- Quiet study space

### Getting a Card
- Free
- Bring ID + proof of address
- Digital card available via app

### Branches
100+ branches across city. Reference Library (Yonge/Bloor) is largest.

## Government Services

### ServiceOntario
For provincial services:
- Health card (OHIP)
- Driver's license
- Ontario Photo ID
- Vehicle registration

**Locations**: Many across city, book appointments online.

### Service Canada
For federal services:
- SIN (Social Insurance Number)
- Passport
- Employment Insurance

### City of Toronto
- Property tax
- Parking permits
- Recreation programs
- Utilities

## Healthcare

### Finding a Doctor
Challenging — many not accepting new patients.

**Options**:
1. Walk-in clinics (no appointment)
2. Health Care Connect (Ontario service to find doctor)
3. Hospital clinics
4. Ask community/work for referrals

### Pharmacies
| Chain | Notes |
|-------|-------|
| Shoppers Drug Mart | Largest, 24-hour locations |
| Rexall | Common alternative |
| Pharmasave | Independent |

### Telehealth
- Telehealth Ontario: 1-866-797-0000 (free medical advice)
- Virtual care apps (Maple, Tia Health)

### Dental & Vision
Not covered by OHIP. Options:
- Employer benefits
- University dental clinics (cheaper)
- Pay out of pocket

## Laundry

### Options
| Type | Cost |
|------|------|
| In-unit | Included in rent |
| In-building | CAD 2-4 per load |
| Laundromat | CAD 3-6 per load |
| Dry cleaning | CAD 10-30 per item |

### Tips
- Check washer/dryer before signing lease
- Laundry card systems common (load money)
- Some buildings have app-controlled machines

## Moving Services

### Companies
- You Move Me
- El Cheapo Movers
- Two Men and a Truck
- Various local companies

### Cost
| Type | Cost |
|------|------|
| Small move (1BR, local) | CAD 300-600 |
| Medium move (2BR, local) | CAD 500-1,000 |
| DIY rental truck | CAD 100-300/day |

### Tips
- Book early (month-end busy)
- Get multiple quotes
- Read reviews carefully
- Insurance options available

## Other Services

### Car Share
- Zipcar
- Enterprise CarShare
- Communauto

### Bike Share
- Bike Share Toronto (CAD 115/year)

### Package Lockers
- Amazon Hub
- Penguin Pick-Up
- Building package rooms

### Dry Cleaning
- Multiple chains (Fabricare, etc.)
- Many neighborhood options
- CAD 10-30 per item typical

### Grocery Delivery
- Instacart
- Grocery Gateway
- Store apps (Loblaws, Metro)
