# Toronto Immigration Guide

## Overview

Canada has one of the world's most accessible immigration systems, especially for skilled workers. Toronto is the top destination for newcomers.

## Temporary Status Options

### Work Permits

**LMIA-Based Work Permit**
- Employer applies for Labour Market Impact Assessment
- Proves no Canadian available
- Processing: 2-4 months
- Tied to specific employer

**LMIA-Exempt Work Permits**
- No labor market test needed
- Categories:
  - Intra-Company Transfer (ICT)
  - CUSMA/USMCA professionals (US/Mexico citizens)
  - International agreements
  - Significant benefit to Canada

**Global Talent Stream (GTS)**
- Fast-track for tech workers
- 2-week processing
- Employer must be on list or be referred
- Best option for tech roles

**Open Work Permits**
- Not tied to employer
- Available to:
  - Spouses of skilled workers
  - PGWP holders
  - Some humanitarian categories

### Post-Graduation Work Permit (PGWP)
For international students:
- Study 2+ years = 3-year work permit
- Study 1-2 years = Work permit length = study length
- Open work permit (any employer)
- Common path to PR

### Study Permits
- For programs over 6 months
- Can work 20hrs/week during studies
- Leads to PGWP

### Visitor Status
- Most nationalities: eTA required (CAD 7)
- Some: Visitor visa required
- Max 6 months per entry
- Cannot work on visitor status

## Permanent Residence Paths

### Express Entry

**The Main System**
Points-based pool for federal economic programs:

1. **Federal Skilled Worker (FSW)**
   - 1+ year skilled work experience
   - Language test required
   - Education credential assessment

2. **Canadian Experience Class (CEC)**
   - 1+ year Canadian work experience
   - Easier for those already in Canada
   - Language test required

3. **Federal Skilled Trades (FST)**
   - Skilled trade experience
   - Job offer or certification

**CRS Score (Comprehensive Ranking System)**
| Factor | Points |
|--------|--------|
| Age (20-29 optimal) | Up to 110 |
| Education | Up to 150 |
| Language | Up to 160 |
| Work experience | Up to 80 |
| Canadian experience | Up to 80 |
| Arranged employment | 50-200 |
| Provincial nomination | 600 |

**Cut-off scores (varies)**
- General draws: 470-510 typically
- Category draws (tech, healthcare): Can be lower
- Provincial nomination: Virtually guaranteed (adds 600)

### Provincial Nominee Programs (PNP)

**Ontario Immigrant Nominee Program (OINP)**

Streams relevant to Toronto:
1. **Tech Draws** — Specific tech occupations, Express Entry linked
2. **Human Capital Priorities** — High CRS scores
3. **Employer Job Offer** — With Ontario job offer
4. **Masters/PhD Graduate** — Ontario graduates

**Ontario Tech Draws**
Priority occupations:
- Software engineers/developers
- Computer programmers
- Web developers
- Database analysts
- IT professionals

### Atlantic Immigration Program
For Atlantic provinces (not Ontario), but some use it strategically.

### Start-Up Visa
For entrepreneurs:
- Business idea
- Support from designated organization
- Language requirement
- Settlement funds

## Process Timeline

### Work Permit to PR (Typical Path)

```
Month 0: Arrive on work permit
         ↓
Month 1-12: Work, settle, language tests
         ↓
Month 12: 1 year Canadian experience
          Apply Express Entry
         ↓
Month 12-14: Enter pool, wait for draw
         ↓
Month 14-20: PR processing (if invited)
         ↓
Month 20: PR confirmed
```

### Key Timing
| Step | Duration |
|------|----------|
| Work permit processing | 2-16 weeks |
| Express Entry pool | Draws every 2 weeks |
| PR processing | 6-12 months |
| OINP processing | 3-6 months |

## Requirements

### Language Tests
**English**
- IELTS General Training (most common)
- CELPIP General

**French**
- TEF Canada
- TCF Canada

**Required Scores (Express Entry FSW)**
- Minimum CLB 7 (IELTS ~6.0 each band)
- Higher scores = more points

### Education Credential Assessment (ECA)
- Required for foreign education
- WES most common organization
- Takes 2-8 weeks
- Shows Canadian equivalency

### Proof of Funds
For FSW (not CEC):
| Family Size | Amount Required |
|-------------|-----------------|
| 1 person | CAD 14,690 |
| 2 people | CAD 18,288 |
| 3 people | CAD 22,483 |
| 4 people | CAD 27,297 |

## Toronto-Specific Tips

### Jobs That Help
Tech occupations favored in:
- Express Entry category draws
- Ontario tech draws
- Global Talent Stream

### Where to Live While Processing
- Stay in Toronto (provincial connection helps OINP)
- Keep valid status
- Maintain employment

### Resources
- **IRCC**: canada.ca/immigration
- **Ontario Immigration**: ontario.ca/immigration
- **Settlement agencies**: Free help for newcomers

## Common Strategies

### High CRS Score Path
1. Score 470+ in Express Entry
2. Wait for general draws
3. Apply when invited

### PNP Path (Lower CRS)
1. Score 400-470
2. Apply for Ontario PNP notification of interest
3. If nominated: +600 points
4. Almost guaranteed PR invite

### Student to PR Path
1. Study permit (2-year program)
2. PGWP (3 years)
3. Work 1 year
4. Apply CEC through Express Entry

### Employer Support Path
1. LMIA job offer
2. 50-200 bonus points
3. Express Entry or PNP

## Maintaining Status

### While on Work Permit
- Keep passport valid
- Extend work permit before expiry
- Maintain employment (if closed permit)
- Report address changes

### While PR Application Pending
- Maintain valid temporary status
- Can apply for Bridging Open Work Permit (BOWP)
- Don't leave Canada without proper documents

### After PR
- PR card valid 5 years
- Must be in Canada 730 days per 5 years
- Can apply for citizenship after 3 years

## Citizenship

### Requirements
- PR for 3 of last 5 years
- File taxes
- Pass citizenship test
- Language requirement (CLB 4)
- No criminal issues

### Process
- Application: ~12-18 months
- Test: Canadian history, rights, responsibilities
- Ceremony: Oath of citizenship

### Benefits
- Canadian passport
- Vote
- No residency requirement
- Cannot be deported

## Getting Help

### Free Resources
- Settlement agencies (YMCA, COSTI, etc.)
- Library programs
- Government websites

### Paid Help
- Immigration lawyers (RCIC or lawyer)
- Immigration consultants (regulated RCICs only)
- Avoid unregulated consultants

### Red Flags
- Guaranteed results
- Bypass the system
- Not RCIC registered
- Asks for original documents to keep
