# Toronto Healthcare Guide

## OHIP (Ontario Health Insurance Plan)

### What It Is
Provincial health insurance providing free healthcare to eligible residents.

### Eligibility
- Ontario resident
- Legal status (PR, citizen, valid work/study permit)
- Present in Ontario 153+ days per year

### Wait Period
**3 months** from establishing residency.

During wait period:
- Not covered by OHIP
- Need private insurance
- Emergency care still available (but billed)

### Applying
**Where**: ServiceOntario
**Documents**:
- ID (passport)
- Immigration documents
- Proof of Ontario residence
- Proof of presence in Ontario

**Process**:
1. Apply in person
2. Get temporary confirmation
3. Health card mailed (2-3 weeks)

### What's Covered

**Covered by OHIP**
- Doctor visits
- Hospital stays
- Surgery
- Diagnostic tests
- Mental health (psychiatry)
- Prenatal and childbirth
- Most medical procedures

**NOT Covered**
- Prescription drugs (outside hospital)
- Dental care
- Vision care (eye exams limited)
- Physiotherapy (most)
- Cosmetic procedures
- Private hospital rooms
- Ambulance fees (CAD 45-240)

### Prescription Drug Coverage

**Ontario Drug Benefit (ODB)**
- Covers those 65+
- Covers social assistance recipients
- Covers long-term care residents

**OHIP+**
- Covers those 24 and under
- Many common prescriptions free

**For Others**
- Employer benefits common
- Private insurance
- Pay out of pocket

## Finding a Doctor

### The Challenge
Many family doctors not accepting new patients. This is a real problem in Ontario.

### Options

**Health Care Connect**
- Ontario service to match patients with doctors
- Register online: ontario.ca/healthcareconnect
- May take months
- Better than nothing

**Walk-In Clinics**
- No appointment needed
- See whoever is available
- Good for non-urgent issues
- Found throughout city

**Family Health Teams**
- Group practices
- May have openings
- Check individual websites

**Community Health Centres**
- Serve specific populations
- May have more availability
- Check eligibility

**Telehealth Ontario**
- 1-866-797-0000
- Free, 24/7
- Nurses provide advice
- Can direct to appropriate care

### Virtual Care

**Apps/Services**
- Maple
- Tia Health
- Cover
- Telus Health

- See doctor via video
- Prescriptions possible
- CAD 50-100 per visit (or covered by benefits)

## Hospitals

### Major Downtown Hospitals

| Hospital | Specialty | Location |
|----------|-----------|----------|
| Toronto General | General, transplant | University/Dundas |
| St. Michael's | Trauma, inner city | Queen/Victoria |
| Mount Sinai | Obstetrics, specialties | University/Dundas |
| SickKids | Children | University/Dundas |
| Princess Margaret | Cancer | University/Dundas |

### Emergency Rooms
- Open 24/7
- Long waits common (4-12 hours)
- Triage by urgency, not arrival
- Go for real emergencies only

### Urgent Care
Alternative to ER for non-life-threatening:
- Shorter waits
- Extended hours
- Growing number of locations

## Specialists

### Referral System
- Need referral from family doctor/walk-in
- Wait times vary (weeks to months)
- Some specialists longer waits

### Common Wait Times
| Specialty | Typical Wait |
|-----------|--------------|
| Dermatology | 2-4 months |
| Orthopedics | 2-6 months |
| Psychiatry | 1-6 months |
| MRI | 1-3 months |
| Surgery | Varies widely |

## Dental Care

### Not Covered by OHIP
Dental is private pay or insurance.

### Costs
| Service | Cost |
|---------|------|
| Cleaning | CAD 150-250 |
| X-rays | CAD 50-100 |
| Filling | CAD 150-400 |
| Root canal | CAD 800-1,500 |
| Crown | CAD 1,000-2,000 |

### Options
- Employer benefits (most common)
- Private insurance
- Dental schools (cheaper, students supervised)
- Community health centres (lower income)

### Finding a Dentist
- Insurance provider networks
- Reviews (Google, Yelp)
- Referrals from friends

## Vision Care

### Coverage
- OHIP covers annual exam for under 20 and 65+
- Others: Private pay or insurance

### Costs
| Service | Cost |
|---------|------|
| Eye exam | CAD 80-150 |
| Glasses | CAD 200-600 |
| Contact lenses | CAD 200-500/year |

### Options
- Costco Optical (good value)
- Clearly (online contacts)
- Chain opticians (LensCrafters, etc.)

## Mental Health

### OHIP Covered
- Psychiatrists (MD)
- Hospital mental health programs
- Crisis services

### Not Covered
- Psychologists (PhD)
- Psychotherapists
- Counsellors

### Resources
- CAMH (Centre for Addiction and Mental Health)
- Crisis lines
- Community mental health centers
- EAP (Employee Assistance Programs) through work

### Crisis Resources
| Service | Contact |
|---------|---------|
| Crisis Line | 416-408-4357 |
| Distress Centre | 416-408-4357 |
| Kids Help Phone | 1-800-668-6868 |
| Suicide Prevention | 988 |

## Private Insurance

### What It Covers
Typically:
- Prescription drugs
- Dental
- Vision
- Paramedical (massage, physio, chiro)
- Private hospital room
- Travel insurance

### Sources
- Employer benefits (most common)
- Individual plans (Blue Cross, Manulife, etc.)
- Student plans (universities)
- Association plans

### Gap Insurance
For 3-month OHIP wait:
- Essential for newcomers
- CAD 100-200/month
- Covers emergencies and basic care

## Pharmacies

### Major Chains
| Chain | Notes |
|-------|-------|
| Shoppers Drug Mart | Largest, 24-hour locations |
| Rexall | Common alternative |
| Pharmasave | Independent |
| Costco | Cheaper, no membership needed for pharmacy |

### Tips
- Compare prices (vary significantly)
- Ask about generic alternatives
- Pharmacy apps track prescriptions
- Some do vaccinations

## Vaccinations

### Where
- Pharmacies (most vaccines)
- Public health clinics
- Family doctors
- Travel clinics (for travel vaccines)

### Common Vaccines
- Flu shot (free annually)
- COVID (free)
- HPV (free for eligible)
- Travel vaccines (paid)
