# Toronto Food Practical Guide

## Dietary Requirements

### Vegetarian / Vegan

Toronto is very vegetarian/vegan friendly.

**Dedicated Vegan Restaurants**
- **Planta** — Upscale vegan, multiple locations
- **Fresh** — Casual, multiple locations
- **Hogtown Vegan** — Comfort food
- **Doomie's** — Vegan comfort food

**Best Areas for Options**
- Kensington Market — Many options
- Queen West — Trendy vegan spots
- The Annex — Student-friendly, cafes

**Indian Vegetarian**
- **Udupi Palace** — South Indian
- **Saravanaa Bhavan** — Chain, reliable

**Tips**
- Most restaurants have vegan options
- Apps: HappyCow for finding spots
- "Vegan" understood everywhere

### Halal

Large Muslim community means excellent halal options.

**Best Areas**
- Thorncliffe Park — Pakistani, Afghani
- Scarborough — Diverse halal
- Gerrard East — South Asian

**Chains with Halal**
- Paramount Fine Foods
- Lazeez Shawarma
- Many independent restaurants

**Tips**
- Halal certification posted if certified
- Ask if unsure
- Many Indian/Pakistani restaurants fully halal

### Kosher

**Best Areas**
- Bathurst corridor (north of Eglinton)
- North York

**Options**
- Several kosher restaurants
- Kosher sections at grocery stores
- Centre Street Deli (classic)

### Gluten-Free

Generally available everywhere.

**Dedicated/Excellent Options**
- **Roselle Desserts** — GF options
- **Fresh** — Many GF dishes
- Most upscale restaurants accommodate

**Tips**
- Always mention allergy, not just preference
- Asian cuisines: be careful of soy sauce
- Celiac disease taken seriously

### Allergies

**Communication**
- Servers generally well-trained
- Cards in different languages available online
- Always mention severity

**Tips**
- Peanut allergies: Asian cuisines more challenging
- Shellfish: ask about stock in soups
- Dairy: clear lactose-free options available

## Tipping Culture

### Standard Tips
| Service | Tip |
|---------|-----|
| Restaurant | 15-20% (on pre-tax amount) |
| Bar | 15% or CAD 1-2/drink |
| Takeout | Optional, 10% appreciated |
| Delivery | 15% minimum |
| Coffee shop | Optional, change jar |
| Buffet | 10% |

### How It Works
- Tip on PRE-TAX amount (not after 13% HST)
- Payment machines suggest tips (often inflated)
- Manual entry always option
- Credit card tips go to staff (legally required)

### When to Tip Less/More
- **Less** (10-15%): Genuinely bad service
- **More** (20%+): Exceptional service, complex orders
- **Never tip less** as silent protest — speak to manager

## Reservations

### When Needed
- **Essential**: King West popular spots, fine dining, weekend brunch
- **Recommended**: Any dinner Friday/Saturday
- **Walk-in OK**: Casual spots, weeknight dinners

### Platforms
- **Resy** — Trendy spots
- **OpenTable** — Wide coverage
- **Yelp** — Some restaurants
- **Direct** — Fine dining often has own system

### Tips
- Book 1-2 weeks ahead for popular spots
- Friday/Saturday dinner: book early
- Cancellation policies often enforced
- Large groups (6+): call directly

## Brunch Culture

### The Scene
Toronto takes brunch seriously. Weekend brunch is social institution.

### When to Go
- Peak: 10am-1pm Saturday/Sunday
- Avoid wait: Before 10am or after 2pm
- Weekday brunch: Much easier

### What to Expect
- 30-60 minute waits at popular spots
- Some places take reservations
- Bring patience
- Coffee while you wait sometimes

### Brunch Spots Tiers
| Tier | Examples | Wait Time |
|------|----------|-----------|
| Legendary | Lady Marmalade, School | 45-90 min |
| Popular | Mildred's Temple, Saving Grace | 30-60 min |
| Good | Many neighborhood spots | 0-30 min |

## Alcohol

### Legal
- Drinking age: 19
- Hours: Bars until 2am (some 3am)
- LCBO/Beer Store: Primary alcohol retail
- Grocery stores: Beer, wine, cider now

### Where to Buy
- **LCBO** — Wine, spirits, imported beer
- **Beer Store** — Beer, returning empties
- **Grocery stores** — Limited selection, beer/wine/cider

### At Restaurants
- Wine markup high (2-3x retail)
- BYOB: Rare, some Portuguese/Italian places
- Corkage: CAD 25-50 if allowed
- Happy hour: Limited due to regulations

### Cocktail Scene
- Ossington: Best cocktail bars
- King West: Trendy bars
- Yorkville: Hotel bars
- Speakeasies: Several hidden bars

## Late Night Food

### After 11pm Options

**24-Hour or Late**
- **Owl of Minerva** — Korean, 24 hours
- **Rol San** — Dim sum, late night
- **Fran's** — Diner, classic
- **7 West** — Diner

**Until Midnight-1am**
- Most King West restaurants
- Chinatown spots
- Kensington casual spots

**After 2am (Post-Bar)**
- Limited options
- Pizza slices
- Some convenience stores
- McDonald's
- Uber Eats limited

## Grocery & Food Shopping

### Major Chains
| Chain | Vibe | Price |
|-------|------|-------|
| Loblaws | Standard | $$ |
| Metro | Standard | $$ |
| Sobeys | Upscale | $$$ |
| No Frills | Budget | $ |
| Freshco | Budget | $ |
| Whole Foods | Premium | $$$$ |

### Specialty
- **T&T** — Asian supermarket (Chinese focus)
- **PAT** — Korean
- **Iqbal** — Halal, South Asian
- **Cheese Boutique** — Cheese, deli
- **St. Lawrence Market** — Local, fresh

### Farmers Markets
- St. Lawrence (Saturday)
- Evergreen Brick Works (Saturday)
- Multiple neighborhood markets (summer)

## Food Delivery

### Apps
- **Uber Eats** — Widest selection
- **DoorDash** — Good selection
- **SkipTheDishes** — Canadian
- **Ritual** — Pickup/office ordering

### Tips
- Service fees add up fast
- Often cheaper to pickup
- Driver tip: 15% minimum
- Check restaurant's own delivery first

## Money-Saving Tips

1. **Lunch vs Dinner**: Same restaurant, 30-40% less at lunch
2. **Prix fixe**: Winterlicious/Summerlicious events
3. **BYOB spots**: Portuguese, some Italian
4. **Food courts**: Quality ethnic food cheap
5. **Chinatown**: Excellent value
6. **Set menus**: Often better value than a la carte
7. **Early bird**: Some spots have early dinner specials
8. **Pickup over delivery**: Save fees
9. **Happy hour**: Limited but exists
10. **Grocery prepared foods**: Underrated option
