# Toronto Education Guide

## Public School System

### Overview
Ontario has publicly funded education from kindergarten through high school (grades 1-12).

### School Boards in Toronto
| Board | Type | Notes |
|-------|------|-------|
| TDSB | Public secular | Largest in Canada |
| TCDSB | Public Catholic | Religious curriculum |
| CSDCSO | French Catholic | French language |
| CSDCCS | French public | French language |

### Public Schools
- Free for residents
- Based on home address
- Quality varies by neighborhood
- Funded by property taxes

### Catholic Schools
- Also publicly funded (Ontario unique)
- Religious curriculum
- Must be Catholic (or accept religious instruction)
- Often perceived as higher discipline

### French Immersion
- Available in many public schools
- Entire curriculum in French
- Popular choice
- Apply early (competitive)

## Private Schools

### Overview
- Not publicly funded
- Tuition-based
- Often higher resources
- Various philosophies

### Cost Range
| Type | Annual Tuition |
|------|---------------|
| Independent day | CAD 15,000-35,000 |
| Elite day | CAD 35,000-45,000 |
| Boarding | CAD 50,000-70,000 |

### Notable Schools
| School | Type | Notes |
|--------|------|-------|
| Upper Canada College | Boys | Established, prestigious |
| Havergal | Girls | Traditional, strong |
| Bishop Strachan | Girls | Anglican, historic |
| Crescent | Boys | University prep |
| St. Andrew's College | Boys boarding | Aurora location |
| Branksome Hall | Girls | IB program |
| Royal St. George's | Coed | Downtown |

### Alternative Schools
- Montessori schools
- Waldorf schools
- Democratic schools
- Specialized (arts, STEM)

## Choosing Schools

### Factors to Consider
- Catchment area (public)
- School rankings (Fraser Institute, controversial)
- Programs offered (IB, AP, French)
- Extracurriculars
- Class sizes
- Community feel

### Research
- Visit schools
- Talk to parents
- Check EQAO scores (standardized testing)
- Attend open houses

### Moving for Schools
Common practice:
- Research school catchments
- Rent/buy in preferred catchment
- Verify with school board before signing lease

## Daycare & Early Childhood

### Types

**Licensed Daycare**
- Regulated by province
- Staff ratios mandated
- Inspected regularly
- CAD 1,500-2,500/month

**Home Daycare**
- In caregiver's home
- Licensed or unlicensed
- Smaller groups
- CAD 1,200-1,800/month

**Nanny**
- In your home
- One-on-one or nanny share
- CAD 2,500-4,000/month
- Employer responsibilities

### CAD 10/Day Childcare
- Federal-provincial program
- Expanding availability
- Long waitlists
- Apply early (at pregnancy)

### Finding Childcare
- OneList (ontario.ca/onelist)
- Start looking early (1+ year ahead)
- Waitlists common
- Multiple applications necessary

## Post-Secondary

### Universities in Toronto Area

| Institution | Type | Strengths |
|-------------|------|-----------|
| University of Toronto | Research university | Global top 20, all fields |
| Toronto Metropolitan (Ryerson) | Urban university | Media, business, tech |
| York University | Large university | Business, law, arts |
| OCAD | Art & design | Creative fields |

### Colleges

| College | Notes |
|---------|-------|
| George Brown | Downtown, hospitality, health |
| Humber | West end, media, business |
| Seneca | Multiple campuses, technology |
| Centennial | Scarborough, diverse programs |

### Tuition

**Domestic Students**
- University: CAD 7,000-15,000/year
- College: CAD 3,000-7,000/year

**International Students**
- University: CAD 40,000-60,000/year
- College: CAD 15,000-25,000/year

### Admissions
- OUAC (Ontario Universities Application Centre)
- OCAS (Ontario College Application Service)
- Apply in fall for following September
- Competitive for popular programs

## International Students

### Study Permits
- Required for programs over 6 months
- Apply through IRCC
- Proof of funds required
- Acceptance letter needed

### Work While Studying
- 20 hours/week during school
- Full-time during breaks
- No separate permit needed

### Post-Graduation
- PGWP (Post-Graduate Work Permit)
- Up to 3 years for 2-year programs
- Path to permanent residence

### Designated Learning Institutions
- Must attend DLI for PGWP eligibility
- All public schools qualify
- Check private institution status

## Continuing Education

### Options
- University continuing education
- College certificates
- Professional development
- Online learning

### Popular Programs
- Project management
- Data analytics
- UX design
- Business certifications
- Language learning

### Free Resources
- Toronto Public Library (LinkedIn Learning, courses)
- Coursera, edX (auditing)
- YouTube, free MOOCs

## Credential Recognition

### Foreign Credentials
Many professions require Canadian credentials or assessment:
- Engineering: PEO (Professional Engineers Ontario)
- Medicine: CPSO (College of Physicians)
- Law: NCA (National Committee on Accreditation)
- Accounting: CPA Ontario

### Steps
1. Get credentials assessed (WES common)
2. Check professional body requirements
3. May need bridging programs
4. May need Canadian exams

### Bridging Programs
- Help internationally trained professionals
- Various institutions offer them
- Some government funded
- Check eligibility

## Support Services

### For Newcomers
- Settlement agencies
- Language programs (LINC - free)
- Employment programs
- Credential assessment

### For Students
- Student loans (OSAP)
- Bursaries and scholarships
- Campus support services
- Food banks (campus)

### Learning Disabilities
- Accommodations required by law
- Assessment available (schools, private)
- Support programs exist
- Advocate for needs
