# Driving in Toronto

## Do You Need a Car?

### Probably Not If
- Living downtown
- Working downtown
- Near subway line
- Single or couple
- Work from home

### Helpful If
- Living in suburbs
- Have kids
- Work outside transit coverage
- Frequent cottage trips
- Costco runs

### Car-Free Alternatives
- TTC for daily commute
- Bike Share for short trips
- Uber/Lyft for occasional trips
- Car share (Zipcar, Communauto) for weekend needs
- Enterprise for trips

## Getting a License

### Using Foreign License
- Valid for 60 days as Ontario resident
- After: Must get Ontario license

### Exchange vs Test
Depends on country. Check DriveTest.ca.

**Direct Exchange (No Test)**
- USA, UK, Australia, many EU countries
- Bring: Foreign license, proof of experience, eye test
- Fee: ~CAD 90

**Partial Exchange (Some Tests)**
- Some countries: Written test only
- Others: Written + road test

**Full Process (All Tests)**
- If country not recognized
- Written test (G1)
- G2 road test (basic)
- G road test (highway)

### Ontario's Graduated Licensing

| Level | Requirements | Restrictions |
|-------|--------------|--------------|
| G1 | Pass written test | Supervising driver, no alcohol, no expressway |
| G2 | Pass G2 road test | 0% BAC, passengers limited (under 20) |
| Full G | Pass G road test | Full privileges |

**Timeline**
- G1 to G2: 12 months (8 with course)
- G2 to G: 12 months
- Total: 24 months minimum

## Insurance

### Reality Check
Ontario has some of the highest car insurance in North America.

### Typical Costs
| Profile | Monthly Cost |
|---------|--------------|
| New driver (under 25) | CAD 400-600 |
| New to Ontario (experienced) | CAD 250-400 |
| Established driver (clean record) | CAD 150-250 |
| Young male (under 25) | CAD 500-800 |

### Factors
- Age (younger = more expensive)
- Experience (years licensed)
- Driving record
- Vehicle type
- Location (postal code)
- Usage (km/year)

### Getting Quotes
- Multiple quotes essential (vary widely)
- Brokers: Compare multiple companies
- Direct: CAA, Belairdirect, etc.
- Group rates: Through employer, associations

### Tips to Lower Costs
- Take driving course
- Bundle with home insurance
- Higher deductible
- Telematics (driving tracker)
- Older, cheaper car
- Usage-based (if low km)

## Buying a Car

### New vs Used
- New: Warranty, latest features, higher price
- Used: Value, higher maintenance risk
- Certified pre-owned: Middle ground

### Where to Buy

**Dealerships**
- New and used
- Financing available
- More expensive usually
- Warranty options

**Private Sale**
- Kijiji, Facebook, AutoTrader
- Lower prices
- No warranty
- UVIP required

### UVIP (Used Vehicle Information Package)
Required for private sales:
- History report
- Lien check
- Cost: CAD 20
- Get from ServiceOntario

### Registration
1. Safety Standards Certificate (inspection)
2. Emissions test (if required)
3. Insurance proof
4. UVIP (if private)
5. Register at ServiceOntario

## Winter Driving

### Snow Tires
**Required** by insurance discount and common sense.
- December 1 - April 30 recommended
- Insurance discounts (~5%)
- Not same as all-seasons
- Budget: CAD 600-1,200 for set

### Winter Driving Tips
- Clear ALL snow from car (roof too, it's the law)
- Warm up car briefly
- Increase following distance
- Brake gently
- Know how to handle skids
- Keep emergency kit in car

### Emergency Kit
- Blanket
- Flashlight
- Phone charger
- Shovel
- Ice scraper
- Jumper cables
- Snacks, water

## Parking

### Downtown Parking
| Type | Cost |
|------|------|
| Street meter | CAD 4-6/hour |
| Green P lots | CAD 2-4/hour |
| Private lots | CAD 5-8/hour |
| Monthly (downtown) | CAD 300-500 |

### Residential Parking
- Street permit: CAD 35-350/year (varies by area)
- Visitor permits available
- Winter parking ban enforcement

### Parking Apps
- Green P (city lots)
- Honk Mobile
- PayByPhone

### Avoiding Tickets
- Read ALL signs carefully
- Snow route bans (winter)
- Rush hour restrictions
- School zones

## Traffic & Commuting

### Rush Hour
- Morning: 7-9am
- Evening: 4-7pm
- DVP and Gardiner = parking lots
- 401 is busiest highway in North America

### Expressways
| Route | Direction | Notes |
|-------|-----------|-------|
| DVP | North-South | East side, always congested |
| Gardiner | East-West | Downtown, elevated |
| 401 | East-West | Across city, massive |
| 407 | East-West | Toll road, faster |
| QEW | Southwest | To Niagara, Hamilton |

### 407 ETR (Toll Road)
- Electronic tolling
- No stopping, transponder or bill by plate
- Expensive but fast
- Popular for airport commuters

### Navigation
- Google Maps for real-time traffic
- Waze for crowdsourced updates
- Apple Maps improved

## Rules & Laws

### Key Rules
| Rule | Penalty |
|------|---------|
| Phone use while driving | CAD 615+ fine, 3 points |
| Speeding 50+ over | Stunt driving, license suspension |
| DUI (over 0.08) | Criminal charge, suspension |
| Running red | CAD 325 fine, 3 points |
| School zone speeding | Double fines |
| No seatbelt | CAD 200-1,000 fine |

### Photo Enforcement
- Red light cameras (intersections)
- Speed cameras (school zones)
- Tickets mailed to registered owner
- No demerit points for camera tickets

### Winter Rules
- Must clear snow from vehicle
- Winter tires recommended
- Snow route parking bans
- Bridge/overpass ice warning

## Car Sharing

### Options
| Service | How It Works |
|---------|--------------|
| Zipcar | Hourly/daily, stations |
| Communauto | Hourly, free-floating |
| Enterprise CarShare | Similar to Zipcar |
| Turo | Peer-to-peer rental |

### When It Makes Sense
- Occasional use (few times/month)
- Live downtown
- Don't want car ownership hassle
- Supplement transit

### Costs
- Membership: CAD 0-100/year
- Hourly: CAD 10-15
- Daily: CAD 60-100
- Insurance included

## Electric Vehicles

### Charging
- Growing network
- Condo charging challenging
- Streetside charging limited
- Apps: ChargePoint, FLO

### Incentives
- Federal rebate (up to CAD 5,000)
- Some provincial programs
- HOV lane access

### Popular EVs
- Tesla (Model 3, Y)
- Hyundai Ioniq
- Ford Mustang Mach-E
- Chevrolet Bolt

## Day Trips by Car

### Popular Drives
| Destination | Distance | Time |
|-------------|----------|------|
| Niagara Falls | 130 km | 1.5 hours |
| Muskoka | 200 km | 2.5 hours |
| Prince Edward County | 200 km | 2.5 hours |
| Blue Mountain | 160 km | 2 hours |
| Stratford | 150 km | 1.5 hours |
| Algonquin Park | 300 km | 3.5 hours |

### Long Weekend Traffic
- Friday PM: Northbound jammed
- Sunday PM: Southbound jammed
- Plan accordingly
- Leave early or late
