# Toronto Culture & Customs

## Multiculturalism

Toronto is one of the world's most diverse cities. Over 50% of residents were born outside Canada.

### Demographics
- 200+ ethnic origins
- 140+ languages spoken
- Largest ethnic groups: Chinese, South Asian, Black, Filipino, Latin American
- No single majority

### What This Means
- Diversity is normal, not remarkable
- Ethnic enclaves throughout city
- Authentic cuisine from everywhere
- Cultural events year-round
- Acceptance is baseline expectation

## Canadian Culture Basics

### Communication Style
- **Indirect**: Canadians hint rather than demand
- **Polite**: "Sorry" used constantly (even when not at fault)
- **Understated**: Bragging is frowned upon
- **Inclusive**: Effort to include everyone in conversation

### Common Phrases
| Phrase | Meaning |
|--------|---------|
| "Sorry" | Excuse me, oops, my bad, attention-getter |
| "Eh?" | Right?, isn't it?, tag question |
| "Double-double" | Coffee with 2 cream, 2 sugar |
| "Timmies" | Tim Hortons |
| "The 6ix" | Toronto (Drake reference) |
| "GTA" | Greater Toronto Area |
| "Up north" | Cottage country |

### Social Norms
- Hold doors for people behind you
- Say please and thank you always
- Queue orderly for everything
- Don't cut in line (serious offense)
- Small talk with strangers is normal
- Remove shoes when entering homes

## Toronto vs Canada

Toronto is distinct from rest of Canada:
- Faster pace
- More diverse
- More expensive
- Less outdoorsy (relatively)
- More international
- Sometimes seen as arrogant by other Canadians

### Stereotypes to Know
- Toronto thinks it's the center of universe
- Rest of Canada has mixed feelings about Toronto
- "Centre of the Universe" jokes are common
- Torontonians often forget Canada is huge

## Sports Culture

### The Religion: Hockey
- Maple Leafs are iconic (but haven't won Cup since 1967)
- Hockey Night in Canada is institution
- Kids play hockey
- Playoff hockey is major event
- Learn basics to participate in culture

### Other Major Teams
| Team | Sport | Stadium |
|------|-------|---------|
| Maple Leafs | Hockey | Scotiabank Arena |
| Raptors | Basketball | Scotiabank Arena |
| Blue Jays | Baseball | Rogers Centre |
| Toronto FC | Soccer | BMO Field |
| Argonauts | CFL Football | BMO Field |

### Sports Events
- Leafs games: CAD 100-500 (expensive, passionate fans)
- Raptors: CAD 50-300
- Blue Jays: CAD 30-150
- TFC: CAD 30-100

### 2019 Raptors Championship
- First NBA title
- Massive cultural moment
- "We the North" became identity
- Still celebrated

## Arts & Culture

### Theatre
- Mirvish Productions (major Broadway shows)
- Second City (comedy)
- Soulpepper, Tarragon (Canadian theatre)
- TIFF Bell Lightbox (film)

### Music
- Roy Thomson Hall (classical)
- Massey Hall (historic venue, reopened)
- Budweiser Stage (outdoor concerts)
- Small venues throughout city (Cameron House, Horseshoe)

### Museums
- ROM (natural history, world cultures)
- AGO (art)
- MOCA (contemporary)
- Bata Shoe Museum (yes, shoes)
- Aga Khan Museum (Islamic art)

### Film
- TIFF (Toronto International Film Festival) — September
- Hot Docs (documentary festival)
- Many films shot in Toronto (doubles for NYC often)

## Festivals & Events

### Annual Highlights

| Event | When | What |
|-------|------|------|
| Winterlicious | January | Restaurant prix fixe |
| Pride | June | One of world's largest |
| Summerlicious | July | Restaurant prix fixe |
| Caribana | August | Caribbean carnival |
| CNE | Aug-Sept | Canadian National Exhibition |
| TIFF | September | Film festival |
| Nuit Blanche | October | Overnight art |
| Cavalcade of Lights | November | Holiday kickoff |
| Distillery Christmas Market | Nov-Dec | German-style market |

### Pride Month
- June
- One of largest in world
- Parade is major event
- Entire city participates
- Corporate sponsorship common

### Caribana (Caribbean Carnival)
- August long weekend
- Caribbean culture celebration
- Parade is massive
- Music, food, costumes
- Major event for Black Toronto

## Work Culture

### General Norms
- 9-5 traditional, flex increasing
- 2 weeks vacation (minimum, more common now)
- Sick days common
- Work-life balance valued
- Casual dress (most industries)

### Meeting Culture
- Start on time
- Small talk first
- Consensus-seeking
- Follow-up emails expected
- Hybrid/remote normalized

### Office Culture
- Kitchen etiquette matters
- Clean your dishes
- Respect quiet spaces
- Inclusive language expected
- HR takes complaints seriously

## Dating & Relationships

### Dating Culture
- Apps common (Hinge, Bumble, Tinder)
- Coffee dates normal first date
- Splitting bills common
- Casual dating accepted
- Slower pace than some cultures

### Common Date Activities
- Coffee shops
- Restaurant/drinks
- Trinity Bellwoods (summer)
- Concerts
- Museums
- Seasonal events

## Religion

### Religious Landscape
- Christian (Catholic, Protestant) historically dominant
- Growing Muslim, Hindu, Sikh, Buddhist populations
- Jewish community (historic, significant)
- Secular majority in many areas

### Religious Freedom
- Protected by constitution
- Accommodations common
- Religious holidays increasingly recognized
- Most workplaces flexible

## LGBTQ+ Culture

### Overview
- Very accepting city
- Church-Wellesley Village is gayborhood
- Pride Month is major event
- Legal protections strong
- Corporate inclusion common

### Neighborhoods
- Church-Wellesley (traditional gayborhood)
- Queer presence throughout city
- Not confined to one area

## Etiquette Tips

### Do
- Hold doors
- Say please/thank you
- Remove shoes in homes
- Bring wine/flowers to dinner parties
- Be on time
- Respect personal space
- Use "please" when ordering food

### Don't
- Cut in line
- Be loudly American about being American
- Assume everyone loves hockey
- Complain about cold (everyone experiences it)
- Compare everything to another country negatively
- Ignore Indigenous history
- Assume Toronto = all of Canada
