# Toronto Cost of Living

## Overview

Toronto is expensive but includes public services (healthcare, education) that other expensive cities don't.

### Quick Numbers (Single Person, 2026)

| Category | Monthly Cost |
|----------|--------------|
| Rent (1BR downtown) | CAD 2,500-3,000 |
| Rent (1BR midtown) | CAD 2,000-2,500 |
| Rent (1BR suburbs) | CAD 1,600-2,000 |
| Utilities | CAD 80-150 |
| Internet | CAD 60-100 |
| Phone | CAD 40-80 |
| Transit | CAD 156 (pass) |
| Groceries | CAD 400-600 |
| Dining out | CAD 200-500 |
| Entertainment | CAD 100-300 |
| **Total (downtown)** | **CAD 3,800-5,000** |

## Housing

### Rent Ranges (2026)

| Area | Studio | 1BR | 2BR |
|------|--------|-----|-----|
| Downtown Core | CAD 2,000-2,500 | CAD 2,500-3,200 | CAD 3,500-4,500 |
| King West | CAD 1,900-2,300 | CAD 2,400-3,000 | CAD 3,200-4,000 |
| Midtown | CAD 1,700-2,100 | CAD 2,100-2,700 | CAD 2,800-3,500 |
| East End | CAD 1,600-2,000 | CAD 2,000-2,600 | CAD 2,600-3,200 |
| North York | CAD 1,400-1,800 | CAD 1,700-2,300 | CAD 2,200-2,800 |
| Scarborough | CAD 1,200-1,500 | CAD 1,400-1,900 | CAD 1,800-2,400 |

### Upfront Costs
| Item | Amount |
|------|--------|
| First month rent | Full amount |
| Last month rent | Full amount (deposit) |
| Key deposit | Refundable, minimal |
| Tenant insurance | CAD 20-40/month |
| Moving costs | CAD 200-800 |

### Utilities
| Utility | Monthly |
|---------|---------|
| Electricity | CAD 50-100 |
| Gas (heating) | CAD 30-80 |
| Water | Usually included |
| Internet | CAD 60-100 |

## Food

### Groceries

| Item | Price |
|------|-------|
| Milk (4L) | CAD 6-7 |
| Bread | CAD 3-5 |
| Dozen eggs | CAD 4-6 |
| Chicken breast (kg) | CAD 15-20 |
| Rice (2kg) | CAD 6-10 |
| Apples (kg) | CAD 4-6 |
| Beer (6-pack) | CAD 14-18 |
| Wine (bottle) | CAD 12-20 |

**Monthly grocery budget:**
- Budget: CAD 300-400
- Moderate: CAD 400-600
- Comfortable: CAD 600-800

### Dining Out

| Type | Cost Per Person |
|------|-----------------|
| Fast food | CAD 12-18 |
| Casual lunch | CAD 15-25 |
| Casual dinner | CAD 25-40 |
| Mid-range dinner | CAD 50-80 |
| Fine dining | CAD 100-200+ |
| Coffee | CAD 4-6 |
| Beer (bar) | CAD 8-12 |
| Cocktail | CAD 14-18 |

**Remember**: Add 13% tax + 15-20% tip to all prices.

## Transportation

### Monthly Costs

| Option | Monthly Cost |
|--------|--------------|
| TTC pass | CAD 156 |
| Presto pay-per-ride | CAD 100-150 (depends on usage) |
| Car ownership | CAD 600-1,000+ |
| Bike Share | CAD 10 (annual / 12) |

### Car Ownership Breakdown

| Item | Monthly |
|------|---------|
| Car payment | CAD 300-600 |
| Insurance | CAD 200-400 |
| Gas | CAD 100-200 |
| Parking | CAD 150-300 |
| Maintenance | CAD 50-100 |
| **Total** | **CAD 800-1,600** |

## Health & Fitness

### Healthcare
- **OHIP**: Free (after 3-month wait)
- **Gap insurance**: CAD 100-200/month
- **Dental cleaning**: CAD 150-250
- **Eye exam**: CAD 80-150
- **Prescription drugs**: Varies (some employer coverage)

### Fitness
| Option | Monthly |
|--------|---------|
| Gym (basic) | CAD 30-50 |
| Gym (premium) | CAD 80-150 |
| Yoga studio | CAD 100-180 |
| Drop-in class | CAD 20-35 |
| Sports league | CAD 80-150/season |

## Entertainment

### Activities
| Activity | Cost |
|----------|------|
| Movie | CAD 15-20 |
| Museum | CAD 20-30 |
| Concert | CAD 50-200 |
| Sports game (cheap) | CAD 30-80 |
| Sports game (good) | CAD 100-300 |
| Theatre | CAD 60-200 |

### Monthly Entertainment Budget
- Budget: CAD 100-150
- Moderate: CAD 200-350
- Active social: CAD 400-600

## Childcare & Education

### Childcare
| Type | Monthly |
|------|---------|
| Daycare (full-time) | CAD 1,500-2,500 |
| Nanny | CAD 2,500-4,000 |
| After-school | CAD 400-800 |

**Note**: CAD 10/day childcare expanding (waitlists exist).

### Education
| Type | Annual |
|------|--------|
| Public school | Free |
| Private school | CAD 15,000-35,000 |
| University (domestic) | CAD 7,000-15,000 |
| University (international) | CAD 40,000-60,000 |

## Taxes

### Income Tax
Combined federal + provincial:
| Income | Marginal Rate |
|--------|--------------|
| Up to CAD 50,000 | ~20-25% |
| CAD 50,000-100,000 | ~30-35% |
| CAD 100,000-150,000 | ~38-43% |
| CAD 150,000+ | ~45-50% |

### Sales Tax
- **HST**: 13% on most purchases
- Not included in displayed prices
- Some essentials exempt (basic groceries)

## Sample Budgets

### Budget Single (Suburbs)
| Category | Monthly |
|----------|---------|
| Rent (1BR Scarborough) | CAD 1,600 |
| Utilities | CAD 80 |
| Phone/Internet | CAD 100 |
| Transit | CAD 156 |
| Groceries | CAD 350 |
| Dining/Entertainment | CAD 200 |
| Misc | CAD 200 |
| **Total** | **CAD 2,686** |

### Comfortable Single (Downtown)
| Category | Monthly |
|----------|---------|
| Rent (1BR Downtown) | CAD 2,700 |
| Utilities | CAD 100 |
| Phone/Internet | CAD 120 |
| Transit | CAD 156 |
| Groceries | CAD 500 |
| Dining/Entertainment | CAD 500 |
| Gym | CAD 80 |
| Misc | CAD 300 |
| **Total** | **CAD 4,456** |

### Family of 4 (Suburbs)
| Category | Monthly |
|----------|---------|
| Rent (3BR North York) | CAD 3,200 |
| Utilities | CAD 200 |
| Phone/Internet | CAD 180 |
| Car | CAD 800 |
| Groceries | CAD 1,200 |
| Childcare (1 child) | CAD 1,800 |
| Dining/Entertainment | CAD 400 |
| Activities (kids) | CAD 300 |
| Misc | CAD 400 |
| **Total** | **CAD 8,480** |

## Money-Saving Tips

1. **Live near work** — Transit time has value
2. **Grocery shop** — Dining out adds up fast
3. **Get a Costco membership** — Bulk savings
4. **Use library** — Free everything (books, movies, events)
5. **Generic brands** — Same quality, lower price
6. **Negotiate rent** — Especially for renewals
7. **Employer benefits** — Max out matching, discounts
8. **Off-peak transit** — Slightly cheaper
9. **Cook in batches** — Meal prep saves money and time
10. **Free activities** — Toronto has many (parks, events, festivals)
