# Toronto Weather & Climate Survival

## Overview

Toronto has four distinct seasons. Winters are cold, summers are humid. Spring and fall are the most pleasant.

### Annual Summary
| Season | Months | Temperature | Vibe |
|--------|--------|-------------|------|
| Winter | Dec-Mar | -5 to -15C | Cold, snowy, indoor life |
| Spring | Apr-May | 5-15C | Unpredictable, rainy |
| Summer | Jun-Aug | 20-30C | Humid, patios, festivals |
| Fall | Sep-Nov | 5-20C | Beautiful, best weather |

## Winter (December - March)

### What to Expect
- Average: -5 to -10C
- Cold snaps: -15 to -25C
- Wind chill makes it feel colder
- Snow: Several significant snowfalls
- Daylight: Short (8-9 hours)

### Survival Essentials

**Clothing (Non-Negotiable)**
| Item | Why |
|------|-----|
| Insulated boots | Waterproof, warm, with grip |
| Down/synthetic puffer | Real warmth, not fashion jacket |
| Thermal base layers | Moisture-wicking underlayer |
| Warm hat | Most heat lost through head |
| Insulated gloves | Touchscreen-compatible ideal |
| Scarf/neck gaiter | Protect face in wind |

**Brands That Work**
- Canada Goose (expensive but effective)
- North Face, Patagonia, Arc'teryx
- Budget: Uniqlo Heattech, Amazon basics

**Cost**: Budget CAD 500-1,000 for proper winter gear.

### Indoor Life
- PATH underground (30+ km downtown)
- Malls, museums, indoor activities
- Skating rinks (Nathan Phillips Square)
- Home becomes sanctuary

### Winter Activities
- Skating (free rinks throughout city)
- Cross-country skiing (ravines, parks)
- Blue Mountain (2 hours for downhill)
- Christmas markets
- Distillery District winter fest

### Mental Health
First winter is hard for newcomers:
- Vitamin D supplements help
- Light therapy lamps
- Stay social (don't hibernate)
- Plan indoor activities
- Remember: locals survive

### Winter Driving
- Snow tires required (Dec 1 - Apr 30)
- Clear ALL snow from car
- Leave extra time
- Consider transit instead

## Spring (April - May)

### What to Expect
- Temperatures: 5-15C
- Very unpredictable
- Rain common
- Snow possible until mid-April
- Allergies begin (pollen)

### What to Wear
- Layers (remove/add throughout day)
- Rain jacket
- Waterproof shoes
- Umbrella always

### Highlights
- Cherry blossoms at High Park (late April)
- First patios opening
- Energy returns to city
- Prices lower before summer

### Tips
- Don't put winter gear away too early
- Carry layers everywhere
- Check weather daily
- Best time for apartment hunting

## Summer (June - August)

### What to Expect
- Temperatures: 20-30C
- Humidity makes it feel hotter (humidex 35C+)
- Occasional heat waves
- Evening thunderstorms
- Long daylight (15+ hours)

### Survival Essentials
| Item | Why |
|------|-----|
| AC or fans | Sleep quality depends on it |
| Light clothing | Breathable fabrics |
| Sunscreen | UV strong |
| Sunglasses | Protection |
| Water bottle | Hydration essential |

### Summer Activities
- Toronto Islands
- Beaches (Woodbine, Cherry, Bluffs)
- Patios everywhere
- Outdoor concerts
- Festivals (Pride, Caribana, TIFF lead-up)
- Day trips (cottage country, Niagara)

### Events
| Event | When |
|-------|------|
| Pride | June |
| Canada Day | July 1 |
| Caribana | August |
| CNE | Late Aug-Sept |
| TIFF | September |

### Tips
- Book AC early if renting
- Hydrate constantly
- Sunscreen daily
- Embrace late evenings
- Take advantage of outdoor everything

## Fall (September - November)

### What to Expect
- Temperatures: 5-20C
- Best weather of the year
- Stunning fall colors
- Crisp, clear days
- Gradual cooling

### Highlights
- TIFF (September)
- Fall colors (Don Valley, High Park)
- Apple picking season
- Thanksgiving (October, not November)
- Perfect walking weather

### What to Wear
- Layers
- Light jacket
- Comfortable walking shoes
- Scarf (late fall)

### Tips
- Best time to explore outdoors
- Book restaurants for TIFF early
- Enjoy before winter
- Start winter shopping late fall

## Monthly Breakdown

| Month | Avg High | Avg Low | Notes |
|-------|----------|---------|-------|
| Jan | -1C | -7C | Coldest month, snow |
| Feb | 0C | -7C | Still cold, some thaw |
| Mar | 5C | -2C | Spring teasing, still cold |
| Apr | 12C | 3C | Warming, rainy |
| May | 18C | 9C | Pleasant, variable |
| Jun | 24C | 14C | Summer begins |
| Jul | 27C | 18C | Hot, humid |
| Aug | 26C | 17C | Hot, humid |
| Sep | 21C | 13C | Best month |
| Oct | 14C | 7C | Fall colors |
| Nov | 7C | 1C | Cold arriving |
| Dec | 1C | -5C | Winter begins |

## Weather Resources

### Apps
- Weather Network (Canadian)
- Environment Canada
- Apple/Google Weather

### Terms to Know
- **Humidex**: What it feels like with humidity
- **Wind chill**: What it feels like with wind
- **Freezing rain**: Ice rain, dangerous
- **Lake effect**: Extra snow from lake moisture

## First Year Tips

1. **Buy winter gear in October** — Selection better, prices sometimes lower
2. **Don't fight winter** — Embrace it or suffer
3. **Plan indoor hobbies** — You'll need them
4. **Vitamin D** — Take supplements
5. **Get good boots** — Most important purchase
6. **Summer = outside** — Make the most of it
7. **Fall = explore** — Best hiking, walking weather
8. **Spring = patience** — It's unpredictable
