# Starting a Business in Toronto

## Overview

Ontario is business-friendly with straightforward incorporation. Toronto offers access to talent, capital, and North American markets.

## Business Structures

### Sole Proprietorship
- Simplest structure
- You = business
- Personal liability
- Register business name (optional)
- Best for: Freelancers, small operations

### Partnership
- Two or more partners
- Shared liability
- Partnership agreement recommended
- Register at provincial level

### Corporation (Inc.)
- Separate legal entity
- Limited liability
- More complex setup
- Tax advantages possible
- Best for: Scaling businesses

### Federal vs Provincial

| Type | Jurisdiction | Name Protection |
|------|--------------|-----------------|
| Federal | All of Canada | Nationwide |
| Ontario | Ontario only | Ontario only |

Federal costs more but protects name nationally.

## Incorporation Steps

### Ontario Corporation
1. **NUANS name search** — Check name availability (CAD 20-50)
2. **Articles of Incorporation** — File online or paper
3. **Register for business number** — CRA
4. **Register for HST** — If revenue will exceed CAD 30,000

**Cost**: CAD 300-400 (DIY), CAD 1,000-2,000 (lawyer)
**Time**: 1-2 days (online)

### Federal Corporation
1. **NUANS name search**
2. **File with Corporations Canada**
3. **Extra-provincial registration** — In each province you operate
4. **CRA registrations**

**Cost**: CAD 200 federal + provincial registrations
**Time**: 1-2 days

### DIY vs Lawyer
- **DIY**: Ownr, Stripe Atlas, online filing — fine for simple cases
- **Lawyer**: Recommended for multiple founders, complex structures, US investors

## Taxes

### Corporate Tax
| Level | Rate |
|-------|------|
| Federal | 15% |
| Ontario | 11.5% |
| **Combined** | **26.5%** |

**Small Business Deduction**: 9% federal + 3.2% Ontario on first CAD 500,000 (12.2% total).

### HST (Sales Tax)
- 13% in Ontario
- Must register if revenue > CAD 30,000/year
- Collect on sales, remit to CRA
- Can claim input tax credits

### Payroll Taxes
As employer, you pay:
- CPP contributions (Canada Pension)
- EI premiums (Employment Insurance)
- WSIB (Workplace Safety Insurance)

## Hiring

### Employee vs Contractor
| Factor | Employee | Contractor |
|--------|----------|------------|
| Control | You direct work | They control how |
| Tools | You provide | They provide |
| Risk | You bear | They bear |
| Benefits | You must provide some | Not required |

**Misclassification**: CRA audits this. Default to employee if unsure.

### Minimum Requirements
- Minimum wage: CAD 16.55/hour (2024)
- Vacation: 4% of wages (2 weeks)
- Statutory holidays: 9 public holidays
- Termination notice: Based on tenure

### Payroll Services
- Wagepoint (Canadian)
- ADP
- Ceridian
- Gusto (US, works in Canada)

## Funding Options

### Self-Funded / Bootstrapping
- No dilution
- Full control
- Limited resources

### Friends & Family
- Informal rounds
- Simple agreements (SAFEs)
- Relationship risk

### Angel Investors
- CAD 25,000-500,000 typical
- Active in Toronto
- Networks: AngelList, Angel One

### Venture Capital
| Stage | Amount | Examples |
|-------|--------|----------|
| Pre-seed | CAD 100,000-500,000 | Angels, micro-VCs |
| Seed | CAD 500,000-3M | Panache, Garage |
| Series A | CAD 5-15M | Georgian, Inovia |
| Series B+ | CAD 15M+ | BDC, large VCs |

### Government Programs

**SR&ED (Tax Credit)**
- R&D tax credit
- Up to 35% of eligible expenses
- Major benefit for tech companies
- Complex application

**IRAP (NRC)**
- Non-repayable contributions
- R&D and innovation projects
- Up to CAD 1M+

**Futurpreneur**
- Loans for young entrepreneurs (18-39)
- Up to CAD 60,000
- Mentorship included

**BDC (Business Development Bank)**
- Government-backed loans
- Startup-friendly terms
- Various programs

## Business Resources

### Accelerators & Incubators
| Program | Focus |
|---------|-------|
| MaRS | General, corporate innovation |
| DMZ | Tech, early stage |
| Creative Destruction Lab | Deep tech, AI |
| Techstars Toronto | General, batch program |
| FounderFuel | Montreal, but accessible |

### Coworking
- WeWork (multiple locations)
- Spaces
- Workplace One
- Project Spaces
- MaRS (for members)

### Legal
Get a startup lawyer early for:
- Incorporation
- Founder agreements
- Employee stock options
- Financing documents

Firms: Osler, Blake, Cassels & Graydon, Dentons (all have startup programs)

### Accounting
Find a tech-savvy accountant for:
- SR&ED claims
- Corporate taxes
- Payroll setup
- US expansion

## Banking for Business

### Big 5 Business Banking
All offer business accounts:
- TD
- RBC
- BMO
- Scotiabank
- CIBC

### Startup-Friendly
- Scotiabank (startup program)
- BMO (tech banking team)
- RBC (innovation banking)

### US Banking
For US expansion/customers:
- Mercury (popular with startups)
- SVB (if you qualify)
- Wise (for payments)

## Common Mistakes

1. **Mixing personal and business finances** — Keep separate from day 1
2. **Ignoring HST registration** — Register early, claim credits
3. **Misclassifying contractors** — CRA audits this
4. **No founder agreement** — Get in writing before problems
5. **Over-incorporating** — Don't incorporate too early if not needed
6. **Ignoring SR&ED** — Significant money left on table
7. **Wrong corporate structure** — Get advice for US investors

## Useful Links

- Ontario Business Registry: ontario.ca/businessregistry
- Corporations Canada: ic.gc.ca/corporations
- CRA Business Registration: canada.ca/cra-business
- MaRS: marsdd.com
- Startup Toronto: startuptoronto.com
