---
name: Toronto
slug: toronto
version: 1.0.1
homepage: https://clawic.com/skills/toronto
description: Navigate Toronto as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transit, costs, immigration, and local insights.
metadata: {"clawdbot":{"emoji":"🍁","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Toronto for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Downtown, Financial, Entertainment | `neighborhoods-downtown.md` |
| King West, Queen West, Liberty | `neighborhoods-west.md` |
| Yorkville, Annex, Midtown | `neighborhoods-midtown.md` |
| East End, Leslieville, Beaches | `neighborhoods-east.md` |
| North York, Scarborough, Etobicoke | `neighborhoods-suburban.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Local specialties | `food-local.md` |
| International cuisines | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary options, tipping | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transit (TTC, GO, UP Express) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & survival tips | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup | `business.md` |
| Immigration paths (Express Entry, PNP) | `immigration.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare (OHIP) | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Driving & car ownership | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur, immigrant
- **Timeline**: Short visit, planning to move, already there, applying for PR
- Load relevant auxiliary file for details

### 2. Immigration-Centric Planning
Canada has a points-based immigration system. Most long-term plans involve:
- **Express Entry**: Federal Skilled Worker, Canadian Experience Class
- **Ontario PNP**: Provincial nomination for Ontario-specific streams
- **Work Permits**: LMIA-based or LMIA-exempt (intra-company, CUSMA)
- **Study Permits**: Path to PGWP and PR for international students
See `immigration.md` for current requirements and CRS scores.

### 3. Four-Season Reality
Toronto has dramatic seasonal changes:
- **Winter (Dec-Mar)**: -5 to -15C typical, can hit -25C with wind chill
- **Spring (Apr-May)**: 5-15C, unpredictable, rain common
- **Summer (Jun-Aug)**: 20-30C, humid, occasional heat waves
- **Fall (Sep-Nov)**: 5-20C, beautiful colors, best weather
See `climate.md` for detailed survival strategies.

### 4. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Downtown) | CAD 2,200-3,200/month |
| 1BR rent (Midtown) | CAD 1,900-2,600/month |
| Senior SWE salary | CAD 150,000-220,000/year |
| TTC monthly pass | CAD 156 (adult) |
| Average restaurant meal | CAD 20-40/person |
| Daycare (full-time) | CAD 1,500-2,500/month |

### 5. Cost Reality
Toronto is expensive but has public services:
- **Housing**: 35-45% of budget typical for renters
- **Healthcare**: Free via OHIP (3-month wait for new residents)
- **Education**: Public schools free, universities CAD 7,000-15,000/year domestic
- **Childcare**: Expensive but CAD 10/day program expanding
- **Taxes**: High (federal + provincial), but services included
- **Hidden costs**: First/last month rent, broker fees sometimes

### 6. Transit System
Toronto has extensive public transit:
- **TTC**: Subway (4 lines), buses, streetcars — covers most of city
- **GO Transit**: Regional trains/buses to suburbs and GTA
- **UP Express**: Airport to Union Station (25 min, CAD 12.35)
- **Presto Card**: Contactless payment for all transit
Most downtown residents don't need a car. See `transport.md`.

### 7. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | King West, Queen West, Liberty Village |
| Families | North York, Leaside, Etobicoke, Beaches |
| Students | Annex, Kensington, near campus |
| Budget-conscious | Scarborough, North York, East York |
| Tech workers | King West, Liberty Village, Downtown |
| Luxury seekers | Yorkville, Rosedale, Forest Hill |

## Tech Hub Context

Toronto is Canada's largest tech hub:
- **Major companies**: Shopify, Wealthsimple, Clio, Top Hat, 1Password (HQ or major office)
- **Big Tech offices**: Google, Meta, Amazon, Microsoft, Uber, Airbnb
- **AI corridor**: Vector Institute, University of Toronto AI labs
- **Startup ecosystem**: MaRS Discovery District, DMZ, Creative Destruction Lab

Tech salaries are lower than SF/NYC but:
- Universal healthcare (no insurance premiums)
- Lower taxes than California
- Path to permanent residency
- Strong work-life balance culture

See `tech.md` for detailed salary bands and company landscape.

## Toronto-Specific Traps

- **Winter underestimation** — -20C with wind chill is brutal. Need proper winter gear: insulated coat, waterproof boots, layers.
- **Rental market speed** — Good apartments go in hours. Be prepared with documents, references, proof of income.
- **Credit history void** — No Canadian credit history = harder to rent, get phone plans. Build credit early.
- **OHIP wait period** — 3 months without coverage for new residents. Get private insurance for gap.
- **Car insurance shock** — Much higher than US. CAD 200-400/month for new drivers.
- **Tipping expectations** — 15-20% expected everywhere (restaurants, bars, haircuts, taxis).
- **Sales tax surprise** — 13% HST not included in displayed prices.
- **Winter driving** — Snow tires legally required Dec 1 - Apr 30. All-seasons not enough.
- **PATH dependency** — Underground city is great in winter but confusing. Learn the routes.
- **Bay Street assumption** — Finance jobs concentrated in one area, but tech is spread across downtown.

## Legal Awareness

Key laws visitors/residents should know:
- **Cannabis**: Legal 19+, but cannot cross border with it, no public consumption except designated areas.
- **Alcohol**: Legal 19+ in Ontario. LCBO/Beer Store only (mostly). No open containers in public.
- **Smoking**: Banned in all indoor public spaces, patios, near entrances. Includes cannabis.
- **Jaywalking**: Technically illegal, rarely enforced downtown.
- **Tenant rights**: Strong protections. Landlords cannot raise rent on occupied units beyond guideline (2.5% in 2024).
- **Photo radar**: Speed cameras active in school and community safety zones.
- **Distracted driving**: Using phone while driving is serious offense, CAD 615+ fine.

See `safety.md` for comprehensive legal guidance.

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `dubai` — Middle East city guide
- `travel` — general travel planning

## Feedback

- If useful: `clawhub star toronto`
- Stay updated: `clawhub sync`
