# Torah Scholar — Marketing Materials

## One-Liner
> AI-powered Jewish text research: Search Tanach, Talmud & commentaries instantly.

## Tagline
> "The entire Jewish library at your AI agent's fingertips"

---

## Product Hunt Submission

**Name:** Torah Scholar

**Tagline:** Search Jewish texts with AI — Torah, Talmud, Midrash & commentaries

**Description:**
Torah Scholar gives AI agents instant access to Sefaria's massive library of Jewish texts:

📜 **What you can do:**
- Search across Tanach, Talmud, Mishnah, Midrash, and Kabbalah
- Get verses in Hebrew + English with one command
- Find commentaries from Rashi, Ramban, Ibn Ezra, and hundreds more
- Generate dvar Torah outlines with sources
- Check this week's parsha and daily learning schedules

🔧 **Built for:**
- Torah scholars and students
- Rabbis preparing divrei Torah
- Jewish educators
- Developers building Torah apps
- Anyone researching Jewish texts

⚡ **Just works:**
```
torah search "love your neighbor"
torah verse "Genesis 1:1"
torah links "Exodus 20:1"
torah dvar
```

Free, open-source, powered by Sefaria. No API key needed.

**Topics:** Artificial Intelligence, Developer Tools, Education, Productivity

**Makers:** @abeperl

---

## Indie Hackers Post

**Title:** 🚀 I built an AI skill for Torah research — here's how

**Body:**

Hey IH! 👋

Just shipped **Torah Scholar** — an OpenClaw/MCP skill that lets AI agents search and explore Jewish texts.

### The Problem
Sefaria has an amazing API with thousands of Jewish texts, but integrating it into AI workflows required custom code every time.

### The Solution
A simple CLI that any AI agent can use:

```bash
torah search "teshuvah repentance"
torah verse "Psalms 23"
torah links "Deuteronomy 6:4"
torah dvar  # Generate dvar Torah with sources
```

### Tech Stack
- Python + Bash
- Sefaria API (free, no auth)
- OpenClaw skill format

### Market
- 2-3M active Torah learners worldwide
- 300K+ Daf Yomi participants
- Growing Jewish ed-tech market (~$500M/year)

### Business Model (planned)
- Free: Basic search + verses
- Pro ($19): Unlimited + dvar generator
- Scholar ($49): Bulk ops + citation export

### What's Next
- Premium features
- Mobile app wrapper
- Yeshiva/school licenses

Would love feedback! What features would you want?

🔗 [ClawHub](https://clawhub.com) | [GitHub](#)

---

## Hacker News (Show HN)

**Title:** Show HN: Torah Scholar – AI agent skill for searching Jewish texts (Sefaria API)

**Text:**

I built an OpenClaw/MCP skill that gives AI agents access to Sefaria's library of Jewish texts — Torah, Talmud, Midrash, commentaries, and more.

Commands:
- `torah search <query>` — Full-text search
- `torah verse <ref>` — Get Hebrew + English (e.g., "Genesis 1:1", "Berakhot 2a")
- `torah links <ref>` — Find Rashi, Ramban, and other commentaries
- `torah dvar` — Generate dvar Torah outlines with sources

The Sefaria API is free and doesn't require auth, so this just works.

Use cases: Torah study, sermon prep, research, building Jewish apps.

Repo: [link]
ClawHub: torah-scholar

---

## Reddit Posts

### r/Judaism

**Title:** I built an AI tool for Torah research — free and open source

**Body:**

Hey r/Judaism!

I created **Torah Scholar**, a tool that lets AI assistants search and explore Jewish texts using Sefaria's API.

**What it does:**
- Search across Tanach, Talmud, Mishnah, Midrash
- Get verses in Hebrew and English
- Find commentaries (Rashi, Ramban, etc.)
- Generate dvar Torah outlines with sources

**Example:**
```
torah search "ahavat chinam"
torah verse "Leviticus 19:18"
torah links "Esther 4:14"
```

It's free, open-source, and powered by Sefaria.

Would love feedback from the community — what features would be most useful for your learning?

---

### r/Jewish

**Title:** Made a free AI tool for learning Torah — search texts, find commentaries, prep divrei Torah

*(Similar to above, slightly shorter)*

---

## Twitter/X Thread

**Tweet 1:**
🚀 Just shipped: Torah Scholar

An AI skill that searches Jewish texts instantly:
- Tanach, Talmud, Midrash
- Rashi, Ramban, Ibn Ezra
- Hebrew + English

```
torah search "golden rule"
torah verse "Genesis 1:1"
```

Free & open source. Powered by @SefariaProject 📜

**Tweet 2:**
The coolest part? You can generate dvar Torah outlines with sources:

```
torah dvar ref "Esther 4:14"
```

It pulls:
✓ Opening verses
✓ Key commentaries
✓ Related sources
✓ Suggested structure

Perfect for Shabbat prep 🕯️

**Tweet 3:**
Built this for:
- Torah learners
- Rabbis & educators
- Developers building Jewish apps
- Anyone researching texts

Available on ClawHub: torah-scholar

What features would you want? 👇

---

## LinkedIn Post

**Excited to share a new project: Torah Scholar** 📜

I built an AI agent skill that gives instant access to the world's largest open-source library of Jewish texts (via Sefaria):

→ Search Tanach, Talmud, Mishnah, Midrash
→ Get verses in Hebrew + English
→ Find commentaries from Rashi, Ramban, and hundreds more
→ Generate dvar Torah outlines with sources

**Why this matters:**
The Jewish ed-tech market is growing, but tooling for AI integration has been lacking. This bridges that gap.

**Tech:** Python, Sefaria API, OpenClaw/MCP format

Free, open-source, and ready to use.

If you're working in Jewish education, Torah publishing, or religious tech — let's connect!

#Torah #AI #EdTech #Jewish #OpenSource

---

## Dev.to Article Outline

**Title:** Building a Torah Research Tool with Sefaria API and Python

**Sections:**
1. Introduction — Why Jewish text search matters
2. The Sefaria API — Overview of endpoints
3. Building the CLI — Python wrapper walkthrough
4. Adding AI agent integration — OpenClaw/MCP format
5. The Dvar Torah generator — Combining sources
6. What's next — Premium features, monetization
7. Conclusion — Open source and community

---

## Killer-Skills Submission

**Name:** Torah Scholar

**Category:** Education / Research / Productivity

**Description:**
Search and explore Jewish texts with AI agents. Access Tanach, Talmud, Midrash, and thousands of commentaries via Sefaria's API. Generate dvar Torah outlines with sources.

**Features:**
- Full-text search across all Jewish texts
- Verse lookup with Hebrew + English
- Commentary finder (Rashi, Ramban, etc.)
- Daily learning schedules
- Dvar Torah generator

**Use Cases:**
- Torah study and research
- Sermon/dvar Torah preparation
- Jewish education
- Building Torah apps

**Pricing:** Free (premium features planned)

---

## Sefaria "Powered by" Submission

*(See separate file)*
