---
name: topic-to-article-kit
description: "Turn a chosen AI topic into a public-account writing package: collect evidence from X/Twitter and other sources, extract high-value comments, and produce title options + structured outline written into Obsidian. Use when user asks for topic-based research and article prep."
---

# Topic to Article Kit

1. Input: user-selected topic (or propose topic candidates).
2. Collect evidence from:
   - X/Twitter official pages first (`x.com` profile/search/status), then other public sources as supplement
   - HN / TechCrunch / GitHub / other public sources
3. Collect X high-value comments (facts, counterpoints, implementation details).
4. Build deliverables in Obsidian (minimal structure):
   - one folder per article: `OpenClaw/项目/公众号写作/<日期_标题>/`
   - `资料包.md`（facts, data, links, comment excerpts）
   - `大纲.md`（with inline citation markers to 资料包）
5. Always write to the real Obsidian Vault visible directory first (absolute path under user's real vault), never workspace mirror paths.
6. Before finishing, verify files exist in the real Obsidian visible directory and report that relative path to user.
7. Keep output minimal and readable (no extra draft/final folders unless user asks).
8. Control browser tabs like production workflow:
   - max 7 tabs at once
   - close finished tabs before opening new ones
   - close all temporary tabs at end (target 0)

## Required output

- 文章目录（按“日期_标题”命名）
- `资料包.md`（含来源链接和评论摘录）
- `大纲.md`（含可引用资料标注）
- 5-10标题候选（写在大纲顶部）
- X/Twitter 证据优先来自 `x.com` 官方页面（并在资料包注明链接）
