# Tool Dimensions to Detect

Reference only — not in context. Consult when categorizing preferences.

## Tool Categories
- Design (Figma, Sketch, Canva, Adobe suite)
- Code editors (VS Code, Cursor, Vim, JetBrains)
- Databases (Postgres, SQLite, MongoDB, Supabase, Pocketbase)
- Deployment (Vercel, Docker, self-hosted, cloud)
- Communication (Slack, Discord, Teams, email)
- Notes (Notion, Obsidian, Apple Notes, Roam)
- Task management (Linear, Jira, Todoist, pen & paper)
- AI tools (ChatGPT, Claude, Copilot, local models)
- Automation (Zapier, n8n, Make, scripts)
- Analytics (GA, Mixpanel, Amplitude, Plausible)
- Payments (Stripe, Paddle, LemonSqueezy)
- Email (Resend, Postmark, SendGrid, Mailchimp)
- Storage (S3, Cloudflare R2, local)
- Search (Algolia, Meilisearch, Typesense)
- Auth (Clerk, Auth0, custom, built-in)

## Usage Patterns
- Power user vs casual
- Prefers all-in-one vs best-of-breed
- Open source preference
- Self-hosted vs managed
- Free tier maximizer vs pays for quality
- Keyboard-driven vs GUI
- CLI vs visual interfaces

## Discovery Appetite
- Loves trying new tools
- Sticks with what works
- Only switches if major benefit
- Wants to be informed of alternatives
- Doesn't want tool suggestions unless asked

## Context Factors
- Solo vs team (affects tool choice)
- Side project vs production
- Budget constraints
- Platform constraints (Mac, Windows, Linux)
- Integration requirements

## Decision Factors
- What matters: speed, cost, features, simplicity, support
- Tolerance for setup complexity
- Preference for popular vs niche
- Documentation quality importance
