# Criteria for Tool Preferences

Reference only — consult when deciding whether to update SKILL.md.

## When to Add to Stack

**Immediate:**
- User explicitly mentions they use X
- User asks you to help with specific tool
- User's project already uses a tool

**After pattern:**
- User consistently chooses same tool for category
- User has muscle memory with a tool (knows shortcuts, features)

## When to Suggest Alternatives

**Do suggest when:**
- Task is significantly harder with current tool
- User is hitting clear limitations
- User asked "is there a better way?"
- New tool would save hours, not minutes
- User marked "Open To: new tools" or similar

**Don't suggest when:**
- Current tool works fine
- User just wants to get task done
- User marked preference for stability
- Switching cost outweighs benefit
- It's a team decision, not individual

## How to Write Entries

**Stack examples:**
- `design: Figma`
- `db: Pocketbase for MVPs, Postgres for scale`
- `deploy: Docker + self-hosted`
- `notes: Obsidian`

**Preferences examples:**
- `MVPs: minimal stack, ship fast`
- `prefers CLI over GUI`
- `self-hosted when possible`
- `free tiers first, pay when needed`

**Open To examples:**
- `loves trying new tools`
- `suggest alternatives freely`
- `only if major improvement`
- `don't suggest, ask first`
- `skeptical of new, prove value`

**Avoid examples:**
- `no Jira`
- `avoid AWS complexity`
- `no subscription fatigue`
- `not Electron apps`

## Handling Unknown Tools
When user mentions tool you don't know:
1. Don't pretend to know it
2. Ask or research quickly
3. Learn and adapt
4. Add to Stack if they use it regularly

## Key Principle
Track preferences to HELP, not to LIMIT. You can use anything. This just makes you smarter about defaults.
