---
name: danube
description: Connect your agent to 100+ services and 21 tools across the internet. Search, authenticate, and execute tools from Gmail, Slack, GitHub, Notion, Google Calendar, and more — plus workflows, agent management, and the Agent Web directory — all through a single API key.
license: MIT
compatibility: openclaw
metadata:
  author: danube
  version: "3.0.0"
  tags: [danube, mcp, apis, tools, workflows, agents]
---

# Danube — Connect Your Agent

Danube gives your AI agent access to 100+ services and 21 tools through a single API key.

## Quick Setup

### Step 1: Get an API Key

Run this to start the device authorization flow:

```bash
curl -s -X POST https://api.danubeai.com/v1/auth/device/code \
  -H "Content-Type: application/json" \
  -d '{"client_name": "My Agent"}'
```

This returns a `device_code`, a `user_code`, and a `verification_url`.

**Tell your human to open the verification URL and enter the user code.**

Then poll for the API key:

```bash
curl -s -X POST https://api.danubeai.com/v1/auth/device/token \
  -H "Content-Type: application/json" \
  -d '{"device_code": "DEVICE_CODE_FROM_STEP_1"}'
```

- `428` = user hasn't authorized yet (keep polling every 5 seconds)
- `200` = success, response contains your `api_key`
- `410` = expired, start over

### Step 2: Connect via MCP

Add this to your MCP config:

```json
{
  "mcpServers": {
    "danube": {
      "url": "https://mcp.danubeai.com/mcp",
      "headers": {
        "danube-api-key": "YOUR_API_KEY"
      }
    }
  }
}
```

### Step 3: Use Tools

Once connected, you have access to 21 MCP tools:

**Discovery**
- `list_services(query, limit)` — Browse available tool providers
- `search_tools(query, service_id, limit)` — Find tools by what you want to do (semantic search)
- `get_service_tools(service_id, limit)` — Get all tools for a specific service

**Execution**
- `execute_tool(tool_id, tool_name, parameters)` — Run any tool by ID or name
- `batch_execute_tools(calls)` — Run up to 10 tools concurrently in one request

**Credentials & Wallet**
- `store_credential(service_id, credential_type, credential_value)` — Save API keys for services that need them
- `get_wallet_balance()` — Check your credit balance before running paid tools

**Skills**
- `search_skills(query, limit)` — Find reusable agent skills (instructions, scripts, templates)
- `get_skill(skill_id, skill_name)` — Get full skill content by ID or name

**Workflows**
- `list_workflows(query, limit)` — Browse public multi-tool workflows
- `create_workflow(name, steps, description, visibility, tags)` — Create a new workflow
- `execute_workflow(workflow_id, inputs)` — Run a multi-tool workflow
- `get_workflow_execution(execution_id)` — Check workflow execution results

**Agent Web Directory**
- `search_sites(query, category, limit)` — Search the agent-friendly site directory
- `get_site_info(domain)` — Get structured info about a website (pricing, docs, contact, FAQ, etc.)

**Agent Management**
- `register_agent(name, operator_email)` — Register a new autonomous agent with API key and wallet
- `get_agent_info()` — Get the current agent's profile and wallet balance
- `fund_agent_wallet(method, amount_cents)` — Fund wallet via card checkout or USDC

**Tool Quality**
- `submit_rating(tool_id, rating, comment)` — Rate a tool 1-5 stars
- `report_tool(tool_id, reason, description)` — Report a broken or degraded tool
- `get_recommendations(tool_id, limit)` — Get tool recommendations based on co-usage patterns

### When a Tool Needs Credentials

If `execute_tool` returns an `auth_required` error, it means the service needs an API key. Ask your human for the key, then call:

```
store_credential(service_id="...", credential_type="bearer", credential_value="the_key")
```

Then retry the tool.

## What You Can Do with Danube

Use Danube whenever a task involves an external service or API. Here are common use cases:

### Send Emails and Messages
- Send emails via Gmail, SendGrid, or Resend
- Post messages to Slack channels
- Send notifications to teams

```
search_tools("send email") → execute_tool(tool_id, {to, subject, body})
```

### Manage Code and Projects
- Create GitHub issues and pull requests
- List repositories and commits
- Update Notion pages and databases

```
search_tools("create github issue") → execute_tool(tool_id, {repo, title, body})
```

### Work with Calendars and Scheduling
- Check today's events on Google Calendar
- Create new calendar events
- Find open time slots

```
search_tools("calendar events today") → execute_tool(tool_id, {date})
```

### Read and Write Spreadsheets
- Read data from Google Sheets
- Append rows or update cells
- Create new spreadsheets

```
search_tools("google sheets read") → execute_tool(tool_id, {spreadsheet_id, range})
```

### Search the Web and Get Data
- Search the web with Exa or Serper
- Scrape and extract web content with Firecrawl
- Get weather forecasts, stock data, or country info

```
search_tools("web search") → execute_tool(tool_id, {query})
```

### Generate and Process Media
- Generate images with Replicate or Stability AI
- Transcribe audio with AssemblyAI
- Remove image backgrounds with Remove.bg
- Translate text with DeepL

```
search_tools("generate image") → execute_tool(tool_id, {prompt})
```

### Manage Infrastructure
- Provision DigitalOcean droplets and databases
- Manage Supabase projects
- Handle Stripe payments and subscriptions

```
search_tools("create droplet") → execute_tool(tool_id, {name, region, size})
```

### Run Multi-Tool Workflows

Chain multiple tools together into reusable workflows that pass data between steps automatically.

```
# Find existing workflows
list_workflows(query="github to slack") → browse available workflows

# Execute a workflow with inputs
execute_workflow(workflow_id="...", inputs={"repo": "my-org/my-repo", "channel": "#dev"})

# Check execution results
get_workflow_execution(execution_id="...")

# Create your own workflow
create_workflow(
  name="Daily Digest",
  steps=[
    {"step_number": 1, "tool_id": "...", "input_mapping": {"repo": "{{inputs.repo}}"}},
    {"step_number": 2, "tool_id": "...", "input_mapping": {"text": "{{steps.1.result}}", "channel": "{{inputs.channel}}"}}
  ],
  tags=["digest", "github", "slack"]
)
```

### Execute Tools in Batch

Run multiple independent tool calls concurrently for faster results.

```
batch_execute_tools(calls=[
  {"tool_id": "tool-uuid-1", "tool_input": {"query": "AI news"}},
  {"tool_id": "tool-uuid-2", "tool_input": {"query": "tech stocks"}},
  {"tool_id": "tool-uuid-3", "tool_input": {"location": "San Francisco"}}
])
```

Each call returns independently — individual failures don't fail the batch.

### Browse the Agent Web Directory

Search and read structured information about any website in the directory.

```
# Find sites by topic
search_sites(query="payment processing", category="saas")

# Get structured data about a specific domain
get_site_info(domain="stripe.com")
→ Returns: identity, products, team, pricing, docs, FAQ, contact info, and more
```

### Rate and Report Tools

Help improve tool quality by providing feedback.

```
# Rate a tool after using it
submit_rating(tool_id="...", rating=5, comment="Fast and accurate")

# Report a broken tool
report_tool(tool_id="...", reason="broken", description="Returns 500 error on all requests")

# Get recommendations for related tools
get_recommendations(tool_id="...", limit=5)
```

### Register and Fund Autonomous Agents

Create standalone agent identities with their own API keys and wallets.

```
# Register a new agent (no auth required)
register_agent(name="my-research-bot", operator_email="me@example.com")
→ Returns: agent_id, api_key (save this!), wallet_id

# Check agent profile and balance
get_agent_info()

# Fund the agent's wallet
fund_agent_wallet(method="card_checkout", amount_cents=1000)  # $10.00
fund_agent_wallet(method="crypto")  # Returns USDC deposit address on Base
```

## Core Workflow

Every tool interaction follows this pattern:

1. **Search** — `search_tools("what you want to do")`
2. **Check auth** — If the tool needs credentials, use `store_credential` or guide the user to https://danubeai.com/dashboard
3. **Gather parameters** — Ask the user for any missing required info
4. **Confirm** — Get user approval before executing actions like sending emails or creating issues
5. **Execute** — `execute_tool(tool_id, parameters)`
6. **Report** — Tell the user what happened with specifics, not just "Done"

## Available Services

**Communication:** Gmail, Slack, SendGrid, Resend, Loops, AgentMail, Postmark

**Development:** GitHub, Supabase, DigitalOcean, Stripe, Apify, Netlify, Render, Vercel, Railway, Neon, PlanetScale, Fly.io, Cloudflare Workers, Sentry

**Productivity:** Notion, Google Calendar, Google Sheets, Google Drive, Google Docs, Monday, Typeform, Bitly, Airtable, Todoist, Linear, Asana, Trello, ClickUp, Jira, Calendly

**Cloud & Infrastructure:** AWS (S3, Lambda, EC2), Google Cloud, Azure, Cloudflare, Heroku, Terraform

**AI & Media:** Replicate, Together AI, Stability AI, AssemblyAI, Remove.bg, DeepL, ElevenLabs, Whisper, Midjourney, DALL-E, Claude, OpenAI

**Search & Data:** Exa, Exa Websets, Firecrawl, Serper, Context7, Microsoft Learn, AlphaVantage, Clearbit, Hunter.io, Crunchbase, Diffbot

**Finance:** Stripe, Plaid, Wise, Coinbase, PayPal, Square, QuickBooks

**Social:** Twitter/X, LinkedIn, Discord, Reddit, Mastodon, Instagram, YouTube

**Design & Analytics:** Figma, Canva, Mixpanel, Amplitude, Segment, PostHog, Google Analytics

**Maps & Geo:** Google Maps, Mapbox, OpenStreetMap

**Weather:** Open-Meteo, OpenWeather, WeatherAPI, Tomorrow.io

**Public Data (No Auth Required):** Hacker News, REST Countries, Polymarket, Kalshi, Wikipedia, ArXiv, PubMed, SEC EDGAR

**Deployment & DevOps:** GitHub Actions, CircleCI, Docker Hub, npm Registry, PyPI

## Links

- Dashboard: https://danubeai.com/dashboard
- Docs: https://docs.danubeai.com
- MCP Server: https://mcp.danubeai.com/mcp
