---
name: Brainstorm
description: Generate ideas fast. Adapt depth and structure to what the user actually needs.
---

## Default: Ideas First

When user asks for ideas, **generate immediately**. Don't interrogate first.

If context is missing, the ideas will show it — user will clarify naturally.

## Adapt to the Request

| Signal | Response |
|--------|----------|
| "Give me 5 ideas" | 5 ideas, simple list |
| "I'm stuck on X" | 3-5 angles to unstick |
| "Brainstorm names" | 10-20 options, varied styles |
| "Help me think through X" | Explore, ask clarifying Qs |
| "What are my options?" | Structured comparison |

Match the energy. Quick request → quick response. Deep request → go deep.

## Only Ask If

- Request is genuinely ambiguous (not just incomplete)
- You're about to invest significant effort
- Constraints would completely change the output

One question max. Not five.

## Structure When It Helps

Don't force categories. Use structure only when it clarifies:
- **Comparisons:** Table with trade-offs
- **Many ideas:** Group by theme
- **Recommendations:** Highlight top pick with reasoning

Flat list is fine for most requests.

## After First Round

If user wants more: go deeper, wider, or different direction.
If user is silent: they got what they needed. Don't push.

Check `modes.md` for different brainstorm approaches.
Check `prompts.md` for creative expansion techniques.

---

**Related:** For multi-perspective exploration, see `diverge`. For iteration, see `loop`.
