# Tokyo Visitor Tips

## Before You Go

### Documents & Essentials

| Item | Notes |
|------|-------|
| **Passport** | Valid for duration of stay (no minimum validity required) |
| **Visa** | Most Western countries: 90 days visa-free |
| **Travel insurance** | Highly recommended |
| **Japan Rail Pass** | Buy BEFORE arrival if doing multi-city trip |
| **Pocket WiFi / eSIM** | Book ahead, pick up at airport |
| **Cash** | Withdraw at airport (¥30,000-50,000 to start) |

### Apps to Download

| App | Purpose |
|-----|---------|
| **Google Maps** | Navigation, train times (excellent in Japan) |
| **Google Translate** | Camera mode for menus, signs |
| **Suica app** | Digital IC card (iPhone only, may need Japanese Apple ID) |
| **Tabelog** | Restaurant reviews (Japanese, but translatable) |
| **Japan Official Travel App** | Tourism info, offline maps |
| **XE Currency** | Exchange rates |

### Money Preparation

- **Cash is king**: Many places don't accept cards
- **ATMs**: 7-Eleven and Japan Post ATMs work with foreign cards
- **Credit cards**: Visa/Mastercard accepted at major stores
- **IC cards**: Load money onto Suica/Pasmo for transit + convenience stores

---

## Arrival

### Narita Airport (NRT)

**Getting to Tokyo** (90min):
- **Narita Express (N'EX)**: ¥3,070, direct to Tokyo/Shibuya/Shinjuku
- **Keisei Skyliner**: ¥2,520, fastest to Ueno/Nippori
- **Access Express**: ¥1,270, slower but cheaper
- **Bus**: ¥1,300-3,200, various destinations

### Haneda Airport (HND)

**Getting to Tokyo** (30-45min):
- **Keikyu Line**: ¥300-500, to Shinagawa/city
- **Tokyo Monorail**: ¥500, to Hamamatsucho (JR connection)
- **Bus**: ¥600-1,200, various destinations

**Haneda is closer** — if booking flights, prefer Haneda.

### First Things to Do

1. Get IC card (Suica/Pasmo) at airport or station
2. Exchange some cash or use ATM
3. Pick up pocket WiFi if pre-booked
4. Get on train/bus to hotel
5. Enjoy!

---

## Getting Around

### IC Cards (Suica/Pasmo)

**What**: Rechargeable transit cards that work everywhere.

**Buy**: Airport, any JR or Metro station.

**Use for**:
- All trains, metros, buses
- Convenience stores
- Vending machines
- Some restaurants

**Tourist versions**: Welcome Suica (28 days), Pasmo Passport.

**Load**: Machines at stations (¥1,000 minimum).

### Train System Basics

**Companies** (all accept Suica/Pasmo):
- JR East (green signs)
- Tokyo Metro (blue M)
- Toei Subway (green leaf)
- Private lines (Tokyu, Odakyu, Keio, etc.)

**Fare**: ¥140-500 depending on distance.

**Last train**: Usually around midnight (varies by line).

**Rush hour**: 7:30-9:30am, 5:30-8pm (VERY crowded).

### Unlimited Passes

| Pass | Coverage | Price | Worth it? |
|------|----------|-------|-----------|
| Tokyo Subway 24h | Metro + Toei | ¥800 | If 4+ rides |
| Tokyo Subway 72h | Metro + Toei | ¥1,500 | Extended stay |
| JR Tokyo Wide | JR only | ¥600/day | Rarely |

**Reality**: Most tourists don't need passes. IC card is usually cheaper.

---

## Money Tips

### Cash Handling

- **¥10,000 notes**: Accepted everywhere
- **Coins**: Use them! Piles up fast (¥1, ¥5, ¥10, ¥50, ¥100, ¥500)
- **Change**: You'll get exact change always
- **Tip**: Never tip in Japan

### ATM Strategy

**Works**:
- 7-Eleven ATMs (everywhere, 24h)
- Japan Post ATMs (post offices)
- Some convenience store ATMs

**Doesn't work**: Most Japanese bank ATMs.

**Fees**: ¥200-400 per withdrawal.

**Strategy**: Withdraw larger amounts (¥30,000-50,000) to minimize fees.

### Credit Cards

**Accepted at**:
- Department stores
- Major chains
- Hotels
- Electronics stores

**Often NOT accepted at**:
- Small restaurants
- Traditional shops
- Markets
- Izakaya

**Best cards**: Visa, Mastercard (Amex less common).

---

## Cultural Tips

### The Big Ones

| Do | Don't |
|----|-------|
| Queue properly | Cut lines |
| Bow slightly when thanking | Hug or shake hands |
| Remove shoes when required | Wear shoes on tatami |
| Be quiet on trains | Talk on phone on trains |
| Slurp noodles | Talk with mouth full |
| Say "itadakimasu" before eating | Start eating immediately |

### Etiquette Quick Reference

**Trains**:
- No phone calls
- Keep conversations quiet
- Priority seats for elderly/pregnant/disabled
- Let people exit before boarding
- Stand on left (Tokyo) on escalators

**Restaurants**:
- "Sumimasen" to get attention
- Finish rice and soup completely
- Don't pass food chopstick-to-chopstick
- Don't stick chopsticks upright in rice

**Temples/Shrines**:
- Bow at entrance gate (torii)
- Wash hands at temizuya (water basin)
- Throw coin, bow twice, clap twice, pray, bow once (shrines)
- No photos of worshippers praying

**General**:
- Don't eat while walking (except festivals)
- Don't blow nose in public
- Cover tattoos at onsen (some accept them)
- Business cards received with two hands, read carefully

---

## Practical Tips

### WiFi & Connectivity

**Options**:
1. **Pocket WiFi**: Best for groups, unlimited data, ¥500-1,000/day
2. **eSIM**: Easiest if phone supports, ¥1,500-3,000/trip
3. **Physical SIM**: Cheap, good for longer stays
4. **Free WiFi**: Available but unreliable

**Where to get**:
- Airport pickup (book ahead)
- Bic Camera, Yodobashi
- Hotel front desk (sometimes)

### Luggage

**Coin lockers**: Available at all major stations, ¥300-700/day.

**Luggage forwarding**: Send bags ahead to hotel/airport (takkyubin), ¥2,000-3,000.

**Airport luggage delivery**: JAL ABC, QL Liner.

**Tip**: Tokyo Station has huge locker facility underground.

### Toilets

Japan has the world's best toilets:
- Bidet functions (buttons may be confusing)
- Heated seats
- Sound buttons (privacy)
- Always clean

**Button guide**:
- 止 = Stop
- おしり = Rear spray
- ビデ = Front spray (bidet)
- 流す = Flush

### Tax-Free Shopping

**Eligible**: Tourists with short-term visa.

**Minimum**: ¥5,000 in one store, one day.

**How**: Show passport at tax-free counter.

**Where**: Department stores, electronics stores, many shops.

**Note**: Items must leave Japan unopened (sealed in bag).

---

## Day Trips from Tokyo

### Kamakura (1 hour)
- Giant Buddha, temples, hiking
- Beach town vibes
- Best day trip for first-timers

### Nikko (2 hours)
- UNESCO shrines
- Mountain nature
- Use JR Pass if you have it

### Hakone (1.5 hours)
- Mt. Fuji views (weather permitting)
- Onsen hot springs
- Open-air museum

### Mt. Fuji (2.5 hours)
- Fuji Five Lakes area
- Climbing (July-August only)
- Views from Kawaguchiko

### Yokohama (30 minutes)
- Chinatown (Japan's largest)
- Waterfront area
- Easy half-day trip

---

## Common Mistakes

### Tourist Traps

- **Roppongi "free drink" offers**: Scam, leads to huge bills
- **Fake monks**: Not real, asking for "donations"
- **Overpriced souvenir shops**: Check prices at convenience stores first
- **Restaurant touts**: Quality places don't need them

### Logistical Errors

- **Underestimating distances**: Tokyo is HUGE
- **Missing last train**: Ends around midnight
- **Over-scheduling**: Travel time adds up
- **Not enough cash**: Many places cash-only
- **Wrong airport**: Narita vs Haneda are far apart

### Cultural Mistakes

- **Tipping**: Don't do it
- **Phone on trains**: No calls
- **Shoes indoors**: Always remove when required
- **Queueing**: Never cut lines
- **Pointing**: Use open hand gesture

---

## Emergency Information

| Situation | Number |
|-----------|--------|
| Police | 110 |
| Fire/Ambulance | 119 |
| English helpline | 03-5774-0992 |
| Embassy (US) | 03-3224-5000 |
| Embassy (UK) | 03-5211-1100 |

**Lost/stolen**:
- Report to police (get report for insurance)
- Lost items often turned in to station lost & found
- Koban (police boxes) can help

**Medical**:
- Hospitals: Many have limited English
- Tokyo Medical & Surgical Clinic: English-speaking
- AMDA International Medical Information Center: 03-5285-8088
