# Tokyo Attractions Guide

## Must-See (Truly Worth It)

### Senso-ji Temple (浅草寺) — Asakusa
**Tokyo's oldest and most visited temple.**

- **Why go**: Iconic Kaminarimon gate, traditional atmosphere, Nakamise shopping street
- **Time needed**: 1-2 hours
- **Best time**: Early morning (6am) to avoid crowds, or evening for lit lanterns
- **Cost**: Free
- **Tips**: 
  - Temple grounds open 24/7, main hall 6am-5pm
  - Draw omikuji (fortune) for ¥100
  - Nakamise has touristy souvenirs but fun atmosphere
  - Combine with Sumida River walk

### Meiji Shrine (明治神宮) — Harajuku
**Serene forest in the heart of Tokyo.**

- **Why go**: Peaceful escape, beautiful torii gates, traditional Shinto experience
- **Time needed**: 1-2 hours
- **Best time**: Early morning for tranquility
- **Cost**: Free (inner garden ¥500)
- **Tips**:
  - Watch for traditional weddings on weekends
  - The forest was man-made 100 years ago
  - Combine with Harajuku/Omotesando visit

### Tokyo Skytree (東京スカイツリー)
**World's tallest tower (634m).**

- **Why go**: Best views of Tokyo, clear day visibility to Mt. Fuji
- **Time needed**: 1-2 hours
- **Best time**: Sunset for day and night views
- **Cost**: ¥2,100-3,400 depending on level
- **Tips**:
  - Book online to skip queues
  - Tembo Deck (350m) is usually sufficient
  - Solamachi mall below has good food/shopping

### Shibuya Crossing
**The world's busiest intersection.**

- **Why go**: Iconic Tokyo experience, up to 3,000 people per crossing
- **Time needed**: 30 minutes
- **Best time**: Evening for neon lights, weekday rush hour for crowds
- **Cost**: Free
- **Tips**:
  - Cross it yourself, then watch from Starbucks above
  - Shibuya Sky (rooftop) has best overhead view
  - Hachiko statue nearby for photos

### TeamLab Planets/Borderless
**Immersive digital art experience.**

- **Why go**: Unique, Instagram-worthy, genuinely impressive
- **Time needed**: 2-3 hours
- **Best time**: Weekday, book morning slot
- **Cost**: ¥3,800-4,800
- **Tips**:
  - Book weeks ahead online
  - Wear shorts (you wade through water at Planets)
  - Borderless (Azabudai) is larger, Planets (Toyosu) more immersive
  - No photography restrictions (part of the experience)

---

## Very Good (Worth Your Time)

### Imperial Palace East Gardens
**Free public gardens of the Imperial Palace.**

- **Why go**: Beautiful gardens, historic castle ruins, free
- **Time needed**: 1-2 hours
- **Best time**: Spring (cherry blossoms) or autumn
- **Cost**: Free
- **Tips**:
  - Closed Mondays and Fridays
  - Get ticket at gate
  - Main palace not accessible, but grounds are lovely

### Tsukiji Outer Market
**Fresh seafood and food stalls.**

- **Why go**: Eat your way through, kitchen shops, authentic atmosphere
- **Time needed**: 2-3 hours
- **Best time**: 8am-11am (shops close by 2pm)
- **Cost**: ¥2,000-5,000 for eating
- **Tips**:
  - Cash preferred
  - Come hungry
  - Tamagoyaki (egg omelet) is a must-try

### Shinjuku Gyoen
**Tokyo's best park for cherry blossoms.**

- **Why go**: Stunning gardens, escape from city, picnic spot
- **Time needed**: 2-3 hours
- **Best time**: Late March-early April (sakura), mid-November (autumn)
- **Cost**: ¥500
- **Tips**:
  - No alcohol allowed (unlike other parks)
  - Three garden styles: Japanese, French, English
  - Get there early during sakura season

### Harajuku / Takeshita Street
**Youth fashion and pop culture.**

- **Why go**: Unique fashion, people watching, crepes and sweets
- **Time needed**: 1-2 hours
- **Best time**: Afternoon, weekends for fashion
- **Cost**: Free (shopping extra)
- **Tips**:
  - Extremely crowded weekends
  - Fashion has become more mainstream
  - Cat Street nearby is calmer, trendier

### Akihabara
**Electronics, anime, gaming culture.**

- **Why go**: Otaku paradise, unique Japanese pop culture
- **Time needed**: 2-4 hours
- **Best time**: Afternoon (shops open late)
- **Cost**: Free to browse
- **Tips**:
  - Multi-floor electronics stores
  - Arcade culture still alive
  - Maid cafes for the experience (touristy but fun)

---

## Good (If You Have Time)

### Roppongi Hills / Tokyo City View
- Observation deck, Mori Art Museum, shopping
- Good night views, less crowded than Skytree
- ¥2,200 (includes museum)

### Ueno Park & Museums
- Tokyo National Museum (Japan's largest)
- Zoo, ponds, temples
- Free park, museums ¥620-1,000

### Ginza
- Luxury shopping district
- Flagship stores, department stores
- Weekend afternoons: pedestrian street

### Yanaka
- Old Tokyo atmosphere, cat street
- Traditional shops, cemetery walks
- Great for photography

### Odaiba
- Waterfront, shopping, Gundam statue
- Good for families, rainy days
- Feels artificial but fun

---

## Skip or Manage Expectations

### Tokyo Tower
- **Reality**: Skytree is taller with better views
- **If you go**: Nostalgic charm, less crowded, cheaper
- **Verdict**: Skip unless you want the retro vibe

### Ghibli Museum
- **Reality**: Small, tickets hard to get, sold out months ahead
- **If you go**: Must book exactly one month ahead at 10am JST
- **Verdict**: Only for big Ghibli fans willing to plan

### Tokyo Disneyland/DisneySea
- **Reality**: ¥10,000+ per person, extremely crowded
- **If you go**: DisneySea is more unique (Tokyo original)
- **Verdict**: Skip unless you're a Disney devotee

### Robot Restaurant
- **Reality**: Closed permanently as of 2023
- Alternative: Try a traditional kabuki show instead

---

## Free Attractions

| Attraction | What | Location |
|------------|------|----------|
| Meiji Shrine | Shinto shrine in forest | Harajuku |
| Imperial Palace East Gardens | Former castle gardens | Chiyoda |
| Senso-ji Temple | Historic temple | Asakusa |
| Shibuya Crossing | Famous intersection | Shibuya |
| Hamarikyu Gardens (partial) | Waterfront gardens | Shiodome |
| Hama Rikyu (seniors) | Free for 65+ | Shiodome |
| Tokyo Metropolitan Gov Building | Free observatory | Shinjuku |

### Tokyo Metropolitan Government Building
**Free observation deck.**

- 202m high, 360° views
- North and South towers
- Open 9:30am-11pm
- Less crowded than paid observatories
- Best at sunset

---

## Best Views

| Location | Height | Cost | Best For |
|----------|--------|------|----------|
| Tokyo Skytree | 450m | ¥3,400 | Highest, clearest |
| Shibuya Sky | 230m | ¥2,200 | Outdoor, central |
| Tokyo Tower | 250m | ¥1,200 | Nostalgic, cheaper |
| Metro Gov Building | 202m | Free | Budget, night |
| Roppongi Hills | 250m | ¥2,200 | Art + views |

---

## Seasonal Highlights

### Cherry Blossoms (Late March - Early April)
- **Best spots**: Ueno Park, Shinjuku Gyoen, Meguro River, Chidorigafuchi
- **Experience**: Hanami (flower viewing) picnics
- **Tip**: Check sakura forecast, peak lasts only 1-2 weeks

### Summer Festivals (July - August)
- **Sumida River Fireworks**: Last Saturday of July, massive crowds
- **Bon Odori**: Traditional dances at local shrines
- **Tip**: Very hot and humid, stay hydrated

### Autumn Leaves (Mid-November - Early December)
- **Best spots**: Shinjuku Gyoen, Rikugien, Koishikawa Korakuen
- **Experience**: Illuminated night viewing
- **Tip**: Peak varies yearly, check forecasts

### Winter Illuminations (November - February)
- **Best spots**: Roppongi, Marunouchi, Shibuya, Odaiba
- **Experience**: Spectacular light displays
- **Tip**: Free to view, beautiful photo opportunities
