# Tokyo Transportation Guide

## System Overview

Tokyo has the world's most complex (and efficient) transit system.

### Main Operators

| Operator | Lines | Color | Notes |
|----------|-------|-------|-------|
| **JR East** | Yamanote, Chuo, etc. | Green | Major routes, JR Pass valid |
| **Tokyo Metro** | 9 lines | Various | Private subway |
| **Toei Subway** | 4 lines | Various | City-operated |
| **Private railways** | Many | Various | Tokyu, Odakyu, Keio, etc. |

**Good news**: All accept Suica/Pasmo cards.

---

## IC Cards (Suica / Pasmo)

### What They Are

Rechargeable smart cards for all transit + shopping.

**Suica** (JR East) and **Pasmo** (Metro/private) are interchangeable.

### Tourist Versions

| Card | Where to Buy | Validity | Features |
|------|--------------|----------|----------|
| **Welcome Suica** | JR stations, airports | 28 days | No deposit, expires |
| **Pasmo Passport** | Metro stations, airports | 28 days | No deposit, expires |
| **Regular Suica/Pasmo** | Stations | Indefinite | ¥500 deposit (refundable) |

### How to Use

1. **Buy**: Ticket machines at stations
2. **Load**: Insert bills/coins, select amount (¥1,000+ increments)
3. **Tap**: Touch to turnstile sensor (entry and exit)
4. **Check balance**: Shows on gate display or at machines

### Where to Use

- All trains, metros, buses in Tokyo
- Most convenience stores
- Vending machines
- Some restaurants and shops
- Taxis (many accept)

---

## JR Lines

### Yamanote Line (山手線)

**The essential loop** connecting all major stations.

**Key stations**: Tokyo, Ueno, Ikebukuro, Shinjuku, Shibuya, Shinagawa

**Facts**:
- 29 stations, full loop ~60 minutes
- Runs every 2-4 minutes
- Most crowded line during rush
- Color: Green

### Chuo Line (中央線)

**East-West express through Tokyo.**

**Key stations**: Tokyo, Shinjuku, Nakano, Kichijoji

**Types**:
- **Chuo Rapid** (orange): Skips stations, faster
- **Chuo-Sobu Local** (yellow): All stations

### Other Major JR Lines

| Line | Color | Connects |
|------|-------|----------|
| **Sobu** | Yellow | Chiba ↔ Shinjuku |
| **Keihin-Tohoku** | Light blue | Saitama ↔ Yokohama |
| **Saikyo** | Green | Saitama ↔ Odaiba area |

---

## Tokyo Metro

### 9 Metro Lines

| Line | Color | Key Stations | Useful For |
|------|-------|--------------|------------|
| **Ginza** | Orange | Shibuya, Ginza, Asakusa | Tourists |
| **Marunouchi** | Red | Tokyo, Shinjuku, Ikebukuro | Central loop |
| **Hibiya** | Gray | Roppongi, Ginza, Ueno | Entertainment |
| **Tozai** | Sky blue | Nihonbashi, Nakano | East-West |
| **Chiyoda** | Green | Omotesando, Meiji-Jingumae | Harajuku |
| **Yurakucho** | Gold | Ikebukuro, Ginza | Shopping |
| **Hanzomon** | Purple | Shibuya, Oshiage | Sky Tree |
| **Namboku** | Teal | Roppongi, Akasaka | North-South |
| **Fukutoshin** | Brown | Shibuya, Ikebukuro | Shopping |

### Metro Tips

- Transfers between Metro lines: Walk inside station
- JR ↔ Metro transfers: Exit and re-enter (IC card handles fare)
- Some stations are underground labyrinths

---

## Toei Subway

### 4 Toei Lines

| Line | Color | Key Stations |
|------|-------|--------------|
| **Asakusa** | Rose | Asakusa, Nihonbashi, Shinagawa |
| **Mita** | Blue | Meguro, Suidobashi |
| **Shinjuku** | Leaf green | Shinjuku, Roppongi |
| **Oedo** | Magenta | Roppongi, Tsukiji, Ueno |

**Note**: Toei is separate from Tokyo Metro but Suica works on both.

---

## Private Railways

### Major Private Lines

| Company | From | To | Useful For |
|---------|------|----|----|
| **Tokyu** | Shibuya | Yokohama, Setagaya | South/West suburbs |
| **Odakyu** | Shinjuku | Hakone, Odawara | Day trips |
| **Keio** | Shinjuku | Chofu, Kichijoji | Western suburbs |
| **Seibu** | Ikebukuro | Nerima, Kawagoe | Northwest |
| **Tobu** | Asakusa | Nikko, Saitama | Day trips |
| **Keisei** | Ueno | Narita Airport | Airport access |
| **Keikyu** | Shinagawa | Haneda Airport | Airport access |

---

## Fares & Passes

### Single Ride Fares

| Distance | Approximate Fare |
|----------|------------------|
| Short (1-2 stations) | ¥140-180 |
| Medium (3-6 stations) | ¥200-260 |
| Long (7+ stations) | ¥280-400+ |

### Day Passes

| Pass | Coverage | Price | Worth It? |
|------|----------|-------|-----------|
| **Tokyo Subway 24h** | Metro + Toei | ¥800 | 4+ subway rides |
| **Tokyo Subway 72h** | Metro + Toei | ¥1,500 | Extended stay |
| **Tokunai Pass** | JR only (23 wards) | ¥760 | JR-heavy day |
| **Tokyo Free Kippu** | All + some buses | ¥1,600 | Heavy use |

**Reality**: Most visitors don't need passes. IC card is simpler.

### Commuter Passes (Residents)

For regular routes:
- Buy at station (show work/school address)
- Significant savings for daily commuters
- 1/3/6 month options

---

## Using the System

### Reading Train Signs

**Station signs show**:
- Station name (Japanese + Romaji)
- Line color
- Station number (e.g., G-09)
- Previous and next stations

**Train car signs show**:
- Line name
- Destination (terminus)
- Express/Local type

### Train Types

| Type | Japanese | Speed | Stops |
|------|----------|-------|-------|
| **Local** | 各停 (Kakutei) | Slow | All stations |
| **Rapid** | 快速 (Kaisoku) | Fast | Selected stations |
| **Express** | 急行 (Kyuukou) | Faster | Major stations |
| **Limited Exp.** | 特急 (Tokkyuu) | Fastest | Few stations, often extra fare |

**Important**: Make sure your station isn't skipped!

### Rush Hour Survival

**Peak times**: 7:30-9:30am, 5:30-8pm

**Reality**: 
- Trains at 180-200% capacity
- Professional "pushers" at some stations
- Very difficult with luggage

**Tips**:
- Avoid if possible
- Women-only cars available (marked pink)
- Board at end of train (less crowded)
- Put backpack in front of you

---

## Buses

### When to Use

- Last mile from station to destination
- Some areas (like Shibuya → Roppongi)
- Scenic routes

### How to Ride

**Most Tokyo buses**: Enter front, pay flat fare (¥210), exit any door.

**Suburban buses**: Enter rear, take ticket, pay varying fare at exit.

**Payment**: Cash or IC card (tap when boarding).

---

## Taxis

### Basics

- **Base fare**: ¥500-600 (first 1km)
- **After**: ¥100 per 230m
- **Night surcharge**: 20% (10pm-5am)
- **Average ride**: ¥1,000-2,000

### Tips

- Doors open automatically (don't touch!)
- Give address or show map
- Most now accept credit cards and IC cards
- Receipt available (レシート / reshiito)
- No tipping

### Apps

- **GO**: Most popular ride-hailing
- **Japan Taxi**: Official taxi app
- **Uber**: Limited in Tokyo, more expensive

---

## Cycling

### Rental Bikes

**Docomo Bike Share**:
- Red bikes at stations throughout city
- ¥165/30min or ¥1,650/day
- App required (English available)

**Other services**: Hello Cycling, Luup (e-scooters too)

### Bike Rules

- Ride on left side of road
- Use bike lanes where available
- Lights required at night
- No riding on sidewalks (usually)
- Park only in designated areas

---

## Airport Access

### Narita Airport

| Option | Time | Cost | Best For |
|--------|------|------|----------|
| **Narita Express** | 60min | ¥3,070 | Convenience |
| **Skyliner** | 40min | ¥2,520 | Speed (to Ueno) |
| **Access Express** | 60min | ¥1,270 | Budget |
| **Limousine Bus** | 90min | ¥3,200 | Hotels |

### Haneda Airport

| Option | Time | Cost | Best For |
|--------|------|------|----------|
| **Keikyu** | 20min | ¥300-500 | Speed |
| **Monorail** | 20min | ¥500 | JR connection |
| **Limousine Bus** | 30-60min | ¥600-1,200 | Hotels |

### Tips

- Prefer Haneda if booking flights (closer)
- Last trains to airports leave early evening
- Late flights: Budget for taxi or airport hotel

---

## Navigation Tips

### Google Maps

- **Best app** for Tokyo navigation
- Real-time train times
- Shows which exit, which car
- Walking directions work well

### Station Exits

Large stations have 10-30+ exits. Check:
- Exit name (usually letters/numbers + landmark)
- Map before exiting (often near exits)
- Google Maps shows correct exit

### Transfers

- **Same company**: Usually same station, walk between platforms
- **Different company**: May require exiting and re-entering
- **IC card**: Handles complex fares automatically
