# Tokyo Tech Industry Guide

## Tech Scene Overview

Tokyo is Asia's largest tech hub with a mix of traditional Japanese corporations and growing startup ecosystem.

### Key Stats (2025-2026)

| Metric | Value |
|--------|-------|
| Tech job openings | Growing 12%+ annually |
| Software engineer demand | Very high |
| Average SWE salary | ¥6M-12M |
| English-friendly companies | Increasing |
| Startup funding | Record levels |

---

## Types of Tech Companies

### Global Tech Companies

**Present in Tokyo**:
- Google, Amazon, Microsoft, Apple
- Meta, Salesforce, Oracle
- Many others with Japan offices

**Characteristics**:
- English-speaking environments
- Higher salaries (¥10M-25M+)
- International culture
- Competitive hiring

### Japanese Tech Giants

| Company | Focus | Culture |
|---------|-------|---------|
| Rakuten | E-commerce, fintech | English official language |
| LINE | Messaging, fintech | Korean-Japanese, modern |
| Mercari | C2C marketplace | Startup culture |
| CyberAgent | Advertising, gaming | Japanese, dynamic |
| DeNA | Gaming, automotive | Japanese, technical |
| ZOZO | Fashion tech | Creative, modern |

### Traditional Japanese Companies

**Examples**: Sony, Panasonic, Toyota, NTT, Hitachi

**Characteristics**:
- Japanese required
- Longer hours, traditional culture
- Slower career progression
- Strong job security
- Lower salaries than foreign companies

### Startups

**Growing ecosystem with**:
- Increasing VC funding
- More foreign founders
- Government support (J-Startup)
- Still smaller than US/China

---

## Salary Ranges

### Software Engineering

| Level | Salary Range | Notes |
|-------|--------------|-------|
| Junior (0-3 yrs) | ¥4M-7M | Entry level |
| Mid (3-7 yrs) | ¥7M-12M | Standard |
| Senior (7+ yrs) | ¥10M-18M | Depends on company |
| Staff/Principal | ¥15M-25M+ | Rare in Japanese companies |
| Management | ¥12M-25M+ | Director+ |

### By Company Type

| Type | Range | Notes |
|------|-------|-------|
| Japanese traditional | ¥4M-10M | Lower ceiling |
| Japanese modern | ¥6M-15M | Mercari, LINE, etc. |
| Foreign company | ¥8M-25M+ | Higher ceiling |
| Startup (funded) | ¥5M-15M + equity | Variable |

### Comparison to US

Japanese tech salaries are **significantly lower** than Silicon Valley:
- Senior SWE in Tokyo: ¥10M-15M (~$65-100K)
- Senior SWE in SF: $200-400K total comp

**But**: Lower cost of living, better work-life balance (at some companies), safety, healthcare.

---

## Finding Tech Jobs

### Job Boards

| Platform | Focus | Language |
|----------|-------|----------|
| **Japan Dev** | Tech jobs, English-friendly | English |
| **TokyoDev** | Developer jobs | English |
| **LinkedIn** | All levels | Both |
| **Wantedly** | Startups, culture-focused | Japanese |
| **Green** | Tech jobs | Japanese |
| **Bizreach** | Mid-senior | Japanese |

### Recruiters

**English-speaking tech recruiters**:
- Robert Walters
- Michael Page
- Hays
- Computer Futures
- Recruit Direct Scout

### Direct Application

Many companies accept direct applications:
- Check company career pages
- GitHub/portfolio matters
- Referrals highly valuable

---

## Work Visa Requirements

### Engineer/Specialist Visa

**Requirements**:
- Bachelor's degree (any field) or 10 years experience
- Job offer from Japan company
- Company sponsors visa
- Salary meets minimum (no fixed minimum, but reasonable)

**Process**:
1. Company applies for Certificate of Eligibility
2. Wait 1-3 months
3. Apply for visa at embassy
4. Enter Japan

### Highly Skilled Professional (HSP) Visa

**Points-based system** (need 70+ points):
- Education (PhD = 30, Master's = 20, Bachelor's = 10)
- Work experience
- Salary
- Age (younger = more points)
- Japanese language ability
- Research achievements

**Benefits of HSP**:
- 5-year visa from start
- Easier path to permanent residence (1-3 years)
- Can bring parents (with conditions)
- Spouse can work

---

## Tech Hubs & Areas

### Shibuya

**The startup hub.**

- Many startups and tech companies
- Shibuya Hikarie, Scramble Square (office towers)
- Young, dynamic atmosphere
- Good for: Startups, modern Japanese companies

**Notable companies nearby**: CyberAgent, DeNA, Google

### Roppongi / Minami-Azabu

**Foreign company hub.**

- Many international companies
- Roppongi Hills (Google, etc.)
- International atmosphere
- Good for: Foreign companies, enterprise

### Shinagawa

**Growing tech area.**

- Near Shinkansen for travel
- Microsoft, many large companies
- Modern office developments
- Good for: Large companies, convenient commute

### Other Areas

- **Marunouchi**: Traditional business district
- **Akihabara**: Hardware, smaller tech
- **Gotanda**: Growing startup scene

---

## Work Culture

### Japanese vs Foreign Companies

| Aspect | Japanese | Foreign |
|--------|----------|---------|
| Language | Japanese | English (usually) |
| Hours | Often long | More reasonable |
| Meetings | Many, consensus | Fewer, decision-focused |
| Hierarchy | Strong | Flatter |
| Career path | Slow, stable | Faster, performance-based |
| Job security | High | Standard |

### What to Expect

**At Japanese companies**:
- Morning meetings (朝礼)
- Group lunches
- After-work drinking (nomikai)
- Slower decision making
- Strong team orientation

**At foreign companies**:
- More individual contribution valued
- Performance reviews
- Direct communication acceptable
- More vacation usage
- Higher turnover

---

## Skills in Demand

### Most Sought After

| Skill | Demand Level |
|-------|--------------|
| Cloud (AWS, GCP, Azure) | Very High |
| Machine Learning / AI | Very High |
| Backend (Go, Python, Java) | High |
| Frontend (React, TypeScript) | High |
| Mobile (iOS, Android) | High |
| DevOps / SRE | High |
| Data Engineering | High |
| Security | Growing |

### Language Requirements

| Company Type | Japanese Needed |
|--------------|-----------------|
| Foreign (engineering) | Often no |
| Foreign (customer-facing) | Usually yes |
| Japanese modern | Varies (N2-N3 helpful) |
| Japanese traditional | Yes (N1-N2) |
| Startup | Varies widely |

### Building Your Profile

**Valued by Japanese employers**:
- Clean GitHub profile
- Open source contributions
- Technical blog
- Certifications (AWS, etc.)
- Japanese ability (even basic shows effort)

---

## Interview Process

### Typical Flow

1. **Resume screening**
2. **Recruiter call** (30 min)
3. **Technical interview** (1-2 rounds)
4. **Team/culture fit interview**
5. **Final interview** (sometimes with exec)
6. **Offer**

**Timeline**: 2-6 weeks typical

### What's Different

**Japanese companies may**:
- Ask about long-term career plans
- Evaluate "culture fit" heavily
- Have group interviews
- Ask about personality/hobbies
- Care about university prestige

**Foreign companies**: Similar to their global process.

### Tips

- Research company thoroughly
- Prepare questions to ask
- Dress appropriately (suits for Japanese companies)
- Show enthusiasm for Japan
- Be humble but confident

---

## Community & Networking

### Meetups & Events

| Event | Focus |
|-------|-------|
| Tokyo Tech Meetups | Various languages/topics |
| DevRel/Japan | Developer relations |
| Tokyo.js | JavaScript |
| GoConference Tokyo | Go language |
| PyCon Japan | Python |
| RubyKaigi | Ruby |

### Online Communities

- **TokyoDev Discord**: Active English-speaking tech community
- **Japan Dev Slack**: Job focused
- **Reddit r/japanlife**: General expat discussion
- **LinkedIn**: Professional networking

### Co-working Spaces

| Space | Location | Style |
|-------|----------|-------|
| WeWork | Multiple | International |
| WEWORK | Shibuya, Roppongi | Startup friendly |
| Fabbit | Various | Local focus |
| Impact Hub | Meguro | Social impact |

---

## Practical Tips

### Getting Started

1. **Build portfolio** before applying
2. **Learn basics of Japanese** (shows commitment)
3. **Network at events** (referrals matter)
4. **Consider recruiters** for first job
5. **Be flexible on salary** initially

### Long-term Career

- Japanese experience valued globally
- Can lead APAC teams from Tokyo
- Salary tends to increase with experience
- Switching jobs normal in tech (unlike traditional Japan)
- Consider permanent residency for stability
