# Tokyo Student Guide

## Study Options

### Types of Institutions

| Type | Duration | Focus |
|------|----------|-------|
| **Language school** | 3 months - 2 years | Japanese study |
| **Vocational school** (専門学校) | 2 years | Career skills |
| **University** (大学) | 4 years | Degree programs |
| **Graduate school** | 2+ years | Master's, PhD |
| **Exchange program** | 6 months - 1 year | Partner university |

### Language Schools

**Popular for**:
- Learning Japanese from scratch
- Preparing for university entrance
- Cultural experience

**Major schools in Tokyo**:
- KAI Japanese Language School
- Shinjuku Japanese Language Institute
- Tokyo Galaxy Japanese Language School
- Intercultural Institute of Japan
- ISI Language School

**Cost**: ¥700,000-900,000/year (tuition only)

### Universities with English Programs

| University | Program | Notes |
|------------|---------|-------|
| Temple University Japan | Full degrees | American university in Tokyo |
| Waseda | SILS, some graduate | Top private |
| Sophia (Jochi) | FLA, graduate | International focus |
| Keio | PEARL, GIGA | Top private |
| University of Tokyo | PEAK, graduate | Top national |
| Kyoto University | Some programs | (Not Tokyo but notable) |

### Tuition Costs

| Type | Annual Tuition |
|------|----------------|
| National university | ¥535,800 |
| Public university | ¥535,800-660,000 |
| Private university | ¥800,000-1,500,000+ |
| Language school | ¥700,000-900,000 |

---

## Student Visa

### Requirements

- Acceptance letter from institution
- Certificate of Eligibility (school applies)
- Financial proof (¥2M+ in bank)
- High school/university diploma
- Passport

### Work Permission

**With student visa + work permit**:
- Up to 28 hours/week during school
- Up to 40 hours/week during breaks
- Must apply for permission separately

### Part-time Jobs (アルバイト)

**Common student jobs**:
- Convenience store (konbini): ¥1,100-1,300/hour
- Restaurant: ¥1,100-1,400/hour
- English teaching: ¥1,500-3,000/hour
- Translation: ¥1,500-3,000/hour

**Where to find**:
- School job boards
- Town Work (townwork.net)
- Baitoru (baitoru.com)
- Word of mouth

---

## Student Budget

### Monthly Costs

| Category | Budget | Comfortable |
|----------|--------|-------------|
| Rent (share house) | ¥50,000 | ¥70,000 |
| Rent (own room) | ¥70,000 | ¥90,000 |
| Utilities | ¥10,000 | ¥15,000 |
| Food | ¥30,000 | ¥45,000 |
| Transport | ¥5,000 | ¥10,000 |
| Phone | ¥2,000 | ¥5,000 |
| Insurance | ¥2,000 | ¥2,000 |
| Entertainment | ¥10,000 | ¥20,000 |
| Misc | ¥10,000 | ¥15,000 |
| **Total** | **¥119,000** | **¥172,000** |

### Saving Money

**Housing**:
- Share houses (¥50,000-70,000 all-in)
- School dormitories (if available)
- Outer areas (Nerima, Adachi)

**Food**:
- Cook at home
- Gyomu Super, OK Store
- Supermarket discounts after 8pm
- Student cafeterias

**Transport**:
- Student commuter passes
- Bicycle for local trips

---

## Student Housing

### Options

| Type | Cost/Month | Pros | Cons |
|------|------------|------|------|
| School dorm | ¥50,000-80,000 | Easy, community | Rules, curfews |
| Share house | ¥50,000-90,000 | Social, furnished | Less privacy |
| Own apartment | ¥70,000-100,000 | Privacy | Expensive upfront |
| Homestay | ¥80,000-120,000 | Cultural immersion | Less freedom |

### Student-Friendly Areas

| Area | Rent | Notes |
|------|------|-------|
| Takadanobaba | ¥70,000+ | Student hub, Waseda area |
| Nakano | ¥80,000+ | Affordable, central |
| Koenji/Asagaya | ¥70,000+ | Creative, cheap |
| Kitasenju | ¥65,000+ | Budget, improving |

### Finding Housing

**Resources**:
- School housing office
- GaijinPot Apartments
- Oakhouse (share houses)
- Tokyo Share House
- Suumo (Japanese)

---

## Daily Life as a Student

### School Schedule

**Typical language school**:
- Morning: 9:00-12:30
- Afternoon: 13:30-17:00
- Part-time work allowed after class

**University**:
- Varies by program
- Less structured than Western universities
- Club activities important

### Japanese Language Study

**JLPT Levels** (Japanese Language Proficiency Test):

| Level | Ability | Study Time |
|-------|---------|------------|
| N5 | Basic | 3-4 months |
| N4 | Elementary | 6-12 months |
| N3 | Intermediate | 1-2 years |
| N2 | Upper-intermediate | 2-3 years |
| N1 | Advanced | 3-5 years |

**N2** typically required for:
- University in Japanese
- Professional jobs
- Daily life comfort

**N1** needed for:
- Japanese graduate programs
- Traditional Japanese companies
- Translation/interpretation

### Student Discounts

**Available with student ID**:
- Museums: 50% off often
- Movies: ¥1,500 vs ¥2,000
- Transit: Student passes
- Some restaurants
- Software (Microsoft, Adobe)

---

## Health & Wellbeing

### Health Insurance

**Required**: National Health Insurance (国民健康保険)

- Cost: ~¥2,000/month (student rate)
- Covers: 70% of medical costs
- Required: Register at ward office

### Mental Health

**Resources**:
- School counseling (often free)
- TELL Japan: 03-5774-0992
- Tokyo English Lifeline: 03-5774-0992

**Common challenges**:
- Language barrier stress
- Cultural adjustment
- Loneliness
- Academic pressure

### Staying Healthy

- School health center for minor issues
- Pharmacies for OTC medicine
- University hospitals for serious issues

---

## Social Life

### Making Friends

**At school**:
- Classmates (easiest)
- Club activities (サークル)
- Language exchange partners

**Outside school**:
- Meetup.com events
- Language exchange apps (HelloTalk)
- Part-time job colleagues
- International parties

### Club Activities (サークル)

**Important in Japanese university culture**:
- Sports clubs
- Cultural clubs (tea ceremony, calligraphy)
- Music clubs
- Volunteer groups

**Benefits**:
- Make Japanese friends
- Practice language
- Job hunting networks
- Fun!

### Nightlife

**Student-friendly areas**:
- Shibuya: Everything, expensive
- Shinjuku: Variety, some cheap
- Shimokitazawa: Indie, chill
- Koenji: Alternative, cheap

**Budget tips**:
- Nomihoudai (all-you-can-drink) deals: ¥2,000-3,000
- Happy hours
- Konbini pre-drinking (legal in Japan)

---

## After Graduation

### Job Hunting (就職活動 / Shuukatsu)

**Japanese job hunting is unique**:
- Starts 1 year before graduation
- Mass hiring season (April entry)
- Company seminars and tests
- Group interviews common

**Timeline**:
- 3rd year (June): Internships begin
- 4th year (March): Official job hunting starts
- 4th year (June): Offers begin
- 4th year (October): Most finalized

### Working in Japan After Study

**Options**:
1. **Get hired** → Company sponsors work visa
2. **Change to job-seeking visa** (tokutei katsudo) → 6-12 months to find work
3. **Start business** → Business manager visa (need capital)
4. **Return home** → Japanese experience valued globally

### Visa Transition

**Student → Work**:
1. Get job offer
2. Company applies for Certificate of Eligibility
3. Change status at immigration
4. Usually smooth if legitimate job

---

## Practical Tips

### Before Coming

- [ ] Apply for school acceptance
- [ ] Get Certificate of Eligibility
- [ ] Apply for student visa
- [ ] Arrange initial housing
- [ ] Book flight
- [ ] Prepare ¥300,000-500,000 for startup costs

### First Week

- [ ] Register address at ward office
- [ ] Enroll in health insurance
- [ ] Open bank account
- [ ] Get phone/SIM
- [ ] Buy commuter pass
- [ ] Explore neighborhood

### Success Tips

1. **Study Japanese seriously** — It opens everything up
2. **Join clubs/activities** — Best way to make friends
3. **Work part-time** — Money + language practice + experience
4. **Travel Japan** — Use breaks to explore
5. **Build network** — Useful for job hunting

### Common Mistakes

- Hanging out only with same-nationality friends
- Not using Japanese outside class
- Overworking and neglecting studies
- Spending too much initially
- Ignoring mental health
