# Tokyo Startup Guide

## Startup Ecosystem Overview

Tokyo's startup scene is growing rapidly but still maturing compared to Silicon Valley.

### Key Stats (2025-2026)

| Metric | Status |
|--------|--------|
| VC funding | Record levels, growing |
| Unicorns | 10+ Japanese unicorns |
| Government support | Strong (J-Startup program) |
| English-friendly | Improving |
| Exit environment | Improving (more IPOs) |

### Strengths

- Large domestic market (126M people)
- Safe, clean, efficient city
- Growing pool of talent
- Government support
- Increasing VC activity

### Challenges

- Language barrier
- Conservative business culture
- Risk-averse talent pool
- Slow enterprise sales
- Lower salaries than US

---

## Startup Hubs & Spaces

### Physical Locations

| Area | Character |
|------|-----------|
| **Shibuya** | Main startup hub, young energy |
| **Roppongi** | International, established tech |
| **Gotanda** | Growing startup scene |
| **Marunouchi** | Corporate innovation |
| **Akihabara** | Hardware, maker space |

### Co-working Spaces

| Space | Location | Style |
|-------|----------|-------|
| **WeWork** | Multiple | International, professional |
| **Plug and Play** | Shibuya | Accelerator connected |
| **DMM.make AKIBA** | Akihabara | Hardware focused |
| **Impact Hub** | Meguro | Social impact |
| **Fabbit** | Various | Affordable |
| **CIC Tokyo** | Toranomon | High-end, international |

### Startup Events

| Event | Focus |
|-------|-------|
| **Slush Tokyo** | Annual flagship event |
| **Tech in Asia Tokyo** | Regional conference |
| **B Dash Camp** | VC/founder gathering |
| **Japan Night** | Pitch events globally |
| **Tokyo Startup meetups** | Regular networking |

---

## Starting a Company

### Legal Structures

| Type | Capital | Liability | Notes |
|------|---------|-----------|-------|
| **KK (株式会社)** | ¥1+ (typically ¥1M+) | Limited | Standard company |
| **GK (合同会社)** | ¥1+ | Limited | Simpler, LLC equivalent |
| **Branch office** | None | Parent liable | For foreign companies |

### Process to Incorporate

**GK (simpler)**:
1. Prepare articles of incorporation
2. Register at Legal Affairs Bureau
3. ~¥60,000 in fees
4. 1-2 weeks

**KK (standard)**:
1. Prepare articles
2. Notarization (~¥50,000)
3. Capital deposit
4. Register at Legal Affairs Bureau
5. ~¥200,000+ in fees
6. 2-4 weeks

### Visa for Founders

**Business Manager Visa Requirements**:
- Office space in Japan
- ¥5M+ capital OR 2+ full-time employees
- Business plan
- Clean background

**Tips**:
- Can start with GK structure
- Some flexibility on capital requirement
- Consider starting as employee first

---

## Funding Landscape

### Funding Stages

| Stage | Amount | Sources |
|-------|--------|---------|
| Pre-seed | ¥5-30M | Angels, accelerators |
| Seed | ¥30-100M | Angels, seed VCs |
| Series A | ¥100-500M | VCs |
| Series B+ | ¥500M+ | Growth VCs |

### Active Investors

**Japanese VCs**:
- Globis Capital Partners
- JAFCO
- Global Brain
- Incubate Fund
- East Ventures
- Coral Capital

**International VCs (Japan active)**:
- 500 Startups (Japan fund)
- DCM
- Sequoia (selectively)
- SoftBank (later stage)

**Corporate VCs (CVC)**:
- Most major corporations have CVCs
- Focus on strategic fit
- Can be slow but deep pockets

### Accelerators

| Program | Focus | Investment |
|---------|-------|------------|
| **500 Startups Japan** | General | ¥5M for 5% |
| **Plug and Play** | Multiple verticals | Various |
| **JETRO/J-Startup** | Government support | No equity |
| **Google for Startups** | Tech | No equity |
| **Open Network Lab** | General | ¥5-10M |

---

## Hiring

### Talent Challenges

- Risk-averse culture (big company preference)
- Language barriers
- Lower startup salaries vs foreign companies
- Competition for engineers

### Where to Find Talent

| Platform | Best for |
|----------|----------|
| **Wantedly** | Young, mission-driven |
| **LinkedIn** | International talent |
| **Green** | Engineers |
| **Bizreach** | Mid-senior |
| **Referrals** | Most effective |

### Compensation

**Reality check**:
- Japanese talent expects lower base than US
- Equity less understood/valued
- Benefits matter (insurance, transport)

**Stock options**:
- Growing acceptance
- Tax treatment improved
- Still not as valued as US

### Building Team

**Tips**:
- First hires often from network
- Consider bilingual talent (bridge roles)
- Interns from universities
- Part-time/contractors initially

---

## Business Culture

### Sales in Japan

**Enterprise sales challenges**:
- Long sales cycles (6-12 months)
- Relationship-based decisions
- Consensus required (nemawashi)
- Face-to-face valued
- Reference customers crucial

**Tips**:
- Warm introductions essential
- Be patient
- Invest in relationships
- Consider partners/distributors
- Start with smaller companies

### Working with Japanese Companies

| Aspect | Reality |
|--------|---------|
| Decision making | Slow, consensus-based |
| Contracts | Detailed, take time |
| Meetings | Many, often ceremonial |
| Communication | Indirect, face-saving |
| Relationships | Long-term oriented |

### B2B vs B2C

**B2B**: 
- Longer sales cycle
- Higher trust required
- But loyal customers once won
- Reference customers crucial

**B2C**:
- Marketing costs high
- Quality expectations high
- But large, affluent market
- Mobile-first

---

## Support & Resources

### Government Programs

**J-Startup**:
- Selected promising startups
- Government support
- International exposure
- No direct funding but access

**JETRO**:
- Foreign startup support
- Office space programs
- Introduction services
- Market research

**Tokyo Metropolitan Government**:
- Startup hub programs
- Grants and subsidies
- Soft landing programs

### Professional Services

**Legal**:
- Morrison Foerster (MoFo)
- Baker McKenzie
- TMI Associates (Japanese)
- Atsumi & Sakai

**Accounting**:
- Deloitte, PwC, EY, KPMG
- Smaller firms for startups

**Banking**:
- Silicon Valley Bank (Japan office)
- Traditional banks (harder for startups)

---

## Foreign Founder Tips

### Advantages

- Fresh perspective
- International network
- Different experience
- English fluency (for global)

### Challenges

- Language barrier
- Business culture differences
- Network building from scratch
- Visa complications

### Success Strategies

1. **Find Japanese co-founder/key hire**
   - Navigate culture
   - Business development
   - Credibility with customers/investors

2. **Learn Japanese**
   - Shows commitment
   - Builds trust
   - Access to more opportunities

3. **Start in your strength**
   - Use international experience
   - Build bridge between markets
   - Global from day one

4. **Build relationships first**
   - Attend events
   - Coffee meetings
   - Give before asking

### Common Models

**Foreign founders often succeed with**:
- Japan entry for foreign products
- Global expansion from Japan
- Cross-border business models
- Technology with global potential

---

## Practical Considerations

### Costs to Start

| Item | Cost |
|------|------|
| Incorporation (GK) | ¥100,000-200,000 |
| Incorporation (KK) | ¥250,000-500,000 |
| Office/co-working | ¥50,000-300,000/month |
| Legal/accounting setup | ¥200,000-500,000 |
| First 6 months runway | ¥3-10M+ |

### Monthly Burn (Early Stage)

| Item | Minimum | Comfortable |
|------|---------|-------------|
| Office | ¥50,000 | ¥150,000 |
| 1 employee | ¥500,000 | ¥800,000 |
| Services/tools | ¥50,000 | ¥100,000 |
| Legal/accounting | ¥50,000 | ¥100,000 |
| Marketing | ¥0 | ¥200,000 |
| Misc | ¥50,000 | ¥100,000 |
| **Total** | **¥700,000** | **¥1,450,000** |

### Timeline Reality

| Milestone | Typical Time |
|-----------|--------------|
| Idea to incorporation | 1-3 months |
| First paying customer | 6-18 months |
| Seed funding | 6-12 months |
| Series A | 18-36 months |
| Profitability | 3-5 years |

---

## Exit Landscape

### IPO

**Tokyo Stock Exchange**:
- TSE Growth (startups)
- TSE Standard (established)
- TSE Prime (large cap)

**Timeline**: 5-10 years typical

**Notable**: Japan has many small IPOs (¥1-10B market cap)

### M&A

**Growing but still developing**:
- Strategic acquisitions increasing
- Foreign acquirers active
- Valuations generally lower than US
- Cultural fit important

### Secondary Sales

**Limited but growing**:
- Some VC-to-VC transactions
- Secondary platforms emerging
- Less common than US
