# Tokyo Safety Guide

## Overall Safety

**Tokyo is one of the safest major cities in the world.**

- Violent crime is extremely rare
- Homicide rate: 0.2 per 100,000 (vs 5+ in many Western cities)
- Gun crime: Virtually non-existent
- Most crimes are petty theft
- Walking alone at night is generally safe

---

## Crime Concerns

### Petty Theft

**Low risk but exists in tourist areas:**

| Location | Risk Level | Notes |
|----------|------------|-------|
| Shibuya Station | Medium | Crowded, some pickpockets |
| Asakusa | Medium | Tourist area, bag snatching |
| Akihabara | Medium | Tourist area |
| Trains (rush hour) | Low-Medium | Crowded conditions |
| Most residential areas | Very Low | Extremely safe |

**Prevention**:
- Keep valuables in front pockets
- Don't leave bags unattended
- Use bag hooks under tables at restaurants
- Lock your bicycle (theft is common)

### Scams

**Common tourist scams**:

1. **Fake monks** (Asakusa, Ueno)
   - Offer "blessing" and bracelet
   - Demand payment after
   - Real monks don't approach tourists

2. **Roppongi "free drink" touts**
   - Approach foreign men
   - Lead to clubs with ¥50,000+ bills
   - Never follow touts anywhere

3. **Overcharging at hostess/host clubs**
   - Bills can reach ¥100,000+
   - Avoid unless invited by locals you trust

4. **Nigerian touts** (Roppongi, Kabukicho)
   - Aggressive club promoters
   - Ignore and walk past

**Golden rule**: If someone approaches you, they want your money.

### Nightlife Safety

**Higher-risk areas**:

| Area | Issue | Advice |
|------|-------|--------|
| Roppongi | Drink spiking, scams | Watch your drinks, avoid touts |
| Kabukicho | Red light district, scams | Tourist areas safe, side streets risky |
| Ikebukuro (north exit) | Some gang activity | Generally fine, use common sense |

**Drink spiking**:
- Happens to men and women
- Never leave drinks unattended
- Don't accept drinks from strangers
- Victims robbed, credit cards maxed out

**Safe nightlife tips**:
- Go with friends
- Tell someone where you're going
- Don't get blackout drunk
- Trust your instincts—leave if uncomfortable

---

## Women's Safety

### Generally Very Safe

Tokyo is consistently rated safest city for women travelers.

**However**:

### Chikan (Groping on Trains)

**Reality**: Sexual harassment on crowded trains exists.

**Prevention**:
- Women-only cars available (ピンク / pink marked)
- Usually at front or rear of train
- Available during rush hours
- Move if someone makes you uncomfortable

**If it happens**:
- Say "CHIKAN!" loudly
- Grab their hand and hold up
- Press emergency button
- Others will help

### Voyeurism

- Upskirt photography exists
- Most phones in Japan must make shutter sound
- Some escalators have mirrors to prevent

### General Tips for Women

- Avoid love hotels area alone late night
- Kabukicho can feel uncomfortable
- Most of Tokyo is completely safe
- Trust your instincts

---

## Natural Disasters

### Earthquakes

**Japan sits on 4 tectonic plates. Earthquakes are frequent.**

**Minor earthquakes** (daily):
- Often don't notice
- Buildings are designed for it
- Life continues normally

**Major earthquakes** (rare but serious):
- Stay calm
- Inside: Duck under table or doorframe
- Outside: Move to open area (avoid buildings)
- After: Turn off gas, check for fires
- Check hotel earthquake guide

**Preparation**:
- Know emergency exits
- Keep shoes by bed (broken glass)
- Emergency kit: water, flashlight, food
- Emergency apps: Safety Tips (NHK)

### Typhoons

**Season**: July-October, peak August-September

**What happens**:
- Heavy rain, strong winds
- Trains may stop
- Flights cancelled
- Usually 24-48 hour warning

**Response**:
- Stay indoors during storm
- Stock food and water
- Check transport status before going out
- Follow local news/apps

### Tsunami

**Tokyo Bay is protected** but after major earthquake:
- Get to high ground if near coast
- Move inland
- Follow instructions on emergency broadcasts

---

## Health & Medical

### Medical Emergencies

| Situation | Number |
|-----------|--------|
| Ambulance | 119 |
| Police | 110 |

**Hospital tips**:
- English support limited at most hospitals
- Bring translator app or friend
- Travel insurance highly recommended
- AMDA International: 03-5285-8088 (English medical help)

### Pharmacies

- **Drugstores** (ドラッグストア): Basic medicine, no prescription needed
- **Prescription**: Need doctor visit
- **24h pharmacies**: Rare, but exist in major areas

**Common items available OTC**:
- Pain relievers (weaker than Western)
- Cold medicine
- Stomach medicine
- Band-aids, antiseptic

**Need prescription** (different from home):
- Strong painkillers
- Some allergy medicines
- Most antibiotics

### Water & Food Safety

**Tap water**: Safe to drink everywhere in Tokyo.

**Food safety**: 
- Extremely high standards
- Food poisoning rare
- Raw fish is fresh and safe
- Street food is safe

---

## Emergency Contacts

### Essential Numbers

| Service | Number |
|---------|--------|
| Police | 110 |
| Fire/Ambulance | 119 |
| Japan Helpline (English) | 0570-000-911 |
| TELL Lifeline (mental health) | 03-5774-0992 |
| Tokyo English Lifeline | 03-5774-0992 |

### Embassies (Tokyo)

| Country | Phone |
|---------|-------|
| USA | 03-3224-5000 |
| UK | 03-5211-1100 |
| Australia | 03-5232-4111 |
| Canada | 03-5412-6200 |
| EU countries | Check respective embassy |

### Lost & Found

**Lost items often returned** — Japan is famous for this.

**What to do**:
1. Check where you lost it (staff often hold items)
2. Station lost & found (駅の忘れ物センター)
3. Police koban (small police box)
4. Online: JR East, Metro, Toei all have search systems

**Koban (交番)**:
- Small police stations on street corners
- Officers can help with directions, lost items
- File reports for lost/stolen items
- Get report number for insurance

---

## Areas to Be Aware Of

### Not Dangerous, But Use Caution

| Area | Notes |
|------|-------|
| Kabukicho | Red light district, touts, some scams. Main streets fine, alleys riskier |
| Roppongi | Nightclub scams, drink spiking. Daytime fine |
| Ueno Park | Homeless population, fine during day |
| San'ya (Minami-Senju) | Historic day laborer area, avoid wandering |

### Generally Safe Everywhere Else

Tokyo doesn't have "no-go zones" like some cities. The areas above just require more awareness, not avoidance.

---

## Practical Safety Tips

### Daily Life

- Lock your door (crime is rare but exists)
- Lock your bicycle (theft happens)
- Don't flash expensive items
- Keep passport safe (copy stored separately)

### At Night

- Most areas completely safe
- Stay in well-lit areas in nightlife districts
- Women can walk alone safely in most places
- Use women-only train cars if crowded

### Travel Documents

- Carry passport or residence card at all times (legally required)
- Make copies stored separately
- Register with your embassy (optional but recommended)

### Natural Disasters

- Know earthquake basics
- Check weather during typhoon season
- Download emergency apps
- Know your hotel's evacuation plan
