# Moving to Tokyo — Resident Guide

## Visa Types

### Work Visas

| Visa Type | Requirements | Duration |
|-----------|--------------|----------|
| **Engineer/Specialist** | Bachelor's + job offer | 1-5 years |
| **Intra-company Transfer** | Transfer from foreign office | 1-5 years |
| **Highly Skilled Professional** | Points system (70+) | 5 years |
| **Business Manager** | Start business, ¥5M+ capital | 1-5 years |
| **Instructor** | Teaching position | 1-3 years |

### Other Visas

| Visa Type | Requirements | Notes |
|-----------|--------------|-------|
| **Student** | School acceptance | Can work 28h/week |
| **Working Holiday** | Age 18-30, select countries | 1 year |
| **Spouse** | Married to Japanese national | Unlimited work |
| **Dependent** | Spouse of visa holder | Limited work |

### No Digital Nomad Visa

Japan does not have a remote work visa. Options:
- Tourist visa (90 days, no local employment)
- Working holiday (18-30, select countries)
- Get actual work visa through company

---

## Finding an Apartment

### Rental Process

1. **Search**: Real estate agents, websites
2. **View**: Schedule viewings (often same day)
3. **Apply**: Submit documents
4. **Screening**: Landlord + guarantor company review
5. **Contract**: Sign, pay initial costs
6. **Move in**: Usually within 2-4 weeks

### Required Documents

- Passport
- Residence card (在留カード)
- Proof of income (employment letter, bank statement)
- Emergency contact in Japan
- Hanko (seal) or signature

### Challenges for Foreigners

**Common issues**:
- "No foreigners" policies (decreasing but exist)
- Guarantor requirement
- Japanese-only documentation
- Communication barriers

**Solutions**:
- Use expat-friendly agents (GaijinPot, Real Estate Japan, PLAZA HOMES)
- Guarantor companies (保証会社) accept foreigners
- Bring Japanese-speaking friend
- Start with share house if struggling

### Apartment Hunting Websites

| Site | Language | Notes |
|------|----------|-------|
| Real Estate Japan | English | Expat-focused |
| GaijinPot Apartments | English | Foreigner-friendly |
| SUUMO | Japanese | Largest selection |
| Homes.co.jp | Japanese | Large selection |
| PLAZA HOMES | English | Premium, agents |

### Typical Timeline

- Start searching: 1-2 months before move
- Viewing to move-in: 2-4 weeks
- Peak season (Jan-Mar): Harder to find

---

## Initial Setup

### First Week Checklist

| Task | Where | Notes |
|------|-------|-------|
| Register address | Ward office (区役所) | Within 14 days |
| Get My Number card | Ward office | Apply for benefits access |
| Open bank account | Bank branch | Bring residence card |
| Get phone/SIM | Electronics store | Need address |
| Set up internet | Provider | Book installation |
| Register utilities | Phone/online | Gas requires visit |

### Ward Office Registration (住民登録)

**Required within 14 days of moving.**

**Bring**:
- Passport
- Residence card
- Rental contract (or address proof)

**You'll get**:
- Proof of registration
- Health insurance enrollment
- My Number application

### Bank Accounts

**Challenges for foreigners**:
- Some banks refuse new residents
- Need address, phone number, residence card

**Recommended banks**:
- **Shinsei Bank**: Foreigner-friendly, online banking in English
- **SMBC Prestia**: International, English support
- **Japan Post Bank**: Basic, widely accessible
- **Sony Bank**: Online, English interface

**Tips**:
- Bring residence card + passport + address proof
- Having employment helps
- Start with Shinsei or Japan Post if struggling

### Phone/Internet

**Mobile options**:
- Major carriers: Docomo, au, SoftBank (¥7,000-9,000/month)
- MVNO/budget: Rakuten, LINEMO, ahamo (¥2,000-4,000/month)

**Home internet**:
- Fiber: NURO, au Hikari, SoftBank Hikari
- Cost: ¥4,500-6,500/month
- Installation: 2-4 weeks

---

## Healthcare

### Health Insurance (健康保険)

**Mandatory for all residents.**

**Types**:
- **Employee Insurance** (社会保険): Through employer, split cost
- **National Health Insurance** (国民健康保険): Self-employed, students

**Coverage**: 70% of costs paid by insurance.

### Finding Doctors

**English-speaking clinics**:
- Tokyo Medical and Surgical Clinic (Shiba Koen)
- Tokyo Midtown Medical Center
- International Catholic Hospital (Seibo)

**Regular clinics**:
- Google Maps search "病院" (byouin)
- Many small clinics, specialized
- No GP system—go to specialist directly

**Dental**:
- Regular dental care affordable
- Find English-speaking at medical directories

### Emergency

- **119**: Ambulance
- **Emergency hospitals**: Check nearest before emergency
- **AMDA Medical Info**: 03-5285-8088 (English support)

---

## Daily Life Setup

### Utilities

**Electricity**:
- Multiple providers (TEPCO main)
- Apply online or by phone
- Bills monthly

**Gas**:
- City gas or propane
- Requires inspection visit
- Schedule before move-in

**Water**:
- Contact local waterworks
- Billed bi-monthly
- Usually automatic with address registration

### Garbage & Recycling

**Japan has strict sorting**:
- Burnable (燃えるゴミ): Food waste, paper
- Non-burnable (燃えないゴミ): Plastic, metal
- Recyclables: PET bottles, cans, glass
- Oversized (粗大ゴミ): Furniture, appliances (pay fee)

**Rules**:
- Specific days for each type
- Put out morning of collection
- Use designated bags (buy at konbini)
- Check local rules (vary by ward)

### Hanko (印鑑 / Personal Seal)

**Traditional signature replacement.**

**Need for**:
- Bank accounts
- Contracts
- Official documents

**Get one**:
- ¥1,000-5,000 at hanko shops
- Register at ward office (実印)
- Many places now accept signatures

---

## Making Life Easier

### Apps for Daily Life

| App | Purpose |
|-----|---------|
| Google Maps | Navigation |
| Google Translate | Communication |
| PayPay | QR payment (widely accepted) |
| Suica app | Transit (iPhone) |
| Money Forward | Expense tracking |
| Tabelog | Restaurant discovery |

### Learning Japanese

**Necessity level**: High for comfortable life.

**Options**:
- Language schools (visa students)
- Part-time classes
- Apps (Duolingo, WaniKani)
- Private tutors
- Language exchange

**Minimum useful**:
- Hiragana/katakana reading
- Basic phrases
- Numbers and counting

### Making Friends

**Challenges**: Japanese social circles can be closed.

**Options**:
- Meetup.com groups
- Language exchange events
- Hobbies (sports, music, etc.)
- Expat communities
- Work colleagues
- International parties

### Shopping

**Daily needs**:
- Supermarkets: LIFE, Summit, Seiyu
- Konbini: 7-Eleven, Lawson, FamilyMart
- Drugstores: Matsumoto Kiyoshi, Welcia

**Household goods**:
- Nitori (Japanese IKEA)
- Muji
- Don Quijote
- 100-yen shops (Daiso, Seria)

---

## Long-Term Considerations

### Permanent Residency

**After 10 years** (or 1-3 years if highly skilled):
- No more visa renewals
- Can work any job
- Requires application and approval

### Naturalization

**After 5+ years**:
- Become Japanese citizen
- Give up original citizenship (Japan doesn't allow dual)
- Requires Japanese ability

### Pension & Retirement

**National pension** (国民年金):
- Mandatory contributions
- Partial refund if leaving Japan (lump-sum)
- Bilateral agreements with some countries

### Taxes

**Resident tax** (住民税):
- Paid to local government
- Based on previous year income
- Bills come mid-year

**Income tax** (所得税):
- Withheld by employer
- File return if multiple incomes or self-employed
