# Tokyo Local Services Guide

## Banking

### Recommended Banks for Foreigners

| Bank | Pros | Cons |
|------|------|------|
| **Shinsei Bank** | English online, ATM-free, easy to open | Limited branches |
| **SMBC Prestia** | International focus, English support | Higher fees |
| **Sony Bank** | Online, good for FX | No branches |
| **Japan Post Bank** | Everywhere, easy | Basic features |
| **MUFG/SMBC/Mizuho** | Full service | Harder to open for foreigners |

### Opening Account

**Requirements**:
- Residence card
- Passport
- Address proof
- Phone number
- Hanko or signature

**Process**:
1. Visit branch with documents
2. Fill application (staff can help)
3. Account ready in 1-2 weeks
4. Card mailed to address

### ATMs

**7-Eleven ATMs**: Work with foreign cards, 24h available.
**Japan Post ATMs**: Work with most foreign cards.
**Others**: Often don't accept foreign cards.

### Money Transfer

**International transfers**:
- Wise (TransferWise): Best rates, easy
- PayPal: Convenient but higher fees
- Bank wire: Expensive, slow

---

## Phone & Internet

### Mobile Providers

**Major carriers** (full service, expensive):
- NTT Docomo
- au (KDDI)
- SoftBank

**Budget MVNOs** (recommended):
- Rakuten Mobile: Unlimited from ¥3,278
- LINEMO: From ¥990
- ahamo (Docomo): ¥2,970 for 20GB
- UQ Mobile: From ¥1,628
- Y!Mobile: From ¥2,178

### Home Internet

**Fiber options**:
- NURO Hikari: Fastest, ¥5,200/month
- au Hikari: Good speed, ¥5,610/month
- SoftBank Hikari: Bundles available
- Docomo Hikari: Wide coverage

**Setup time**: 2-4 weeks for installation.

**Apartment limitations**: Some buildings have specific providers.

---

## Healthcare Providers

### English-Speaking Clinics

| Clinic | Location | Specialty |
|--------|----------|-----------|
| Tokyo Medical & Surgical | Shiba Koen | General |
| Tokyo Midtown Medical Center | Roppongi | General, dental |
| International Catholic Hospital | Shinjuku | Hospital |
| Nishishinjuku International Clinic | Nishi-Shinjuku | General |
| King Clinic | Various | General |

### Pharmacies (Drugstores)

**Major chains**:
- Matsumoto Kiyoshi (マツモトキヨシ)
- Welcia (ウエルシア)
- Tomod's (トモズ)
- Daikoku Drug (ダイコクドラッグ)

**What you can buy**:
- Pain relievers (weaker than Western)
- Cold medicine
- Stomach medicine
- First aid supplies
- Vitamins

**Need prescription for**:
- Strong painkillers
- Most antibiotics
- Some allergy medicines

### Mental Health

- **TELL Japan**: 03-5774-0992 (English counseling)
- **Tokyo English Life Line**: 03-5774-0992
- **International Mental Health Professionals Japan**: Directory of English-speaking therapists

---

## Government Services

### Ward Office (区役所)

**Location**: One per ward, central location.

**Services**:
- Address registration
- Health insurance enrollment
- My Number card
- Certificates (住民票, etc.)
- Child/family support

**Tips**:
- Go early (opens 8:30am usually)
- Weekdays only (some Saturday limited)
- Limited English but forms available
- Bring all documents

### Immigration (入国管理局)

**For**:
- Visa renewals
- Status changes
- Re-entry permits
- Residence card issues

**Main office**: Shinagawa (prepare for long waits).

**Tips**:
- Apply 3 months before visa expires
- Bring all requested documents
- Online appointment available
- Processing: 2-4 weeks typical

### Tax Office (税務署)

**For**:
- Income tax filing (確定申告)
- Tax questions
- ID number issues

**Filing period**: February 16 - March 15 (for previous year).

---

## Emergency Services

### Fire & Ambulance: 119

**What to say**:
- "Fire" (火事/kaji) or "Ambulance" (救急車/kyuukyuusha)
- Your address
- Situation

### Police: 110

**Koban (交番)**: Small police boxes on streets.
- Lost items
- Directions
- Non-emergency help
- File reports

### Disaster Preparation

**Emergency kit**:
- 3 days water (2L/person/day)
- Non-perishable food
- Flashlight + batteries
- First aid kit
- Cash (ATMs may be down)
- Phone charger
- Radio

**Apps**:
- Safety Tips (NHK): Emergency alerts
- Yahoo! 防災速報: Disaster warnings

---

## Transportation Services

### Trains & Subways

See `transport.md` for full details.

**Lost and found**:
- JR East: jreast.co.jp/multi/en/
- Tokyo Metro: tokyometro.jp/lang_en/
- Toei: kotsu.metro.tokyo.jp/eng/

### Taxis

**Hailing**: Stand at taxi stand or flag on street.

**Apps**:
- GO: Most popular, easy to use
- Japan Taxi: Official taxi app
- Uber: Limited in Tokyo

**Typical fares**: ¥500 base + ¥100/230m.

### Rental Cars

**Requirements**:
- International Driving Permit (IDP) + home license
- Or Japanese license

**Providers**:
- Times Car: Easy, widespread
- Orix Rent a Car
- Nippon Rent-A-Car

**Note**: Parking in Tokyo is expensive and difficult.

---

## Postal Services

### Japan Post (日本郵便)

**Services**:
- Regular mail (普通郵便)
- Registered mail (書留)
- Express (速達)
- International shipping
- Yu-Pack (parcels)

**Post offices**: Everywhere, red T symbol.

**Konbini shipping**: 7-Eleven, Lawson, FamilyMart accept parcels.

### Package Delivery

**Major carriers**:
- Yamato (クロネコヤマト): Black cat logo
- Sagawa (佐川急便)
- Japan Post Yu-Pack

**Redelivery**: Leave note, call number, or use app.

---

## Shopping

### Department Stores

| Store | Locations | Known For |
|-------|-----------|-----------|
| Isetan | Shinjuku | Fashion, depachika |
| Mitsukoshi | Ginza, Nihonbashi | Luxury, traditional |
| Takashimaya | Shinjuku, Nihonbashi | Premium |
| Seibu | Ikebukuro, Shibuya | Large selection |
| Tokyu | Shibuya | Modern |

### Electronics

| Store | Locations | Notes |
|-------|-----------|-------|
| Bic Camera | Major stations | Tax-free, points |
| Yodobashi | Major stations | Huge selection |
| Yamada Denki | Various | Good prices |

### Home Goods

| Store | Type | Price |
|-------|------|-------|
| Nitori | Furniture, household | ¥-¥¥ |
| IKEA | Furniture | ¥-¥¥ |
| Muji | Minimalist goods | ¥¥ |
| Tokyu Hands | DIY, crafts | ¥¥-¥¥¥ |
| Loft | Stationery, lifestyle | ¥¥ |
| Daiso | 100-yen shop | ¥ |

### Supermarkets

**Budget**:
- Gyomu Super: Bulk, wholesale
- OK Store: Consistently low
- Hanamasa: 24h, meat focus

**Standard**:
- LIFE
- Summit
- Seiyu (Walmart)

**Premium**:
- Kinokuniya
- Seijo Ishii
- National Azabu (imported)

---

## Fitness & Recreation

### Gyms

| Gym | Monthly | Notes |
|-----|---------|-------|
| Anytime Fitness | ¥7,500-9,000 | 24h, many locations |
| Gold's Gym | ¥12,000-15,000 | Full facilities |
| JOYFIT24 | ¥7,000-8,000 | 24h |
| Public gyms | ¥300-500/visit | Basic, cheap |

### Sports

- **Running**: Imperial Palace loop (5km, popular)
- **Cycling**: Rental bikes (Docomo Share)
- **Swimming**: Public pools in each ward
- **Martial arts**: Many dojos accept foreigners
- **Team sports**: Tokyo expat leagues (football, rugby, etc.)

### Parks

**Major parks**:
- Yoyogi Park: Largest central park
- Shinjuku Gyoen: Beautiful gardens
- Ueno Park: Museums, zoo
- Inokashira Park: Kichijoji, boats
- Odaiba: Waterfront, beaches

---

## Community & Social

### Expat Communities

- **Tokyo Expat Network** (Facebook)
- **Tokyo International Friends** (Meetup)
- **InterNations Tokyo** (Events)
- **Tokyo American Club** (Membership)

### Language Exchange

- **Meetup.com**: Many language events
- **HelloTalk**: App for language partners
- **Conversation Exchange**: Web platform

### Volunteering

- **Second Harvest Japan**: Food bank
- **Tokyo English volunteer guide**: Tourism
- **Various NPOs**: Check volunteer.go.jp
