# Traditional Japanese Food in Tokyo

## Sushi (寿司)

### Understanding Sushi Styles

| Style | Description | Price |
|-------|-------------|-------|
| **Kaiten-zushi** | Conveyor belt, casual | ¥1,000-2,500 |
| **Tachigui** | Standing, quick | ¥1,500-3,000 |
| **Counter (regular)** | Casual counter | ¥3,000-8,000 |
| **Omakase** | Chef's choice course | ¥10,000-50,000+ |

### Omakase Etiquette

1. **Eat quickly** — Sushi should be eaten within seconds of serving
2. **Use fingers or chopsticks** — Both acceptable
3. **Dip fish-side down** — Never rice in soy sauce
4. **Ginger is a palate cleanser** — Not a topping
5. **No perfume** — Interferes with subtle flavors
6. **Trust the chef** — Don't modify or skip pieces

### Where to Eat Sushi

**Budget (¥1,000-3,000)**:
- Conveyor belt chains: Sushiro, Kura Sushi, Hamazushi
- Tsukiji/Toyosu outer market standing shops
- Supermarket sushi (surprisingly good)

**Mid-range (¥3,000-8,000)**:
- Neighborhood sushi-ya (counter shops)
- Midori Sushi (popular, quality)
- Department store sushi restaurants

**High-end (¥15,000-50,000+)**:
- Ginza: Sukiyabashi Jiro, Saito, Sawada
- Book weeks/months in advance
- Lunch is more accessible than dinner

---

## Ramen (ラーメン)

### Tokyo Ramen Styles

| Style | Broth | Noodles | Where |
|-------|-------|---------|-------|
| **Shoyu** | Soy-based, clear | Thin, curly | Classic Tokyo style |
| **Shio** | Salt-based, light | Thin, straight | Subtle, lighter |
| **Tonkotsu** | Pork bone, creamy | Thin, straight | Hakata/Kyushu origin |
| **Miso** | Miso-based, hearty | Thick, wavy | Sapporo origin |
| **Tsukemen** | Dipping style | Thick, cold | Tokyo invention |

### Ramen Shop Protocol

1. **Buy ticket** — Machine at entrance, select before sitting
2. **Choose options** — Noodle firmness, fat level, garlic
3. **Sit at counter** — Hand ticket to staff
4. **Eat fast** — Noodles get soggy
5. **Slurp loudly** — It's expected and appreciated
6. **Leave quickly** — Queues waiting

### Famous Ramen Areas

- **Ramen Street (Tokyo Station)**: Multiple famous shops, tourist-friendly
- **Ikebukuro**: High concentration of shops
- **Ogikubo**: Classic Tokyo shoyu
- **Nakano**: Hidden gems
- **Shinjuku**: Late-night options

**Tip**: Lines indicate quality. 20-30 minutes is normal for famous shops.

---

## Tempura (天ぷら)

### What to Know

- Light, crispy batter on seafood and vegetables
- Eaten immediately after frying (seconds matter)
- Counter seats let you watch the artistry
- High-end tempura is an art form

### Eating Tempura

- **Dip lightly** in tentsuyu (dipping sauce) OR
- **Use salt** — flavored salts provided
- **Eat in order** — chef serves in optimal sequence
- **Hot = good** — coldness ruins tempura

### Where to Eat

**Budget (¥1,000-2,000)**:
- Tenya (chain, reliable)
- Tempura teishoku shops

**Mid-range (¥3,000-6,000)**:
- Neighborhood tempura-ya
- Department store restaurants

**High-end (¥10,000-20,000+)**:
- Kondo (Ginza) — famous for vegetable tempura
- Fukamachi (Kyobashi) — Michelin starred

---

## Tonkatsu (とんかつ)

### Understanding Tonkatsu

- Deep-fried breaded pork cutlet
- Usually served as set (定食) with cabbage, rice, miso soup
- Two main cuts: **rosu** (fatty loin) or **hire** (lean tenderloin)
- Quality varies from ¥900 chains to ¥3,000+ specialty shops

### Famous Chains & Shops

**Budget (¥800-1,200)**:
- Matsunoya, Katsuya (chains, reliable)

**Quality (¥1,500-3,000)**:
- Maisen (Omotesando) — tourist favorite, quality
- Tonki (Meguro) — local legend
- Butagumi (multiple) — kurobuta pork specialist

### Tonkatsu Tips

- Grind your own sesame for sauce
- Refills of cabbage, rice, miso usually free
- "Kurobuta" (black pork) is premium

---

## Yakitori (焼き鳥)

### What It Is

Skewered, grilled chicken. Every part of the bird.

### Common Cuts

| Japanese | Part | Flavor Profile |
|----------|------|---------------|
| Momo | Thigh | Juicy, rich |
| Negima | Thigh + leek | Classic |
| Tsukune | Meatball | Savory, often with egg yolk |
| Kawa | Skin | Crispy, fatty |
| Nankotsu | Cartilage | Crunchy |
| Reba | Liver | Rich, iron-y |
| Hatsu | Heart | Lean, mild |
| Bonjiri | Tail | Fatty, rich |

### Ordering

- **Tare** (タレ): Sweet soy glaze
- **Shio** (塩): Salt only — highlights quality
- Order 2-3 sticks per person per round
- Pair with beer or highball

### Where to Go

- **Yurakucho underpass**: Classic yakitori alley atmosphere
- **Specialty shops**: Higher quality, may need reservations
- **Izakaya**: Most have yakitori on menu

---

## Soba & Udon (そば・うどん)

### Soba (Buckwheat Noodles)

**Styles**:
- **Zaru soba**: Cold, dipped in tsuyu
- **Kake soba**: Hot broth
- **Tempura soba**: With tempura

**Tokyo specialty**: Fine, delicate noodles with dashi-forward broth.

**Famous shops**: Kanda Yabu Soba, Sarashina Horii

### Udon (Wheat Noodles)

**Styles**:
- **Kake udon**: Hot broth
- **Bukkake**: Cold with toppings
- **Kamaage**: Hot in cooking water

**Tokyo style**: Darker, stronger broth than Kansai.

**Chains**: Marugame Seimen (quality chain, fresh noodles)

---

## Unagi (うなぎ)

### What to Know

- Freshwater eel, grilled with sweet sauce
- **Kabayaki**: Butterflied, grilled, sauced
- **Shirayaki**: Grilled without sauce (highlight eel flavor)
- Traditional summer stamina food

### Eating Styles

- **Unaju**: On rice in lacquer box
- **Unadon**: On rice in bowl
- **Hitsumabushi**: Nagoya style, eat 3 ways

### Where to Eat

High-end unagi is expensive (¥4,000-8,000) due to eel scarcity. Quality matters significantly.

- **Nodaiwa** (Azabu-Juban) — Famous, long lines
- **Obana** (Minami-Senju) — Local legend
- Department store restaurants — reliable mid-range

---

## Kaiseki (懐石)

### What It Is

Multi-course Japanese haute cuisine. Seasonal, artistic, expensive.

### Typical Course Structure

1. **Sakizuke** — Appetizer
2. **Hassun** — Seasonal platter
3. **Owan** — Soup
4. **Yakimono** — Grilled dish
5. **Nimono** — Simmered dish
6. **Rice, pickles, miso**
7. **Dessert**

### Where to Experience

**Lunch courses** are more accessible:
- Hotel restaurants (often ¥8,000-15,000 lunch)
- Ginza/Kyobashi area restaurants
- Ryokan (traditional inn) dining

**Dinner** ranges ¥20,000-50,000+ at renowned establishments.

---

## Sukiyaki & Shabu-Shabu (すき焼き・しゃぶしゃぶ)

### Sukiyaki

- Sweet soy-based broth
- Thinly sliced beef, vegetables
- Dip in raw beaten egg
- Cooked at table

### Shabu-Shabu

- Light kombu broth
- Swish meat briefly ("shabu shabu" sound)
- Dip in ponzu or sesame sauce

### Where to Eat

**Mid-range chains**: Nabezo, Onyasai (all-you-can-eat options)

**High-end**: Imahan (Nihonbashi), Zakuro — wagyu focus
