# Tokyo Food — Practical Guide

## Dining Etiquette

### Before Eating

| Action | What to Do |
|--------|------------|
| **Entering** | Say "irasshaimase" back is not required (staff greeting) |
| **Seating** | Wait to be seated, or ask "sumimasen" for attention |
| **Towel (oshibori)** | Wipe hands only (not face, though locals sometimes do) |
| **Water** | Usually free and automatic |
| **Ordering** | Catch server's eye, say "sumimasen" or press call button |

### During the Meal

| Rule | Why |
|------|-----|
| **Say "itadakimasu"** | Before eating (like "bon appétit") |
| **Slurp noodles** | Expected for ramen, soba, udon — aerates and shows enjoyment |
| **Don't pass food chopstick-to-chopstick** | Resembles funeral ritual |
| **Don't stick chopsticks upright in rice** | Also funeral imagery |
| **Finish your rice** | Leaving rice is wasteful |
| **Soup bowl to lips** | Drink directly from bowl |
| **One hand for bowl, one for chopsticks** | Lift bowls, don't hunch |

### After Eating

| Action | What to Say/Do |
|--------|----------------|
| **Finishing** | Say "gochisosama deshita" (thank you for the meal) |
| **Paying** | Take bill to register (don't pay at table usually) |
| **Tipping** | NEVER tip — included and tipping can offend |
| **Leftover food** | Doggy bags uncommon but occasionally possible |

---

## Restaurant Survival Japanese

### Essential Phrases

| English | Japanese | Romaji |
|---------|----------|--------|
| Excuse me | すみません | Sumimasen |
| Table for 2 | 2名です | Ni-mei desu |
| Menu please | メニューください | Menu kudasai |
| This please | これください | Kore kudasai |
| Delicious! | おいしい! | Oishii! |
| Check please | お会計お願いします | Okaikei onegaishimasu |
| Thank you for the meal | ごちそうさまでした | Gochisosama deshita |

### Dietary Needs

| English | Japanese | Romaji |
|---------|----------|--------|
| Vegetarian | ベジタリアン | Bejitarian |
| No meat please | 肉なしでお願いします | Niku nashi de onegaishimasu |
| No fish please | 魚なしでお願いします | Sakana nashi de onegaishimasu |
| Allergy | アレルギー | Arerugii |
| I can't eat [X] | [X]が食べられません | [X] ga taberaremasen |

### Common Menu Terms

| Japanese | Meaning |
|----------|---------|
| 定食 (teishoku) | Set meal |
| 大盛り (oomori) | Large portion |
| 小盛り (komori) | Small portion |
| おかわり (okawari) | Refill |
| お持ち帰り (omochi kaeri) | Takeout |
| 本日のおすすめ (honjitsu no osusume) | Today's special |

---

## Ordering Systems

### Ticket Machines (券売機)

Common at ramen shops, udon shops, some restaurants.

**How to use**:
1. Look at photos/menu before approaching
2. Insert money first
3. Press button for your order
4. Take ticket(s)
5. Give ticket to staff
6. Wait for food

**Tips**:
- Most have photos
- English available at tourist areas
- Ask staff for help if confused
- Change dispensed after selection

### Call Buttons (呼び出しボタン)

Many restaurants have table buttons.
- Press once for service
- Server will come to table
- Say "sumimasen" if no button

### Tablet Ordering

Growing trend in chains:
- Select language (often English available)
- Browse menu with photos
- Add to cart
- Submit order
- Pay at register when done

### Counter Service

At sushi counters, yakitori, etc.:
- Chef may recommend items
- Point at what you want
- Say "osusume" (recommendation) for chef's choice
- Keep track of plates for billing

---

## Convenience Store (Konbini) Food Guide

### What's Good

| Category | Best Picks |
|----------|------------|
| **Onigiri** | Salmon (sake), tuna mayo, mentaiko |
| **Bento** | Nori-ben (seaweed), yakiniku, makunouchi |
| **Hot foods** | Karaage (fried chicken), nikuman (meat bun), oden |
| **Noodles** | Fresh ramen/udon (microwave section) |
| **Sandwiches** | Egg salad, katsu sandwich |
| **Desserts** | Pudding, roll cake, seasonal items |
| **Drinks** | Canned coffee, green tea, Pocari Sweat |

### Konbini Hacks

- **Hot water** available free for cup noodles
- **Microwave** free to use
- **ATM** (7-Eleven works for foreign cards)
- **Eat-in corners** at some locations
- **Seasonal items** change frequently — try limited editions
- **Late night discounts** on some fresh items

### Coffee

All major konbini have decent self-serve coffee:
- 7-Eleven: Best quality
- Lawson: "Machi Cafe" (barista-style available)
- FamilyMart: Reliable

**How**: Pay at register, take cup, fill at machine.

---

## Dietary Restrictions

### Vegetarian in Tokyo

**Reality**: Difficult but improving. Most Japanese food uses dashi (fish/kelp stock).

**Safer options**:
- Shojin ryori (Buddhist cuisine) — fully vegetarian
- Indian restaurants — vegetarian sections
- Modern vegan cafes (check HappyCow app)
- T's TanTan (Tokyo Station) — vegan ramen

**Communicate clearly**:
「野菜だけ、肉と魚なしでお願いします」
"Yasai dake, niku to sakana nashi de onegaishimasu"
(Vegetables only, no meat or fish please)

**Hidden non-vegetarian items**:
- Dashi (fish stock) in miso soup, most broths
- Bonito flakes as garnish
- Oyster sauce in stir-fries
- Gelatin in desserts

### Halal Options

Growing but still limited:
- Halal ramen shops (search "halal ramen Tokyo")
- Indian/Pakistani restaurants
- Halal wagyu shops
- Asakusa area has several options

**Resources**: 
- Halal Gourmet Japan app
- Halal Media Japan website

### Allergies

**Common allergens in Japanese food**:
- Soy (shoyu/soy sauce is everywhere)
- Wheat (in soy sauce, tempura, ramen)
- Shellfish and fish
- Eggs
- Buckwheat (soba)

**Prepare**:
- Print allergy card in Japanese
- Show phone with translation
- List specific allergens: アレルギー [allergen]
- Severe allergies: consider cooking own food

---

## Money & Payment

### Cash Still King

Many restaurants, especially:
- Small ramen shops
- Traditional izakaya
- Market stalls
- Yokocho bars

**Always carry**: ¥10,000-20,000 in cash

### Cards Accepted

- Department stores
- Major chains
- Hotels
- Shopping malls

**Best cards**: Visa and Mastercard widely accepted when cards work.

### IC Cards (Suica/Pasmo)

Work at:
- Convenience stores
- Some chain restaurants
- Vending machines
- Some cafes

### QR Payment (PayPay, etc.)

Growing rapidly but:
- Requires Japanese bank account to set up properly
- Some tourist versions available
- Not essential for visitors

---

## Finding Restaurants

### Best Apps/Sites

| Platform | Best For |
|----------|----------|
| **Tabelog** | Most comprehensive, Japanese UI |
| **Google Maps** | Easy, English reviews, photos |
| **Tripadvisor** | English reviews, tourist perspective |
| **Yelp Japan** | Limited but English-friendly |
| **Instagram** | Visual discovery, #tokyofood |

### Reading Tabelog Ratings

Tabelog scores differently than Western sites:
- **3.5+**: Very good
- **3.6+**: Excellent
- **3.7+**: Outstanding
- **4.0+**: Exceptional (rare)

A 3.5 on Tabelog ≈ 4.5 on Yelp/Google.

### Booking Restaurants

**No booking needed**: Chains, ramen, casual teishoku

**Same-day booking**: Mid-range izakaya

**Advance booking (English options)**:
- Hotel concierge
- Omakase.in (sushi)
- TableCheck
- Pocket Concierge

---

## Seasonal & Limited Items

### Why It Matters

Japanese food culture is deeply seasonal. Limited-edition items drive excitement.

### What to Look For

| Season | Specialties |
|--------|-------------|
| **Spring** | Sakura flavored everything, strawberries |
| **Summer** | Cold noodles, kakigori, watermelon |
| **Autumn** | Sweet potato, chestnut, mushrooms |
| **Winter** | Oden, nabe, strawberries, osechi |

### Konbini Limited Editions

- Change constantly (weekly sometimes)
- Seasonal flavors in everything
- Collaboration items (anime, games)
- Regional specialties rotating through

**Tip**: If it looks interesting, buy it now — it may be gone tomorrow.
