# Tokyo Food Overview

## Why Tokyo is the World's Food Capital

- **Most Michelin stars** of any city (200+ starred restaurants)
- **Incredible diversity**: From ¥500 ramen to ¥50,000 omakase
- **Specialization culture**: Restaurants perfect ONE dish for decades
- **Freshness obsession**: Ingredients arrive daily from across Japan
- **Service excellence**: Hospitality is an art form

## Food Categories at a Glance

### Japanese Cuisine

| Type | Price Range | Where |
|------|-------------|-------|
| Sushi | ¥1,000-50,000 | Everywhere, Tsukiji, Ginza |
| Ramen | ¥800-1,500 | Specialized shops everywhere |
| Tempura | ¥1,500-15,000 | Ginza, Nihonbashi |
| Tonkatsu | ¥1,200-3,000 | Specialized shops |
| Yakitori | ¥2,000-5,000 | Yurakucho, everywhere |
| Unagi (eel) | ¥2,500-6,000 | Traditional areas |
| Soba/Udon | ¥500-1,500 | Everywhere |
| Kaiseki | ¥15,000-50,000+ | Ginza, hotel restaurants |
| Izakaya | ¥2,500-5,000 | Everywhere |

### International Cuisine

Tokyo has exceptional:
- **French**: Refined, Michelin-heavy
- **Italian**: Adapted to Japanese tastes
- **Chinese**: Multiple regional styles
- **Korean**: Shin-Okubo area
- **Indian**: Nishi-Kasai area
- **Thai/Vietnamese**: Growing scene

## Budget Guide

### Student/Backpacker (¥1,500-2,500/day)
- Konbini (convenience store) meals: ¥300-600
- Chain restaurants (Yoshinoya, Sukiya): ¥500-800
- Standing ramen: ¥700-900
- Supermarket bento: ¥300-500

### Moderate (¥3,000-5,000/day)
- Lunch sets (teishoku): ¥1,000-1,500
- Mid-range ramen: ¥1,000-1,200
- Casual izakaya dinner: ¥2,500-4,000
- Quality konbini + one sit-down meal

### Comfortable (¥6,000-10,000/day)
- Nice lunch: ¥1,500-2,500
- Afternoon coffee/sweets: ¥800-1,200
- Quality dinner: ¥4,000-6,000
- Occasional splurge

### Splurge (¥15,000+/day)
- Sushi omakase lunch: ¥8,000-15,000
- High-end dinner: ¥15,000-30,000
- Fine dining: ¥30,000+

## Meal Timing

| Meal | Time | Notes |
|------|------|-------|
| Breakfast | 7:00-9:00 | Hotels, konbini, cafes |
| Lunch | 11:30-14:00 | Best value; lunch sets common |
| Tea time | 14:00-17:00 | Cafes, depachika |
| Dinner | 18:00-21:00 | Restaurants fill up 19:00-20:00 |
| Late night | 21:00-05:00 | Izakaya, ramen, konbini |

**Tip**: Lunch is significantly cheaper than dinner at the same restaurant. Many high-end places offer ¥1,500-3,000 lunch courses that cost ¥15,000+ at dinner.

## Restaurant Types

### By Service Style

| Type | Description | Price |
|------|-------------|-------|
| **Tachigui** (立ち食い) | Standing, eat quickly | ¥ |
| **Teishoku-ya** | Set meal restaurants | ¥¥ |
| **Izakaya** | Casual pub, shared dishes | ¥¥ |
| **Specialty shop** | One dish perfected | ¥¥-¥¥¥ |
| **Kaiseki** | Multi-course formal | ¥¥¥¥ |
| **Counter omakase** | Chef's choice at counter | ¥¥¥-¥¥¥¥ |

### By Setting

| Type | Description |
|------|-------------|
| **Department store restaurants** | Reliable, varied, often good views |
| **Train station restaurants** | Quick, convenient, surprisingly good |
| **Basement food halls (depachika)** | Takeaway heaven |
| **Yokocho** | Narrow alleys of small bars/eateries |
| **Shopping mall** | Chains and family-friendly |

## Booking & Reservations

### When to Book

| Restaurant Type | Booking Needed |
|-----------------|----------------|
| Casual ramen/chain | No, just queue |
| Mid-range izakaya | Same day or walk-in |
| Popular specialty shops | 1-3 days ahead |
| High-end sushi/kaiseki | 1-4 weeks ahead |
| Michelin 3-star | 1-2 months ahead |

### How to Book

**Options for foreigners:**
1. **Tabelog** (Japanese): Most comprehensive, needs basic Japanese
2. **Google Maps**: Easy, but limited inventory
3. **Hotel concierge**: Best for high-end, Japanese-speaking
4. **Omakase.in**: Sushi booking in English
5. **TableCheck/Pocket Concierge**: English booking platforms

**Cancellation**: Japanese restaurants take cancellations seriously. No-shows may result in charges and being banned.

## Dietary Restrictions

### Vegetarian/Vegan

**Challenge level**: Hard. Even "vegetable" dishes often use dashi (fish stock).

**Safe options**:
- Shojin ryori (Buddhist temple cuisine) — fully vegetarian
- Indian restaurants — vegetarian options
- Dedicated vegan restaurants (growing scene)
- Specify: 肉と魚なしで (niku to sakana nashi de) — no meat or fish

**Apps**: HappyCow, Vegewel

### Halal

**Options**:
- Halal-certified restaurants (especially around Asakusa)
- Some ramen shops have halal options
- Indian/Pakistani restaurants
- Self-catering from halal shops

### Allergies

**Common allergens in Japanese food:**
- Soy (shoyu in almost everything)
- Wheat (soy sauce, tempura, ramen)
- Shellfish/fish
- Eggs

**Communication**: Allergy cards in Japanese are essential. Print or show on phone.

## Money Matters

### Cash vs Card

- **Cash**: Still king, especially at small shops
- **Card**: Major chains, department stores accept
- **IC card (Suica/Pasmo)**: Konbini, some restaurants
- **PayPay/QR codes**: Growing rapidly

### Tipping

**Never tip.** Service charge is included. Attempting to tip may cause confusion or offense.

### Tax

- 10% consumption tax on dining in
- 8% on takeaway
- Many prices displayed are tax-inclusive, but check

## Seasonal Eating

| Season | Specialties |
|--------|-------------|
| **Spring** | Cherry blossom viewing (hanami) bento, bamboo shoots, strawberries |
| **Summer** | Cold noodles (hiyashi chuka, zaru soba), unagi, kakigori (shaved ice) |
| **Autumn** | Matsutake mushrooms, sanma (pacific saury), chestnuts |
| **Winter** | Hot pot (nabe), oden, oysters, fugu (pufferfish) |

## Food Safety

Tokyo is extremely safe for eating:
- Tap water is drinkable
- Street food is safe
- Raw fish is fresh and handled properly
- Food poisoning is rare

**Only consideration**: Check if you're comfortable with raw eggs (common in gyudon, sukiyaki, etc.)
