# Tokyo Markets & Depachika

## Major Food Markets

### Toyosu Market (豊洲市場)

**The new fish market** — Moved from Tsukiji in 2018.

**What it is**:
- World's largest wholesale fish market
- Professional buyers, early morning auctions
- Tourist-accessible areas and restaurants

**Visitor Info**:
- **Address**: Koto-ku, Toyosu 6-6-1
- **Access**: Shijo-mae Station (Yurikamome Line)
- **Hours**: 5:00-17:00 (closed Sundays, holidays, some Wednesdays)
- **Tuna auction viewing**: Reservations required, very early morning

**What to do**:
1. Watch tuna auction (book ahead)
2. Eat sushi at market restaurants (arrive early, expect lines)
3. Browse wholesale shops (some sell to public)
4. Visit rooftop for views

**Tips**:
- Arrive by 6:00-7:00 for shortest restaurant lines
- Weekdays less crowded than Saturdays
- Check closed days before visiting

---

### Tsukiji Outer Market (築地場外市場)

**Still alive and thriving** — Inner market moved, outer market stayed.

**What it is**:
- Streets of food vendors, restaurants, kitchen shops
- More tourist-friendly than Toyosu
- Mix of wholesale and retail

**Visitor Info**:
- **Address**: Chuo-ku, Tsukiji 4-16-2 area
- **Access**: Tsukiji Station (Hibiya), Tsukijishijo Station (Oedo)
- **Hours**: Most shops 5:00-14:00 (some close earlier)
- **Best time**: 8:00-11:00

**What to eat**:
- Fresh sushi and sashimi
- Tamagoyaki (sweet egg omelet)
- Seafood skewers
- Oysters
- Wagyu beef on sticks

**What to buy**:
- Kitchen knives (famous specialty)
- Cooking utensils
- Dried goods (nori, katsuobushi)
- Fresh produce

**Tips**:
- Come hungry, eat your way through
- Cash preferred
- Tuesday/Wednesday can be slow (wholesaler rest days)
- Watch for shop closing times (many close by 14:00)

---

### Ameyoko (アメ横)

**Ueno's famous shopping street** — Originally black market, now bargain paradise.

**What it is**:
- Chaotic market street near Ueno Station
- Mix of food, clothes, cosmetics, everything
- Bargaining culture (rare in Japan)

**Visitor Info**:
- **Address**: Between Ueno and Okachimachi Stations
- **Access**: Ueno or Okachimachi (JR)
- **Hours**: 10:00-20:00 (varies by shop)

**Food highlights**:
- Fresh seafood stalls
- Dried fruits and nuts (great deals)
- Street food snacks
- International foods
- Year-end osechi ingredients (December specialty)

**Tips**:
- Bargaining possible at some stalls
- Crowded on weekends and holidays
- Great for year-end shopping atmosphere

---

## Depachika (デパ地下)

**Department store basement food halls** — Where Tokyo does gourmet grocery.

### What Depachika Are

"Depa" (department store) + "chika" (basement) = Gourmet food wonderland.

Every major department store has a basement floor (sometimes two) dedicated to:
- Prepared foods (bento, salads, sides)
- Sweets and confections
- Bakeries
- Fresh produce
- Meat and seafood
- International foods

### Why They Matter

- **Quality**: Highest-end products, beautifully packaged
- **Gift culture**: Japanese gift-giving often involves depachika items
- **Variety**: Everything from ¥300 snacks to ¥30,000 melons
- **Time discounts**: 30-50% off prepared foods after 19:00

### Best Depachika

| Store | Location | Known For |
|-------|----------|-----------|
| **Isetan** | Shinjuku | Luxury, selection, innovation |
| **Mitsukoshi** | Ginza/Nihonbashi | Traditional, high-end |
| **Takashimaya** | Nihonbashi/Shinjuku | Classic luxury |
| **Daimaru** | Tokyo Station | Convenient, good bento |
| **Tokyu Food Show** | Shibuya | Trendy, accessible |
| **Seibu** | Ikebukuro | Large selection |

### Depachika Strategy

**For eating (budget meal)**:
1. Go after 19:00 for discounts (yellow stickers)
2. Grab a bento (¥600-1,200 normally, ¥400-800 discounted)
3. Add a side or salad
4. Find nearby park or station seating

**For gifts**:
- Wagashi (Japanese sweets) — classic gift
- Regional specialties — show thoughtfulness
- Seasonal items — always appreciated
- Individual-wrapped items — easy to share at office

**For sampling**:
- Free samples common, especially sweets
- Don't be shy to try before buying
- Weekend afternoons have most samples

---

## Specialty Markets

### Kappabashi (合羽橋)

**Kitchen Town** — Professional cooking equipment district.

**What to buy**:
- Japanese knives (world-famous quality)
- Plastic food samples (Japan specialty)
- Restaurant supplies
- Ceramics and tableware
- Cooking utensils

**Location**: Taito-ku, between Ueno and Asakusa
**Access**: Tawaramachi Station (Ginza Line)

### Nishiki Market Alternative

While Nishiki is in Kyoto, Tokyo's equivalent experiences:
- **Tsukiji Outer Market**: Fresh seafood focus
- **Yanaka Ginza**: Traditional shopping street
- **Sunamachi Ginza**: Local shopping street, budget

---

## Supermarkets

### Premium Supermarkets

| Name | Notable For | Where |
|------|-------------|-------|
| **National Azabu** | International imports | Hiroo (expat favorite) |
| **Kinokuniya** | High-end, premium selection | Aoyama, Shinjuku |
| **Seijo Ishii** | Quality imports, wine | Many locations |
| **Dean & Deluca** | Western gourmet | Shinagawa, etc. |

### Budget Supermarkets

| Name | Notable For | Savings |
|------|-------------|---------|
| **Gyomu Super** | Bulk, restaurant supply | 30-50% cheaper |
| **OK Store** | Consistently low prices | 20-30% cheaper |
| **Hanamasa** | Meat specialist, 24h | Good meat deals |
| **Seiyu** | Walmart-owned, low prices | General savings |

### Convenience Store Food (Konbini)

Japan's konbini food is legitimately good.

**Best chains for food**:
1. **Seven-Eleven**: Best prepared foods
2. **Lawson**: Good fried chicken, sweets
3. **FamilyMart**: Good bento selection

**What to get**:
- Onigiri (rice balls): ¥120-200
- Bento boxes: ¥400-700
- Sandwiches: ¥200-400
- Fresh-brewed coffee: ¥100-150
- Seasonal limited items: Always changing

---

## Market Etiquette

### Do
- Take photos where permitted (ask if unsure)
- Buy something if you sample extensively
- Queue properly
- Use cash at small vendors
- Say "oishii" (delicious) to vendors

### Don't
- Eat while walking (buy, stand aside, eat)
- Touch products you don't intend to buy
- Haggle (except Ameyoko)
- Block pathways for photos
- Expect English (prepare simple Japanese)
